/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core;

import org.apache.olingo.client.api.EdmEnabledODataClient;
import org.apache.olingo.client.api.communication.request.invoke.EdmEnabledInvokeRequestFactory;
import org.apache.olingo.client.api.communication.request.retrieve.EdmMetadataRequest;
import org.apache.olingo.client.api.communication.response.ODataRetrieveResponse;
import org.apache.olingo.client.api.uri.URIBuilder;
import org.apache.olingo.client.core.ODataClientImpl;
import org.apache.olingo.client.core.communication.request.invoke.EdmEnabledInvokeRequestFactoryImpl;
import org.apache.olingo.client.core.uri.URIBuilderImpl;
import org.apache.olingo.commons.api.edm.Edm;

public class EdmEnabledODataClientImpl
extends ODataClientImpl
implements EdmEnabledODataClient {
    private final String serviceRoot;
    private Edm edm;
    private String metadataETag;
    private EdmEnabledInvokeRequestFactory edmEnabledInvokeRequestFactory;

    public EdmEnabledODataClientImpl(String serviceRoot, Edm edm, String metadataETag) {
        this.serviceRoot = serviceRoot;
        this.edm = edm;
        this.metadataETag = metadataETag;
    }

    @Override
    public String getServiceRoot() {
        return this.serviceRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Edm getEdm(String metadataETag) {
        EdmEnabledODataClientImpl edmEnabledODataClientImpl = this;
        synchronized (edmEnabledODataClientImpl) {
            if (this.edm == null || metadataETag != null && !metadataETag.equals(this.metadataETag)) {
                EdmMetadataRequest metadataReq = this.getRetrieveRequestFactory().getMetadataRequest(this.serviceRoot);
                ODataRetrieveResponse metadataRes = (ODataRetrieveResponse)metadataReq.execute();
                this.metadataETag = metadataRes.getETag();
                this.edm = (Edm)metadataRes.getBody();
            }
        }
        return this.edm;
    }

    @Override
    public Edm getCachedEdm() {
        if (this.edm == null) {
            this.getEdm(null);
        }
        return this.edm;
    }

    @Override
    public URIBuilder newURIBuilder() {
        return new URIBuilderImpl(this.configuration, this.serviceRoot);
    }

    @Override
    public EdmEnabledInvokeRequestFactory getInvokeRequestFactory() {
        if (this.edmEnabledInvokeRequestFactory == null) {
            this.edmEnabledInvokeRequestFactory = new EdmEnabledInvokeRequestFactoryImpl(this);
        }
        return this.edmEnabledInvokeRequestFactory;
    }
}

