/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.exception;

import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAMessageService;
import org.apache.olingo.odata2.jpa.processor.core.ODataJPAContextImpl;

public class ODataJPAMessageServiceDefault
implements ODataJPAMessageService {
    private static final String BUNDLE_NAME = "jpaprocessor_msg";
    private static final Map<Locale, ODataJPAMessageService> LOCALE_2_MESSAGE_SERVICE = new HashMap<Locale, ODataJPAMessageService>();
    private static final ResourceBundle defaultResourceBundle = ResourceBundle.getBundle("jpaprocessor_msg");
    private final ResourceBundle resourceBundle;
    private final Locale lanLocale;

    public String getLocalizedMessage(MessageReference context, Throwable exception) {
        Object[] contentAsArray = context.getContent().toArray(new Object[0]);
        if (contentAsArray.length == 0 && exception != null) {
            contentAsArray = new Object[]{exception.getStackTrace()[1].getClassName(), exception.getMessage()};
        }
        String value = null;
        String key = context.getKey();
        try {
            value = this.getMessage(key);
            StringBuilder builder = new StringBuilder();
            Formatter f = null;
            f = this.lanLocale == null ? new Formatter() : new Formatter(builder, this.lanLocale);
            f.format(value, contentAsArray);
            f.close();
            return builder.toString();
        }
        catch (MissingResourceException e) {
            return "Missing message for key '" + key + "'!";
        }
        catch (MissingFormatArgumentException e) {
            return "Missing replacement for place holder in value '" + value + "' for following arguments '" + Arrays.toString(contentAsArray) + "'!";
        }
    }

    private ODataJPAMessageServiceDefault(ResourceBundle resourceBundle, Locale locale) {
        this.resourceBundle = resourceBundle;
        this.lanLocale = locale;
    }

    public static ODataJPAMessageService getInstance(Locale locale) {
        ODataJPAMessageService messagesInstance;
        Locale acceptedLocale = Locale.ENGLISH;
        if (ODataJPAContextImpl.getContextInThreadLocal() != null && ODataJPAContextImpl.getContextInThreadLocal().getAcceptableLanguages() != null) {
            List acceptedLanguages = ODataJPAContextImpl.getContextInThreadLocal().getAcceptableLanguages();
            for (Locale tempLocale : acceptedLanguages) {
                if (!ResourceBundle.getBundle(BUNDLE_NAME, tempLocale).getLocale().equals(tempLocale)) continue;
                acceptedLocale = tempLocale;
                break;
            }
        }
        if ((messagesInstance = LOCALE_2_MESSAGE_SERVICE.get(acceptedLocale)) == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, acceptedLocale);
            if (resourceBundle != null) {
                messagesInstance = new ODataJPAMessageServiceDefault(resourceBundle, acceptedLocale);
                LOCALE_2_MESSAGE_SERVICE.put(acceptedLocale, messagesInstance);
            } else if (defaultResourceBundle != null) {
                messagesInstance = new ODataJPAMessageServiceDefault(defaultResourceBundle, null);
            }
        }
        return messagesInstance;
    }

    private String getMessage(String key) {
        return this.resourceBundle.getString(key);
    }
}

