/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.checkpoint;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.server.common.CheckpointFile;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;

public class CheckpointFileWithFailureHandler<T> {
    public final File file;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String logDir;
    private final CheckpointFile<T> checkpointFile;

    public CheckpointFileWithFailureHandler(File file, int version, CheckpointFile.EntryFormatter<T> formatter, LogDirFailureChannel logDirFailureChannel, String logDir) throws IOException {
        this.file = file;
        this.logDirFailureChannel = logDirFailureChannel;
        this.logDir = logDir;
        this.checkpointFile = new CheckpointFile(file, version, formatter);
    }

    public void write(Collection<T> entries, boolean sync) {
        try {
            this.checkpointFile.write(entries, sync);
        }
        catch (IOException e) {
            String msg = "Error while writing to checkpoint file " + this.file.getAbsolutePath();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }

    public List<T> read() {
        try {
            return this.checkpointFile.read();
        }
        catch (IOException e) {
            String msg = "Error while reading checkpoint file " + this.file.getAbsolutePath();
            this.logDirFailureChannel.maybeAddOfflineLogDir(this.logDir, msg, e);
            throw new KafkaStorageException(msg, (Throwable)e);
        }
    }
}

