/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Function;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.JsonInput;

public class Command<X> {
    private final String method;
    private final Map<String, Object> params;
    private final Function<JsonInput, X> mapper;
    private final boolean sendsResponse;

    public Command(String method, Map<String, Object> params) {
        this(method, params, (Type)((Object)Object.class));
    }

    public Command(String method, Map<String, Object> params, Type typeOfX) {
        this(method, params, (JsonInput input) -> input.read((Type)Require.nonNull((String)"Type to convert to", (Object)typeOfX)));
    }

    public Command(String method, Map<String, Object> params, Function<JsonInput, X> mapper) {
        this(method, params, mapper, true);
    }

    private Command(String method, Map<String, Object> params, Function<JsonInput, X> mapper, boolean sendsResponse) {
        this.method = (String)Require.nonNull((String)"Method name", (Object)method);
        this.params = ImmutableMap.copyOf((Map)((Map)Require.nonNull((String)"Command parameters", params)));
        this.mapper = (Function)Require.nonNull((String)"Mapper for result", mapper);
        this.sendsResponse = sendsResponse;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    Function<JsonInput, X> getMapper() {
        return this.mapper;
    }

    public boolean getSendsResponse() {
        return this.sendsResponse;
    }

    public Command<X> doesNotSendResponse() {
        return new Command<X>(this.method, this.params, this.mapper, false);
    }
}

