/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.impl.CacheControlHeaderProvider;
import org.apache.cxf.jaxrs.impl.CookieHeaderProvider;
import org.apache.cxf.jaxrs.impl.DateHeaderProvider;
import org.apache.cxf.jaxrs.impl.EntityTagHeaderProvider;
import org.apache.cxf.jaxrs.impl.LinkBuilderImpl;
import org.apache.cxf.jaxrs.impl.LinkHeaderProvider;
import org.apache.cxf.jaxrs.impl.MediaTypeHeaderProvider;
import org.apache.cxf.jaxrs.impl.NewCookieHeaderProvider;
import org.apache.cxf.jaxrs.impl.ResponseBuilderImpl;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.impl.VariantListBuilderImpl;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public class RuntimeDelegateImpl
extends RuntimeDelegate {
    protected Map<Class<?>, RuntimeDelegate.HeaderDelegate<?>> headerProviders = new HashMap();

    public RuntimeDelegateImpl() {
        this.headerProviders.put(MediaType.class, new MediaTypeHeaderProvider());
        this.headerProviders.put(CacheControl.class, new CacheControlHeaderProvider());
        this.headerProviders.put(EntityTag.class, new EntityTagHeaderProvider());
        this.headerProviders.put(Cookie.class, new CookieHeaderProvider());
        this.headerProviders.put(NewCookie.class, new NewCookieHeaderProvider());
        this.headerProviders.put(Link.class, new LinkHeaderProvider());
        this.headerProviders.put(Date.class, new DateHeaderProvider());
    }

    public <T> T createInstance(Class<T> type) {
        if (type.isAssignableFrom(Response.ResponseBuilder.class)) {
            return type.cast(new ResponseBuilderImpl());
        }
        if (type.isAssignableFrom(UriBuilder.class)) {
            return type.cast(new UriBuilderImpl());
        }
        if (type.isAssignableFrom(Variant.VariantListBuilder.class)) {
            return type.cast((Object)new VariantListBuilderImpl());
        }
        return null;
    }

    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("HeaderDelegate type is null");
        }
        return this.headerProviders.get(type);
    }

    public Response.ResponseBuilder createResponseBuilder() {
        return new ResponseBuilderImpl();
    }

    public UriBuilder createUriBuilder() {
        return new UriBuilderImpl();
    }

    public Variant.VariantListBuilder createVariantListBuilder() {
        return new VariantListBuilderImpl();
    }

    public <T> T createEndpoint(Application app, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        if (app == null || !Server.class.isAssignableFrom(endpointType) && !JAXRSServerFactoryBean.class.isAssignableFrom(endpointType)) {
            throw new IllegalArgumentException();
        }
        JAXRSServerFactoryBean bean = ResourceUtils.createApplication(app, false, false, false, null);
        if (JAXRSServerFactoryBean.class.isAssignableFrom(endpointType)) {
            return endpointType.cast((Object)bean);
        }
        bean.setStart(false);
        Server server = bean.create();
        return endpointType.cast(server);
    }

    public Link.Builder createLinkBuilder() {
        return new LinkBuilderImpl();
    }
}

