/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Base64;
import java.util.Map;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.firefox.HasExtensions;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.http.HttpMethod;

@AutoService(value={AdditionalHttpCommands.class, AugmenterProvider.class})
public class AddHasExtensions
implements AugmenterProvider<HasExtensions>,
AdditionalHttpCommands {
    public static final String INSTALL_EXTENSION = "installExtension";
    public static final String UNINSTALL_EXTENSION = "uninstallExtension";
    private static final Map<String, CommandInfo> COMMANDS = ImmutableMap.of((Object)"installExtension", (Object)new CommandInfo("/session/:sessionId/moz/addon/install", HttpMethod.POST), (Object)"uninstallExtension", (Object)new CommandInfo("/session/:sessionId/moz/addon/uninstall", HttpMethod.POST));

    public Map<String, CommandInfo> getAdditionalCommands() {
        return COMMANDS;
    }

    public Predicate<Capabilities> isApplicable() {
        return arg_0 -> ((Browser)Browser.FIREFOX).is(arg_0);
    }

    public Class<HasExtensions> getDescribedInterface() {
        return HasExtensions.class;
    }

    public HasExtensions getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasExtensions(){

            @Override
            public String installExtension(Path path) {
                return this.installExtension(path, false);
            }

            @Override
            public String installExtension(Path path, Boolean temporary) {
                String encoded;
                Require.nonNull((String)"Extension Path", (Object)path);
                Require.nonNull((String)"Temporary", (Object)temporary);
                try {
                    encoded = Files.isDirectory(path, new LinkOption[0]) ? Base64.getEncoder().encodeToString(Files.readAllBytes(this.zipDirectory(path))) : Base64.getEncoder().encodeToString(Files.readAllBytes(path));
                }
                catch (IOException e) {
                    throw new InvalidArgumentException(path + " is an invalid path", (Throwable)e);
                }
                return (String)executeMethod.execute(AddHasExtensions.INSTALL_EXTENSION, (Map)ImmutableMap.of((Object)"addon", (Object)encoded, (Object)"temporary", (Object)temporary));
            }

            private Path zipDirectory(final Path path) throws IOException {
                Path extZip = Paths.get(path.getFileName().toString() + ".zip", new String[0]);
                try (final ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(extZip.toFile()));){
                    Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            zos.putNextEntry(new ZipEntry(path.relativize(file).toString()));
                            Files.copy(file, zos);
                            zos.closeEntry();
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                return extZip;
            }

            @Override
            public void uninstallExtension(String extensionId) {
                Require.nonNull((String)"Extension ID", (Object)extensionId);
                executeMethod.execute(AddHasExtensions.UNINSTALL_EXTENSION, (Map)ImmutableMap.of((Object)"id", (Object)extensionId));
            }
        };
    }
}

