/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import com.google.common.base.Charsets;
import com.google.common.primitives.Ints;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.archive.io.CharSubSequence;
import org.archive.io.ReplayCharSequence;
import org.archive.util.DevUtils;

public class GenericReplayCharSequence
implements ReplayCharSequence {
    protected static Logger logger = Logger.getLogger(GenericReplayCharSequence.class.getName());
    public static final Charset WRITE_ENCODING = Charsets.UTF_16BE;
    private static final long MAP_MAX_BYTES = 0x4000000L;
    private static final long MAP_TARGET_LEFT_PADDING_BYTES = 671088L;
    protected int length;
    protected long decodingExceptions = 0L;
    protected CharacterCodingException codingException = null;
    private long mapByteOffset;
    private FileInputStream backingFileIn = null;
    private FileChannel backingFileChannel = null;
    private long bytesPerChar;
    private CharBuffer mappedBuffer = null;
    private File decodedFile = null;
    private CharBuffer prefixBuffer = null;
    private boolean isOpen = true;
    protected Charset charset = null;

    public GenericReplayCharSequence(InputStream contentReplayInputStream, int prefixMax, String backingFilename, Charset charset) throws IOException {
        logger.fine("characterEncoding=" + charset + " backingFilename=" + backingFilename);
        if (charset == null) {
            charset = ReplayCharSequence.FALLBACK_CHARSET;
        }
        this.decode(contentReplayInputStream, prefixMax, backingFilename, charset);
        this.bytesPerChar = 2L;
        if (this.length > this.prefixBuffer.position()) {
            this.backingFileIn = new FileInputStream(this.decodedFile);
            this.backingFileChannel = this.backingFileIn.getChannel();
            this.mapByteOffset = 0L;
            this.updateMemoryMappedBuffer();
        }
    }

    private void updateMemoryMappedBuffer() {
        long charLength = (long)this.length() - (long)this.prefixBuffer.limit();
        long mapSize = Math.min(charLength * this.bytesPerChar - this.mapByteOffset, 0x4000000L);
        logger.fine("updateMemoryMappedBuffer: mapOffset=" + NumberFormat.getInstance().format(this.mapByteOffset) + " mapSize=" + NumberFormat.getInstance().format(mapSize));
        try {
            this.mappedBuffer = this.backingFileChannel.map(FileChannel.MapMode.READ_ONLY, this.mapByteOffset, mapSize).asReadOnlyBuffer().asCharBuffer();
        }
        catch (IOException e) {
            DevUtils.logger.log(Level.SEVERE, " backingFileChannel.map() mapByteOffset=" + this.mapByteOffset + " mapSize=" + mapSize + "\ndecodedFile=" + this.decodedFile + " length=" + this.length + "\n" + DevUtils.extraInfo(), e);
            throw new RuntimeException(e);
        }
    }

    protected void decode(InputStream inStream, int prefixMax, String backingFilename, Charset charset) throws IOException {
        long count;
        int read;
        this.charset = charset;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, charset));
        logger.fine("backingFilename=" + backingFilename + " encoding=" + charset + " decodedFile=" + this.decodedFile);
        this.prefixBuffer = CharBuffer.allocate(prefixMax);
        for (count = 0L; count < (long)prefixMax && (read = reader.read(this.prefixBuffer)) >= 0; count += (long)read) {
        }
        int ch = reader.read();
        if (ch >= 0) {
            FileOutputStream fos;
            ++count;
            this.decodedFile = new File(backingFilename + "." + WRITE_ENCODING);
            try {
                fos = new FileOutputStream(this.decodedFile);
            }
            catch (FileNotFoundException e) {
                System.gc();
                System.runFinalization();
                this.decodedFile = new File(this.decodedFile.getAbsolutePath() + ".win");
                logger.info("Windows 'file with a user-mapped section open' workaround gc/finalization/name-extension performed.");
                fos = new FileOutputStream(this.decodedFile);
            }
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, WRITE_ENCODING);
            ((Writer)writer).write(ch);
            count += IOUtils.copyLarge((Reader)reader, (Writer)writer);
            ((Writer)writer).close();
            reader.close();
        }
        this.length = Ints.saturatedCast((long)count);
        if (count > Integer.MAX_VALUE) {
            logger.warning("input stream is longer than Integer.MAX_VALUE=" + NumberFormat.getInstance().format(Integer.MAX_VALUE) + " characters -- only first " + NumberFormat.getInstance().format(Integer.MAX_VALUE) + " are accessible through this GenericReplayCharSequence");
        }
        logger.fine("decode: decoded " + count + " characters" + (this.decodedFile == null ? "" : " (" + (count - (long)this.prefixBuffer.length()) + " to " + this.decodedFile + ")"));
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("index=" + index + " - should be between 0 and length()=" + this.length());
        }
        if (index < this.prefixBuffer.limit()) {
            return this.prefixBuffer.get(index);
        }
        long charFileIndex = (long)index - (long)this.prefixBuffer.limit();
        long charFileLength = (long)this.length() - (long)this.prefixBuffer.limit();
        if (charFileIndex * this.bytesPerChar < this.mapByteOffset) {
            logger.log(Level.WARNING, "left-fault; probably don't want to use CharSequence that far backward");
        }
        if (charFileIndex * this.bytesPerChar < this.mapByteOffset || charFileIndex - this.mapByteOffset / this.bytesPerChar >= (long)this.mappedBuffer.limit()) {
            this.mapByteOffset = Math.min(charFileIndex * this.bytesPerChar - 671088L, charFileLength * this.bytesPerChar - 0x4000000L);
            this.mapByteOffset = Math.max(0L, this.mapByteOffset);
            this.updateMemoryMappedBuffer();
        }
        return this.mappedBuffer.get((int)(charFileIndex - this.mapByteOffset / this.bytesPerChar));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CharSubSequence(this, start, end);
    }

    private void deleteFile(File fileToDelete) {
        this.deleteFile(fileToDelete, null);
    }

    private void deleteFile(File fileToDelete, Exception e) {
        if (e != null) {
            logger.severe("Deleting " + fileToDelete + " because of " + e.toString());
        }
        if (fileToDelete != null && fileToDelete.exists()) {
            logger.fine("deleting file: " + fileToDelete);
            fileToDelete.delete();
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
        logger.fine("closing");
        if (this.backingFileChannel != null && this.backingFileChannel.isOpen()) {
            this.backingFileChannel.close();
        }
        if (this.backingFileIn != null) {
            this.backingFileIn.close();
        }
        this.deleteFile(this.decodedFile);
        this.decodedFile = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        logger.fine("finalizing");
        this.close();
    }

    public String substring(int offset, int len) {
        return this.subSequence(offset, offset + len).toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.length());
        sb.append(this);
        return sb.toString();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public long getDecodeExceptionCount() {
        return this.decodingExceptions;
    }

    @Override
    public CharacterCodingException getCodingException() {
        return this.codingException;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }
}

