/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip.zipnum;

import java.io.IOException;
import java.util.logging.Logger;
import org.archive.format.cdx.CDXInputSource;
import org.archive.format.gzip.zipnum.LineBufferingIterator;
import org.archive.format.gzip.zipnum.MultiBlockIterator;
import org.archive.format.gzip.zipnum.SummaryBlockIterator;
import org.archive.format.gzip.zipnum.TimestampDedupIterator;
import org.archive.format.gzip.zipnum.ZipNumBlockLoader;
import org.archive.format.gzip.zipnum.ZipNumParams;
import org.archive.util.GeneralURIStreamFactory;
import org.archive.util.binsearch.FieldExtractingSLR;
import org.archive.util.binsearch.SeekableLineReader;
import org.archive.util.binsearch.SortedTextFile;
import org.archive.util.iterator.BoundedStringIterator;
import org.archive.util.iterator.CloseableIterator;
import org.archive.util.iterator.StartBoundedStringIterator;

public class ZipNumIndex
implements CDXInputSource {
    static final Logger LOGGER = Logger.getLogger(ZipNumIndex.class.getName());
    protected String pathRoot;
    protected String summaryFile;
    protected int binsearchBlockSize = 8192;
    protected int readaheadSize = 512;
    protected SortedTextFile summary;
    protected boolean required = true;
    protected ZipNumBlockLoader blockLoader;
    protected int cdxLinesPerBlock = 3000;
    protected long cdxLinesTotalCount = 0L;
    protected static final boolean DEFAULT_USE_NIO = true;
    private static final int LINE_COUNT_FIELD = 4;
    protected boolean useNio = true;

    public void init() throws IOException {
        if (this.summaryFile != null) {
            this.summary = new SortedTextFile(GeneralURIStreamFactory.createSeekableStreamFactory(this.summaryFile, this.readaheadSize, this.useNio));
            this.summary.setBinsearchBlockSize(this.binsearchBlockSize);
        }
        if (this.blockLoader == null) {
            this.blockLoader = new ZipNumBlockLoader();
        }
    }

    public static ZipNumIndex createIndexWithSummaryPath(String summaryFile) throws IOException {
        ZipNumIndex zipIndex = new ZipNumIndex();
        zipIndex.setSummaryFile(summaryFile);
        zipIndex.init();
        return zipIndex;
    }

    public static ZipNumIndex createIndexWithBasePath(String pathRoot) throws IOException {
        ZipNumIndex zipIndex = new ZipNumIndex();
        zipIndex.setPathRoot(pathRoot);
        zipIndex.init();
        return zipIndex;
    }

    public static int extractLineCount(String line) {
        return (int)ZipNumIndex.extractLongField(line, 4);
    }

    protected static long extractLongField(String line, int index) {
        String[] parts = line.split("\t");
        if (parts.length <= index) {
            return -1L;
        }
        long count = -1L;
        try {
            count = Long.parseLong(parts[index]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return count;
    }

    public int getNumLines(String[] blocks) {
        if (blocks.length < 2) {
            return 0;
        }
        int lastLine = -1;
        int line = -1;
        int size = 0;
        for (String block : blocks) {
            lastLine = line;
            line = ZipNumIndex.extractLineCount(block);
            if (lastLine < 0) continue;
            size += line - lastLine;
        }
        return size;
    }

    public long getTotalLength(String[] blocks) {
        long size = 0L;
        for (String block : blocks) {
            size += ZipNumIndex.extractLongField(block, 3);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumLines(String start, String end) throws IOException {
        SeekableLineReader slr = null;
        String startLine = null;
        String endLine = null;
        int startCount = 0;
        int endCount = 0;
        try {
            slr = this.summary.getSLR();
            long[] offsets = this.summary.getStartEndOffsets(slr, start, end);
            if (offsets[0] > 0L) {
                slr.seek(offsets[0]);
                slr.readLine();
                startLine = slr.readLine();
            }
            if (offsets[1] < slr.getSize()) {
                slr.seek(offsets[1]);
                slr.readLine();
                endLine = slr.readLine();
            }
            if (endLine == null) {
                endLine = this.summary.getLastLine(slr);
            }
            if (endLine != null) {
                endCount = ZipNumIndex.extractLineCount(endLine);
            }
            if (startLine != null) {
                startCount = ZipNumIndex.extractLineCount(startLine);
            }
        }
        finally {
            if (slr != null) {
                slr.close();
            }
        }
        return endCount - startCount;
    }

    public PageResult getNthPage(String[] startEnd, int page, int pageSize, boolean numPagesOnly) throws IOException {
        String[] startEndIdx = this.getSummary().getRange(startEnd[0], startEnd[1]);
        int firstLineNumber = ZipNumIndex.extractLineCount(startEndIdx[0]);
        int endLineNumber = ZipNumIndex.extractLineCount(startEndIdx[1]) + 1;
        int totalLines = endLineNumber - firstLineNumber;
        int numPages = (totalLines - 1) / pageSize + 1;
        if (numPages < 1) {
            numPages = 1;
        }
        if (numPagesOnly) {
            return new PageResult(null, numPages);
        }
        if (page >= numPages) {
            return new PageResult(null, numPages);
        }
        int firstPageLineNumber = page * pageSize + firstLineNumber;
        int lastPageLineNumber = Math.min(firstPageLineNumber + pageSize, endLineNumber);
        if (page > 0) {
            startEndIdx[0] = this.getNthLine("" + firstPageLineNumber, 4);
        }
        boolean endInclusive = false;
        if (page < numPages - 1) {
            startEndIdx[1] = this.getNthLine("" + lastPageLineNumber, 4);
        } else {
            endInclusive = true;
        }
        CloseableIterator<String> blocklines = this.getClusterRange(startEndIdx[0], startEndIdx[1], endInclusive, false);
        return new PageResult(blocklines, numPages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNthLine(String lineNumber, int lineField) throws IOException {
        try (SeekableLineReader slr = null;){
            String currLineNumber;
            slr = this.summary.getSLR();
            FieldExtractingSLR lineCountReader = new FieldExtractingSLR(slr, lineField, "\t");
            long offset = this.summary.binaryFindOffset(lineCountReader, lineNumber, SortedTextFile.numericComparator);
            slr.seek(offset);
            if (offset > 0L) {
                slr.skipLine();
            }
            String fullLine = null;
            String prevLine = null;
            do {
                prevLine = fullLine;
                fullLine = slr.readLine();
                if (fullLine != null) continue;
                fullLine = prevLine;
                break;
            } while (SortedTextFile.numericComparator.compare(lineNumber, currLineNumber = fullLine.split("\t")[lineField]) > 0);
            String string = fullLine;
            return string;
        }
    }

    public long getEstimateSplitSize(String[] blocks) {
        String[] parts = null;
        String[] lastParts = null;
        long totalSize = 0L;
        for (String block : blocks) {
            lastParts = parts;
            parts = block.split("\t");
            if (lastParts == null || parts.length < 3 || lastParts.length < 3) continue;
            long newOffset = Long.parseLong(parts[2]);
            if (parts[1].equals(lastParts[1])) {
                long lastOffset = Long.parseLong(lastParts[2]);
                totalSize += newOffset - lastOffset;
                continue;
            }
            totalSize += newOffset;
        }
        return totalSize;
    }

    public CloseableIterator<String> getClusterRange(String start, String end, boolean inclusive, boolean includePrevLine) throws IOException {
        CloseableIterator<String> iter = null;
        iter = this.summary.getRecordIterator(start, includePrevLine);
        return ZipNumIndex.wrapEndIterator(iter, end, inclusive);
    }

    public static CloseableIterator<String> wrapStartEndIterator(CloseableIterator<String> iter, String start, String end, boolean inclusive) {
        return ZipNumIndex.wrapEndIterator(ZipNumIndex.wrapStartIterator(iter, start), end, inclusive);
    }

    public static CloseableIterator<String> wrapReverseIterator(CloseableIterator<String> iter, String start, String end) {
        iter = new StartBoundedStringIterator(iter, end, true);
        iter = new BoundedStringIterator(iter, start, false, true);
        return iter;
    }

    public static CloseableIterator<String> wrapStartIterator(CloseableIterator<String> iter, String start) {
        return new StartBoundedStringIterator(iter, start);
    }

    public static CloseableIterator<String> wrapEndIterator(CloseableIterator<String> iter, String end, boolean inclusive) {
        if (end.isEmpty()) {
            return iter;
        }
        return new BoundedStringIterator(iter, end, inclusive);
    }

    public CloseableIterator<String> getCDXIterator(CloseableIterator<String> summaryIterator, String start, String end, int split, int numSplits) {
        return this.getCDXIterator(summaryIterator, start, end, split, numSplits, null);
    }

    public CloseableIterator<String> getCDXIterator(CloseableIterator<String> summaryIterator, String start, String end, int split, int numSplits, ZipNumParams params) {
        CloseableIterator<String> blocklines = this.getCDXIterator(summaryIterator, params);
        if (split == 0 && start != null && !start.isEmpty()) {
            blocklines = ZipNumIndex.wrapStartIterator(blocklines, start);
        }
        if (split >= numSplits - 1 && end != null && !end.isEmpty()) {
            blocklines = ZipNumIndex.wrapEndIterator(blocklines, end, false);
        }
        return blocklines;
    }

    public static String endKey(String key) {
        return key + "!";
    }

    public CloseableIterator<String> getLastBlockCDXLineIterator(String key) throws IOException {
        CloseableIterator<String> summaryIter = this.summary.getRecordIteratorLT(ZipNumIndex.endKey(key));
        return ZipNumIndex.wrapStartIterator(this.getCDXIterator(summaryIter), key);
    }

    public static CloseableIterator<String> wrapPrefix(CloseableIterator<String> source, String prefix, boolean exact) {
        if (exact) {
            return ZipNumIndex.wrapEndIterator(source, ZipNumIndex.endKey(prefix), false);
        }
        return ZipNumIndex.wrapEndIterator(source, prefix, true);
    }

    @Override
    public CloseableIterator<String> getCDXIterator(String key, String start, String end, ZipNumParams params) throws IOException {
        CloseableIterator<String> summaryIter = this.summary.getRecordIteratorLT(key);
        if (params.getTimestampDedupLength() > 0) {
            summaryIter = new TimestampDedupIterator(summaryIter, params.getTimestampDedupLength());
        }
        if (end != null && !end.isEmpty()) {
            summaryIter = ZipNumIndex.wrapEndIterator(summaryIter, end, false);
        }
        if (this.blockLoader.isBufferFully() && params != null && params.getMaxBlocks() > 0) {
            LineBufferingIterator lineBufferIter = new LineBufferingIterator(summaryIter, params.getMaxBlocks(), params.isReverse());
            lineBufferIter.bufferInput();
            summaryIter = lineBufferIter;
        }
        if (params.isReverse()) {
            return ZipNumIndex.wrapReverseIterator(this.getCDXIterator(summaryIter, params), start, ZipNumIndex.endKey(key));
        }
        return ZipNumIndex.wrapStartEndIterator(this.getCDXIterator(summaryIter, params), start, end, false);
    }

    @Override
    public CloseableIterator<String> getCDXIterator(String key, String start, boolean exact, ZipNumParams params) throws IOException {
        CloseableIterator<String> summaryIter = this.summary.getRecordIteratorLT(key);
        if (params.getTimestampDedupLength() > 0) {
            summaryIter = new TimestampDedupIterator(summaryIter, params.getTimestampDedupLength());
        }
        summaryIter = ZipNumIndex.wrapPrefix(summaryIter, start, exact);
        if (this.blockLoader.isBufferFully() && params != null && params.getMaxBlocks() > 0) {
            LineBufferingIterator lineBufferIter = new LineBufferingIterator(summaryIter, params.getMaxBlocks(), params.isReverse());
            lineBufferIter.bufferInput();
            summaryIter = lineBufferIter;
        }
        return ZipNumIndex.wrapStartIterator(this.getCDXIterator(summaryIter, params), start);
    }

    public CloseableIterator<String> getCDXIterator(String key, ZipNumParams params) throws IOException {
        CloseableIterator<String> summaryIter = this.summary.getRecordIteratorLT(key);
        return ZipNumIndex.wrapStartIterator(this.getCDXIterator(summaryIter, params), key);
    }

    public CloseableIterator<String> getCDXIterator(CloseableIterator<String> summaryIterator, ZipNumParams params) {
        SummaryBlockIterator blockIter = new SummaryBlockIterator(summaryIterator, this, params);
        MultiBlockIterator zipIter = new MultiBlockIterator(blockIter);
        return zipIter;
    }

    public CloseableIterator<String> getCDXIterator(CloseableIterator<String> summaryIterator) {
        return this.getCDXIterator(summaryIterator, null);
    }

    public void setSummaryFile(String summaryFile) {
        this.summaryFile = summaryFile;
    }

    public String getSummaryFile() {
        return this.summaryFile;
    }

    public SortedTextFile getSummary() {
        return this.summary;
    }

    public ZipNumBlockLoader getBlockLoader() {
        return this.blockLoader;
    }

    public int getBinsearchBlockSize() {
        return this.binsearchBlockSize;
    }

    public void setBinsearchBlockSize(int binsearchBlockSize) {
        this.binsearchBlockSize = binsearchBlockSize;
    }

    public int getReadaheadSize() {
        return this.readaheadSize;
    }

    public void setReadaheadSize(int readaheadSize) {
        this.readaheadSize = readaheadSize;
    }

    public void setBlockLoader(ZipNumBlockLoader blockLoader) {
        this.blockLoader = blockLoader;
    }

    public boolean isUseNio() {
        return this.useNio;
    }

    public void setUseNio(boolean useNio) {
        this.useNio = useNio;
    }

    public int getCdxLinesPerBlock() {
        return this.cdxLinesPerBlock;
    }

    public void setCdxLinesPerBlock(int cdxLinesPerBlock) {
        this.cdxLinesPerBlock = cdxLinesPerBlock;
    }

    String getReaderPath(String partId) {
        if (this.pathRoot == null) {
            int lastSlash = this.summaryFile.lastIndexOf(47);
            this.pathRoot = this.summaryFile.substring(0, lastSlash + 1);
        }
        if (!partId.endsWith(".gz")) {
            partId = partId + ".gz";
        }
        String gzFile = this.pathRoot + partId;
        return gzFile;
    }

    SeekableLineReader doBlockLoad(String partId, long startOffset, int totalLength) {
        String path = this.getReaderPath(partId);
        return this.blockLoader.attemptLoadBlock(path, startOffset, totalLength, true, this.isRequired());
    }

    public String getPathRoot() {
        return this.pathRoot;
    }

    public void setPathRoot(String pathRoot) {
        this.pathRoot = pathRoot;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public long getTotalLines() {
        return this.cdxLinesTotalCount;
    }

    public static class PageResult {
        public final CloseableIterator<String> iter;
        public final int numPages;

        PageResult(CloseableIterator<String> iter, int numPages) {
            this.iter = iter;
            this.numPages = numPages;
        }
    }
}

