/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.convert;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.convert.ArrayToDelimitedStringConverter;
import org.springframework.boot.convert.CharArrayFormatter;
import org.springframework.boot.convert.CharSequenceToObjectConverter;
import org.springframework.boot.convert.CollectionToDelimitedStringConverter;
import org.springframework.boot.convert.DelimitedStringToArrayConverter;
import org.springframework.boot.convert.DelimitedStringToCollectionConverter;
import org.springframework.boot.convert.DurationToNumberConverter;
import org.springframework.boot.convert.DurationToStringConverter;
import org.springframework.boot.convert.InetAddressFormatter;
import org.springframework.boot.convert.InputStreamSourceToByteArrayConverter;
import org.springframework.boot.convert.IsoOffsetFormatter;
import org.springframework.boot.convert.LenientBooleanToEnumConverterFactory;
import org.springframework.boot.convert.LenientStringToEnumConverterFactory;
import org.springframework.boot.convert.NumberToDataSizeConverter;
import org.springframework.boot.convert.NumberToDurationConverter;
import org.springframework.boot.convert.NumberToPeriodConverter;
import org.springframework.boot.convert.PeriodToStringConverter;
import org.springframework.boot.convert.StringToDataSizeConverter;
import org.springframework.boot.convert.StringToDurationConverter;
import org.springframework.boot.convert.StringToFileConverter;
import org.springframework.boot.convert.StringToPeriodConverter;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class ApplicationConversionService
extends FormattingConversionService {
    private static final ResolvableType STRING = ResolvableType.forClass(String.class);
    private static volatile ApplicationConversionService sharedInstance;
    private final boolean unmodifiable;

    public ApplicationConversionService() {
        this(null);
    }

    public ApplicationConversionService(StringValueResolver embeddedValueResolver) {
        this(embeddedValueResolver, false);
    }

    private ApplicationConversionService(StringValueResolver embeddedValueResolver, boolean unmodifiable) {
        if (embeddedValueResolver != null) {
            this.setEmbeddedValueResolver(embeddedValueResolver);
        }
        ApplicationConversionService.configure((FormatterRegistry)this);
        this.unmodifiable = unmodifiable;
    }

    public void addPrinter(Printer<?> printer) {
        this.assertModifiable();
        super.addPrinter(printer);
    }

    public void addParser(Parser<?> parser) {
        this.assertModifiable();
        super.addParser(parser);
    }

    public void addFormatter(Formatter<?> formatter) {
        this.assertModifiable();
        super.addFormatter(formatter);
    }

    public void addFormatterForFieldType(Class<?> fieldType, Formatter<?> formatter) {
        this.assertModifiable();
        super.addFormatterForFieldType(fieldType, formatter);
    }

    public void addConverter(Converter<?, ?> converter) {
        this.assertModifiable();
        super.addConverter(converter);
    }

    public void addFormatterForFieldType(Class<?> fieldType, Printer<?> printer, Parser<?> parser) {
        this.assertModifiable();
        super.addFormatterForFieldType(fieldType, printer, parser);
    }

    public void addFormatterForFieldAnnotation(AnnotationFormatterFactory<? extends Annotation> annotationFormatterFactory) {
        this.assertModifiable();
        super.addFormatterForFieldAnnotation(annotationFormatterFactory);
    }

    public <S, T> void addConverter(Class<S> sourceType, Class<T> targetType, Converter<? super S, ? extends T> converter) {
        this.assertModifiable();
        super.addConverter(sourceType, targetType, converter);
    }

    public void addConverter(GenericConverter converter) {
        this.assertModifiable();
        super.addConverter(converter);
    }

    public void addConverterFactory(ConverterFactory<?, ?> factory) {
        this.assertModifiable();
        super.addConverterFactory(factory);
    }

    public void removeConvertible(Class<?> sourceType, Class<?> targetType) {
        this.assertModifiable();
        super.removeConvertible(sourceType, targetType);
    }

    private void assertModifiable() {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException("This ApplicationConversionService cannot be modified");
        }
    }

    public boolean isConvertViaObjectSourceType(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Set pairs;
        GenericConverter converter = this.getConverter(sourceType, targetType);
        Set set = pairs = converter != null ? converter.getConvertibleTypes() : null;
        if (pairs != null) {
            for (GenericConverter.ConvertiblePair pair : pairs) {
                if (!Object.class.equals((Object)pair.getSourceType())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConversionService getSharedInstance() {
        ApplicationConversionService sharedInstance = ApplicationConversionService.sharedInstance;
        if (sharedInstance != null) return sharedInstance;
        Class<ApplicationConversionService> clazz = ApplicationConversionService.class;
        synchronized (ApplicationConversionService.class) {
            sharedInstance = ApplicationConversionService.sharedInstance;
            if (sharedInstance != null) return sharedInstance;
            ApplicationConversionService.sharedInstance = sharedInstance = new ApplicationConversionService(null, true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sharedInstance;
        }
    }

    public static void configure(FormatterRegistry registry) {
        DefaultConversionService.addDefaultConverters((ConverterRegistry)registry);
        DefaultFormattingConversionService.addDefaultFormatters((FormatterRegistry)registry);
        ApplicationConversionService.addApplicationFormatters(registry);
        ApplicationConversionService.addApplicationConverters((ConverterRegistry)registry);
    }

    public static void addApplicationConverters(ConverterRegistry registry) {
        ApplicationConversionService.addDelimitedStringConverters(registry);
        registry.addConverter((GenericConverter)new StringToDurationConverter());
        registry.addConverter((GenericConverter)new DurationToStringConverter());
        registry.addConverter((GenericConverter)new NumberToDurationConverter());
        registry.addConverter((GenericConverter)new DurationToNumberConverter());
        registry.addConverter((GenericConverter)new StringToPeriodConverter());
        registry.addConverter((GenericConverter)new PeriodToStringConverter());
        registry.addConverter((GenericConverter)new NumberToPeriodConverter());
        registry.addConverter((GenericConverter)new StringToDataSizeConverter());
        registry.addConverter((GenericConverter)new NumberToDataSizeConverter());
        registry.addConverter((Converter)new StringToFileConverter());
        registry.addConverter((Converter)new InputStreamSourceToByteArrayConverter());
        registry.addConverterFactory((ConverterFactory)new LenientStringToEnumConverterFactory());
        registry.addConverterFactory((ConverterFactory)new LenientBooleanToEnumConverterFactory());
        if (registry instanceof ConversionService) {
            ConversionService conversionService = (ConversionService)registry;
            ApplicationConversionService.addApplicationConverters(registry, conversionService);
        }
    }

    private static void addApplicationConverters(ConverterRegistry registry, ConversionService conversionService) {
        registry.addConverter((GenericConverter)new CharSequenceToObjectConverter(conversionService));
    }

    public static void addDelimitedStringConverters(ConverterRegistry registry) {
        ConversionService service = (ConversionService)registry;
        registry.addConverter((GenericConverter)new ArrayToDelimitedStringConverter(service));
        registry.addConverter((GenericConverter)new CollectionToDelimitedStringConverter(service));
        registry.addConverter((GenericConverter)new DelimitedStringToArrayConverter(service));
        registry.addConverter((GenericConverter)new DelimitedStringToCollectionConverter(service));
    }

    public static void addApplicationFormatters(FormatterRegistry registry) {
        registry.addFormatter((Formatter)new CharArrayFormatter());
        registry.addFormatter((Formatter)new InetAddressFormatter());
        registry.addFormatter((Formatter)new IsoOffsetFormatter());
    }

    public static void addBeans(FormatterRegistry registry, ListableBeanFactory beanFactory) {
        ApplicationConversionService.addBeans(registry, beanFactory, null);
    }

    public static Map<String, Object> addBeans(FormatterRegistry registry, ListableBeanFactory beanFactory, String qualifier) {
        ConfigurableListableBeanFactory configurableBeanFactory = ApplicationConversionService.getConfigurableListableBeanFactory(beanFactory);
        Map<String, Object> beans = ApplicationConversionService.getBeans(beanFactory, qualifier);
        beans.forEach((beanName, bean) -> {
            BeanDefinition beanDefinition = configurableBeanFactory != null ? configurableBeanFactory.getMergedBeanDefinition(beanName) : null;
            ResolvableType type = beanDefinition != null ? beanDefinition.getResolvableType() : null;
            ApplicationConversionService.addBean(registry, bean, type);
        });
        return beans;
    }

    private static ConfigurableListableBeanFactory getConfigurableListableBeanFactory(ListableBeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext applicationContext = (ConfigurableApplicationContext)beanFactory;
            return applicationContext.getBeanFactory();
        }
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory configurableListableBeanFactory = (ConfigurableListableBeanFactory)beanFactory;
            return configurableListableBeanFactory;
        }
        return null;
    }

    private static Map<String, Object> getBeans(ListableBeanFactory beanFactory, String qualifier) {
        LinkedHashMap<String, Object> beans = new LinkedHashMap<String, Object>();
        beans.putAll(ApplicationConversionService.getBeans(beanFactory, Printer.class, qualifier));
        beans.putAll(ApplicationConversionService.getBeans(beanFactory, Parser.class, qualifier));
        beans.putAll(ApplicationConversionService.getBeans(beanFactory, Formatter.class, qualifier));
        beans.putAll(ApplicationConversionService.getBeans(beanFactory, Converter.class, qualifier));
        beans.putAll(ApplicationConversionService.getBeans(beanFactory, ConverterFactory.class, qualifier));
        beans.putAll(ApplicationConversionService.getBeans(beanFactory, GenericConverter.class, qualifier));
        return beans;
    }

    private static <T> Map<String, T> getBeans(ListableBeanFactory beanFactory, Class<T> type, String qualifier) {
        return !StringUtils.hasLength((String)qualifier) ? beanFactory.getBeansOfType(type) : BeanFactoryAnnotationUtils.qualifiedBeansOfType((ListableBeanFactory)beanFactory, type, (String)qualifier);
    }

    static void addBean(FormatterRegistry registry, Object bean, ResolvableType beanType) {
        if (bean instanceof GenericConverter) {
            GenericConverter converterBean = (GenericConverter)bean;
            ApplicationConversionService.addBean(registry, converterBean, beanType, GenericConverter.class, arg_0 -> ((FormatterRegistry)registry).addConverter(arg_0), (Runnable)null);
        } else if (bean instanceof Converter) {
            Converter converterBean = (Converter)bean;
            ApplicationConversionService.addBean(registry, converterBean, beanType, Converter.class, arg_0 -> ((FormatterRegistry)registry).addConverter(arg_0), ConverterBeanAdapter::new);
        } else if (bean instanceof ConverterFactory) {
            ConverterFactory converterBean = (ConverterFactory)bean;
            ApplicationConversionService.addBean(registry, converterBean, beanType, ConverterFactory.class, arg_0 -> ((FormatterRegistry)registry).addConverterFactory(arg_0), ConverterFactoryBeanAdapter::new);
        } else if (bean instanceof Formatter) {
            Formatter formatterBean = (Formatter)bean;
            ApplicationConversionService.addBean(registry, formatterBean, beanType, Formatter.class, arg_0 -> ((FormatterRegistry)registry).addFormatter(arg_0), () -> {
                registry.addConverter((GenericConverter)new PrinterBeanAdapter((Printer<?>)formatterBean, beanType));
                registry.addConverter((GenericConverter)new ParserBeanAdapter((Parser<?>)formatterBean, beanType));
            });
        } else if (bean instanceof Printer) {
            Printer printerBean = (Printer)bean;
            ApplicationConversionService.addBean(registry, printerBean, beanType, Printer.class, arg_0 -> ((FormatterRegistry)registry).addPrinter(arg_0), PrinterBeanAdapter::new);
        } else if (bean instanceof Parser) {
            Parser parserBean = (Parser)bean;
            ApplicationConversionService.addBean(registry, parserBean, beanType, Parser.class, arg_0 -> ((FormatterRegistry)registry).addParser(arg_0), ParserBeanAdapter::new);
        }
    }

    private static <B, T> void addBean(FormatterRegistry registry, B bean, ResolvableType beanType, Class<T> type, Consumer<B> standardRegistrar, BiFunction<B, ResolvableType, BeanAdapter<?>> beanAdapterFactory) {
        ApplicationConversionService.addBean(registry, bean, beanType, type, standardRegistrar, () -> registry.addConverter((GenericConverter)beanAdapterFactory.apply(bean, beanType)));
    }

    private static <B, T> void addBean(FormatterRegistry registry, B bean, ResolvableType beanType, Class<T> type, Consumer<B> standardRegistrar, Runnable beanAdapterRegistrar) {
        if (beanType != null && beanAdapterRegistrar != null && ResolvableType.forInstance(bean).as(type).hasUnresolvableGenerics()) {
            beanAdapterRegistrar.run();
            return;
        }
        standardRegistrar.accept(bean);
    }

    static class PrinterBeanAdapter
    extends BeanAdapter<Printer<?>> {
        PrinterBeanAdapter(Printer<?> bean, ResolvableType beanType) {
            super(bean, beanType);
        }

        @Override
        protected ResolvableTypePair getResolvableTypePair(ResolvableType[] generics) {
            return new ResolvableTypePair(generics[0], STRING);
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source != null ? this.print(source) : "";
        }

        private String print(Object object) {
            return ((Printer)this.bean()).print(object, LocaleContextHolder.getLocale());
        }
    }

    static class ParserBeanAdapter
    extends BeanAdapter<Parser<?>> {
        ParserBeanAdapter(Parser<?> bean, ResolvableType beanType) {
            super(bean, beanType);
        }

        @Override
        protected ResolvableTypePair getResolvableTypePair(ResolvableType[] generics) {
            return new ResolvableTypePair(STRING, generics[0]);
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            String text = (String)source;
            return !StringUtils.hasText((String)text) ? null : this.parse(text);
        }

        private Object parse(String text) {
            try {
                return ((Parser)this.bean()).parse(text, LocaleContextHolder.getLocale());
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Parse attempt failed for value [" + text + "]", ex);
            }
        }
    }

    record ResolvableTypePair(ResolvableType source, ResolvableType target) {
        ResolvableTypePair {
            Assert.notNull((Object)source.resolve(), (String)"'source' cannot be resolved");
            Assert.notNull((Object)target.resolve(), (String)"'target' cannot be resolved");
        }

        @Override
        public final String toString() {
            return String.valueOf(this.source()) + " -> " + String.valueOf(this.target());
        }
    }

    private static final class ConverterFactoryBeanAdapter
    extends BeanAdapter<ConverterFactory<?, ?>> {
        ConverterFactoryBeanAdapter(ConverterFactory<?, ?> bean, ResolvableType beanType) {
            super(bean, beanType);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (!super.matches(sourceType, targetType)) return false;
            if (!this.conditionalConverterCandidateMatches(this.bean(), sourceType, targetType)) return false;
            if (!this.conditionalConverterCandidateMatches(this.getConverter(() -> ((TypeDescriptor)targetType).getType()), sourceType, targetType)) return false;
            return true;
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return this.convert(source, targetType, this.getConverter(() -> ((TypeDescriptor)targetType).getObjectType()));
        }

        private Converter<Object, ?> getConverter(Supplier<Class<?>> typeSupplier) {
            return ((ConverterFactory)this.bean()).getConverter(typeSupplier.get());
        }
    }

    static final class ConverterBeanAdapter
    extends BeanAdapter<Converter<?, ?>> {
        ConverterBeanAdapter(Converter<?, ?> bean, ResolvableType beanType) {
            super(bean, beanType);
        }

        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return super.matches(sourceType, targetType) && this.conditionalConverterCandidateMatches(this.bean(), sourceType, targetType);
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return this.convert(source, targetType, (Converter)this.bean());
        }
    }

    static abstract class BeanAdapter<B>
    implements ConditionalGenericConverter {
        private final B bean;
        private final ResolvableTypePair types;

        BeanAdapter(B bean, ResolvableType beanType) {
            Assert.isInstanceOf((Class)beanType.toClass(), bean);
            ResolvableType type = ResolvableType.forClass(this.getClass()).as(BeanAdapter.class).getGeneric(new int[0]);
            ResolvableType[] generics = beanType.as(type.toClass()).getGenerics();
            this.bean = bean;
            this.types = this.getResolvableTypePair(generics);
        }

        protected ResolvableTypePair getResolvableTypePair(ResolvableType[] generics) {
            return new ResolvableTypePair(generics[0], generics[1]);
        }

        protected B bean() {
            return this.bean;
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Set.of(new GenericConverter.ConvertiblePair(this.types.source().toClass(), this.types.target().toClass()));
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return this.types.target().toClass() == targetType.getObjectType() && this.matchesTargetType(targetType.getResolvableType());
        }

        private boolean matchesTargetType(ResolvableType targetType) {
            ResolvableType ours = this.types.target();
            return targetType.getType() instanceof Class || targetType.isAssignableFrom(ours) || this.types.target().hasUnresolvableGenerics();
        }

        protected final boolean conditionalConverterCandidateMatches(Object conditionalConverterCandidate, TypeDescriptor sourceType, TypeDescriptor targetType) {
            boolean bl;
            if (conditionalConverterCandidate instanceof ConditionalConverter) {
                ConditionalConverter conditionalConverter = (ConditionalConverter)conditionalConverterCandidate;
                bl = conditionalConverter.matches(sourceType, targetType);
            } else {
                bl = true;
            }
            return bl;
        }

        protected final Object convert(Object source, TypeDescriptor targetType, Converter<?, ?> converter) {
            return source != null ? converter.convert(source) : this.convertNull(targetType);
        }

        private Object convertNull(TypeDescriptor targetType) {
            return targetType.getObjectType() != Optional.class ? null : Optional.empty();
        }

        public String toString() {
            return String.valueOf(this.types) + " : " + String.valueOf(this.bean);
        }
    }
}

