/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.conn.ManagedNHttpClientConnection;
import org.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.util.EntityUtils;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.remote.Peer;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.client.http.TransportProtocolVersionNegotiator;
import org.apache.nifi.remote.exception.HandshakeException;
import org.apache.nifi.remote.exception.PortNotRunningException;
import org.apache.nifi.remote.exception.ProtocolException;
import org.apache.nifi.remote.exception.UnknownPortException;
import org.apache.nifi.remote.io.http.HttpCommunicationsSession;
import org.apache.nifi.remote.io.http.HttpInput;
import org.apache.nifi.remote.io.http.HttpOutput;
import org.apache.nifi.remote.protocol.CommunicationsSession;
import org.apache.nifi.remote.protocol.ResponseCode;
import org.apache.nifi.remote.protocol.http.HttpProxy;
import org.apache.nifi.remote.util.ExtendTransactionCommand;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.security.cert.StandardPrincipalFormatter;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.web.api.dto.ControllerDTO;
import org.apache.nifi.web.api.dto.remote.PeerDTO;
import org.apache.nifi.web.api.entity.ControllerEntity;
import org.apache.nifi.web.api.entity.PeersEntity;
import org.apache.nifi.web.api.entity.TransactionResultEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteToSiteRestApiClient
implements Closeable {
    private static final String EVENT_CATEGORY = "Site-to-Site";
    private static final int DATA_PACKET_CHANNEL_READ_BUFFER_SIZE = 16384;
    private static final int RESPONSE_CODE_OK = 200;
    private static final int RESPONSE_CODE_CREATED = 201;
    private static final int RESPONSE_CODE_ACCEPTED = 202;
    private static final int RESPONSE_CODE_BAD_REQUEST = 400;
    private static final int RESPONSE_CODE_FORBIDDEN = 403;
    private static final int RESPONSE_CODE_NOT_FOUND = 404;
    private static final Logger logger = LoggerFactory.getLogger(SiteToSiteRestApiClient.class);
    private String baseUrl;
    protected final SSLContext sslContext;
    protected final HttpProxy proxy;
    private final AtomicBoolean proxyAuthRequiresResend = new AtomicBoolean(false);
    private final EventReporter eventReporter;
    private RequestConfig requestConfig;
    private CredentialsProvider credentialsProvider;
    private CloseableHttpClient httpClient;
    private CloseableHttpAsyncClient httpAsyncClient;
    private boolean compress = false;
    private InetAddress localAddress = null;
    private long requestExpirationMillis = 0L;
    private int serverTransactionTtl = 0;
    private int batchCount = 0;
    private long batchSize = 0L;
    private long batchDurationMillis = 0L;
    private final TransportProtocolVersionNegotiator transportProtocolVersionNegotiator = new TransportProtocolVersionNegotiator(1);
    private String trustedPeerDn;
    private final ScheduledExecutorService ttlExtendTaskExecutor;
    private ScheduledFuture<?> ttlExtendingFuture;
    private int connectTimeoutMillis;
    private int readTimeoutMillis;
    private long cacheExpirationMillis = 30000L;
    private static final Pattern HTTP_ABS_URL = Pattern.compile("^https?://.+$");
    private Future<HttpResponse> postResult;
    private CountDownLatch transferDataLatch = new CountDownLatch(1);
    private static final ConcurrentMap<String, RemoteGroupContents> contentsMap = new ConcurrentHashMap<String, RemoteGroupContents>();
    private volatile long lastPruneTimestamp = System.currentTimeMillis();

    public SiteToSiteRestApiClient(SSLContext sslContext, HttpProxy proxy, EventReporter eventReporter) {
        this.sslContext = sslContext;
        this.proxy = proxy;
        this.eventReporter = eventReporter;
        this.ttlExtendTaskExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(this){
            private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.defaultFactory.newThread(r);
                thread.setName(Thread.currentThread().getName() + " Site-to-Site Extend Transactions");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.stopExtendingTransaction();
        this.closeSilently((Closeable)this.httpClient);
        this.closeSilently((Closeable)this.httpAsyncClient);
    }

    private CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.setupClient();
        }
        return this.httpClient;
    }

    private CloseableHttpAsyncClient getHttpAsyncClient() {
        if (this.httpAsyncClient == null) {
            this.setupAsyncClient();
        }
        return this.httpAsyncClient;
    }

    private RequestConfig getRequestConfig() {
        if (this.requestConfig == null) {
            this.setupRequestConfig();
        }
        return this.requestConfig;
    }

    private CredentialsProvider getCredentialsProvider() {
        if (this.credentialsProvider == null) {
            this.setupCredentialsProvider();
        }
        return this.credentialsProvider;
    }

    private void setupRequestConfig() {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(this.connectTimeoutMillis).setConnectTimeout(this.connectTimeoutMillis).setSocketTimeout(this.readTimeoutMillis);
        if (this.localAddress != null) {
            requestConfigBuilder.setLocalAddress(this.localAddress);
        }
        if (this.proxy != null) {
            requestConfigBuilder.setProxy(this.proxy.getHttpHost());
        }
        this.requestConfig = requestConfigBuilder.build();
    }

    private void setupCredentialsProvider() {
        this.credentialsProvider = new BasicCredentialsProvider();
        if (this.proxy != null && !StringUtils.isEmpty((CharSequence)this.proxy.getUsername()) && !StringUtils.isEmpty((CharSequence)this.proxy.getPassword())) {
            this.credentialsProvider.setCredentials(new AuthScope(this.proxy.getHttpHost()), (Credentials)new UsernamePasswordCredentials(this.proxy.getUsername(), this.proxy.getPassword()));
        }
    }

    private void setupClient() {
        HttpClientBuilder clientBuilder = HttpClients.custom();
        if (this.sslContext != null) {
            clientBuilder.setSSLContext(this.sslContext);
            clientBuilder.addInterceptorFirst((HttpResponseInterceptor)new HttpsResponseInterceptor());
        }
        this.httpClient = clientBuilder.setDefaultCredentialsProvider(this.getCredentialsProvider()).build();
    }

    private void setupAsyncClient() {
        HttpAsyncClientBuilder clientBuilder = HttpAsyncClients.custom();
        if (this.sslContext != null) {
            clientBuilder.setSSLContext(this.sslContext);
            clientBuilder.addInterceptorFirst((HttpResponseInterceptor)new HttpsResponseInterceptor());
        }
        this.httpAsyncClient = clientBuilder.setDefaultCredentialsProvider(this.getCredentialsProvider()).build();
        this.httpAsyncClient.start();
    }

    public ControllerDTO getController(String clusterUrls) throws IOException {
        return this.getController(SiteToSiteRestApiClient.parseClusterUrls(clusterUrls));
    }

    public ControllerDTO getController(Set<String> clusterUrls) throws IOException {
        IOException lastException = null;
        for (String clusterUrl : clusterUrls) {
            this.setBaseUrl(SiteToSiteRestApiClient.resolveBaseUrl(clusterUrl));
            try {
                return this.getController();
            }
            catch (IOException e) {
                lastException = e;
                logger.warn("Failed to get controller from {}", (Object)clusterUrl, (Object)e);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("", (Throwable)e);
            }
        }
        if (clusterUrls.size() > 1) {
            throw new IOException("Tried all cluster URLs but none of those was accessible. Last Exception was " + String.valueOf(lastException), lastException);
        }
        throw lastException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ControllerDTO getController() throws IOException {
        String internedUrl;
        if (System.currentTimeMillis() > this.lastPruneTimestamp + TimeUnit.MINUTES.toMillis(5L)) {
            this.pruneCache();
        }
        String string = internedUrl = this.baseUrl.intern();
        synchronized (string) {
            RemoteGroupContents groupContents = (RemoteGroupContents)contentsMap.get(internedUrl);
            if (groupContents == null || groupContents.getContents() == null || groupContents.isOlderThan(this.cacheExpirationMillis)) {
                ControllerDTO refreshedContents;
                logger.debug("No Contents for remote group at URL {} or contents have expired; will refresh contents", (Object)internedUrl);
                try {
                    refreshedContents = this.fetchController();
                }
                catch (Exception e) {
                    ControllerDTO existingController = groupContents == null ? null : groupContents.getContents();
                    RemoteGroupContents updatedContents = new RemoteGroupContents(existingController);
                    contentsMap.put(internedUrl, updatedContents);
                    throw e;
                }
                logger.debug("Successfully retrieved contents for remote group at URL {}", (Object)internedUrl);
                RemoteGroupContents updatedContents = new RemoteGroupContents(refreshedContents);
                contentsMap.put(internedUrl, updatedContents);
                return refreshedContents;
            }
            logger.debug("Contents for remote group at URL {} have already been fetched and have not yet expired. Will return the cached value.", (Object)internedUrl);
            return groupContents.getContents();
        }
    }

    private ControllerDTO fetchController() throws IOException {
        try {
            HttpGet get = this.createGetControllerRequest();
            return this.execute(get, ControllerEntity.class).getController();
        }
        catch (HttpGetFailedException e) {
            if (404 == e.getResponseCode()) {
                logger.debug("getController received NOT_FOUND, trying to access the old NiFi version resource url...");
                HttpGet get = this.createGet("/controller");
                return this.execute(get, ControllerEntity.class).getController();
            }
            throw e;
        }
    }

    private void pruneCache() {
        for (Map.Entry entry : contentsMap.entrySet()) {
            String url = (String)entry.getKey();
            RemoteGroupContents contents = (RemoteGroupContents)entry.getValue();
            if (!contents.isOlderThan(TimeUnit.MINUTES.toMillis(5L))) continue;
            contentsMap.remove(url, contents);
        }
    }

    private HttpGet createGetControllerRequest() {
        HttpGet get = this.createGet("/site-to-site");
        get.setHeader("x-nifi-site-to-site-protocol-version", String.valueOf(this.transportProtocolVersionNegotiator.getVersion()));
        return get;
    }

    public Collection<PeerDTO> getPeers() throws IOException {
        HttpGet get = this.createGet("/site-to-site/peers");
        get.setHeader("x-nifi-site-to-site-protocol-version", String.valueOf(this.transportProtocolVersionNegotiator.getVersion()));
        return this.execute(get, PeersEntity.class).getPeers();
    }

    public String initiateTransaction(TransferDirection direction, String portId) throws IOException {
        String transactionUrl;
        String portType = TransferDirection.RECEIVE.equals((Object)direction) ? "output-ports" : "input-ports";
        logger.debug("initiateTransaction handshaking portType={}, portId={}", (Object)portType, (Object)portId);
        HttpPost post = this.createPost("/data-transfer/" + portType + "/" + portId + "/transactions");
        post.setHeader("Accept", "application/json");
        post.setHeader("x-nifi-site-to-site-protocol-version", String.valueOf(this.transportProtocolVersionNegotiator.getVersion()));
        this.setHandshakeProperties((HttpRequestBase)post);
        HttpResponse response = TransferDirection.RECEIVE.equals((Object)direction) ? this.initiateTransactionForReceive(post) : this.initiateTransactionForSend(post);
        int responseCode = response.getStatusLine().getStatusCode();
        logger.debug("initiateTransaction responseCode={}", (Object)responseCode);
        switch (responseCode) {
            case 201: {
                EntityUtils.consume((HttpEntity)response.getEntity());
                transactionUrl = this.readTransactionUrl(response);
                if (StringUtils.isEmpty((CharSequence)transactionUrl)) {
                    throw new ProtocolException("Server returned RESPONSE_CODE_CREATED without Location header");
                }
                Header transportProtocolVersionHeader = response.getFirstHeader("x-nifi-site-to-site-protocol-version");
                if (transportProtocolVersionHeader == null) {
                    throw new ProtocolException("Server didn't return confirmed protocol version");
                }
                int protocolVersionConfirmedByServer = Integer.parseInt(transportProtocolVersionHeader.getValue());
                logger.debug("Finished version negotiation, protocolVersionConfirmedByServer={}", (Object)protocolVersionConfirmedByServer);
                this.transportProtocolVersionNegotiator.setVersion(protocolVersionConfirmedByServer);
                Header serverTransactionTtlHeader = response.getFirstHeader("x-nifi-site-to-site-server-transaction-ttl");
                if (serverTransactionTtlHeader == null) {
                    throw new ProtocolException("Server didn't return x-nifi-site-to-site-server-transaction-ttl");
                }
                this.serverTransactionTtl = Integer.parseInt(serverTransactionTtlHeader.getValue());
                break;
            }
            default: {
                InputStream content = response.getEntity().getContent();
                try {
                    throw this.handleErrResponse(responseCode, content);
                }
                catch (Throwable throwable) {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        logger.debug("initiateTransaction handshaking finished, transactionUrl={}", (Object)transactionUrl);
        return transactionUrl;
    }

    private HttpResponse initiateTransactionForReceive(HttpPost post) throws IOException {
        return this.getHttpClient().execute((HttpUriRequest)post);
    }

    private HttpResponse initiateTransactionForSend(final HttpPost post) throws IOException {
        HttpResponse response;
        if (this.shouldCheckProxyAuth()) {
            CloseableHttpAsyncClient asyncClient = this.getHttpAsyncClient();
            HttpGet get = this.createGetControllerRequest();
            Future getResult = asyncClient.execute((HttpUriRequest)get, null);
            try {
                HttpResponse getResponse = (HttpResponse)getResult.get(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
                logger.debug("Proxy auth check has done. getResponse={}", (Object)getResponse.getStatusLine());
            }
            catch (ExecutionException e) {
                logger.debug("Something has happened at get controller requesting thread for proxy auth check. {}", (Object)e.getMessage());
                throw this.toIOException(e);
            }
            catch (InterruptedException | TimeoutException e) {
                throw new IOException(e);
            }
        }
        HttpAsyncRequestProducer asyncRequestProducer = new HttpAsyncRequestProducer(){
            private boolean requestHasBeenReset = false;

            public HttpHost getTarget() {
                return URIUtils.extractHost((URI)post.getURI());
            }

            public HttpRequest generateRequest() {
                BasicHttpEntity entity = new BasicHttpEntity();
                post.setEntity((HttpEntity)entity);
                return post;
            }

            public void produceContent(ContentEncoder encoder, IOControl ioctrl) throws IOException {
                encoder.complete();
                if (SiteToSiteRestApiClient.this.shouldCheckProxyAuth() && this.requestHasBeenReset) {
                    logger.debug("Produced content again, assuming the proxy server requires authentication.");
                    SiteToSiteRestApiClient.this.proxyAuthRequiresResend.set(true);
                }
            }

            public void requestCompleted(HttpContext context) {
                SiteToSiteRestApiClient.this.debugProxyAuthState(context);
            }

            public void failed(Exception ex) {
                String msg = String.format("Failed to create transaction for %s", post.getURI());
                logger.error(msg, (Throwable)ex);
                SiteToSiteRestApiClient.this.eventReporter.reportEvent(Severity.WARNING, SiteToSiteRestApiClient.EVENT_CATEGORY, msg);
            }

            public boolean isRepeatable() {
                return true;
            }

            public void resetRequest() {
                this.requestHasBeenReset = true;
            }

            public void close() {
            }
        };
        Future responseFuture = this.getHttpAsyncClient().execute(asyncRequestProducer, (HttpAsyncResponseConsumer)new BasicAsyncResponseConsumer(), null);
        try {
            response = (HttpResponse)responseFuture.get(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            logger.debug("Something has happened at initiate transaction requesting thread. {}", (Object)e.getMessage());
            throw this.toIOException(e);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IOException(e);
        }
        return response;
    }

    private void debugProxyAuthState(HttpContext context) {
        AuthState proxyAuthState;
        if (this.shouldCheckProxyAuth() && logger.isDebugEnabled() && (proxyAuthState = (AuthState)context.getAttribute("http.auth.proxy-scope")) != null) {
            logger.debug("authProxyScope={}", (Object)proxyAuthState);
        }
    }

    private IOException toIOException(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            return (IOException)cause;
        }
        return new IOException(cause);
    }

    private boolean shouldCheckProxyAuth() {
        return this.proxy != null && !StringUtils.isEmpty((CharSequence)this.proxy.getUsername());
    }

    public boolean openConnectionForReceive(String transactionUrl, Peer peer) throws IOException {
        HttpGet get = this.createGet(transactionUrl + "/flow-files");
        ((HttpCommunicationsSession)peer.getCommunicationsSession()).setDataTransferUrl(get.getURI().toString());
        get.setHeader("x-nifi-site-to-site-protocol-version", String.valueOf(this.transportProtocolVersionNegotiator.getVersion()));
        this.setHandshakeProperties((HttpRequestBase)get);
        final CloseableHttpResponse response = this.getHttpClient().execute((HttpUriRequest)get);
        int responseCode = response.getStatusLine().getStatusCode();
        logger.debug("responseCode={}", (Object)responseCode);
        boolean keepItOpen = false;
        try {
            switch (responseCode) {
                case 200: {
                    logger.debug("Server returned RESPONSE_CODE_OK, indicating there was no data.");
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    boolean bl = false;
                    return bl;
                }
                case 202: {
                    final InputStream httpIn = response.getEntity().getContent();
                    InputStream streamCapture = new InputStream(){
                        boolean closed = false;

                        @Override
                        public int read() throws IOException {
                            if (this.closed) {
                                return -1;
                            }
                            int r = httpIn.read();
                            if (r < 0) {
                                this.closed = true;
                                logger.debug("Reached to end of input stream. Closing resources...");
                                SiteToSiteRestApiClient.this.stopExtendingTransaction();
                                SiteToSiteRestApiClient.this.closeSilently(httpIn);
                                SiteToSiteRestApiClient.this.closeSilently((Closeable)response);
                            }
                            return r;
                        }
                    };
                    ((HttpInput)peer.getCommunicationsSession().getInput()).setInputStream(streamCapture);
                    this.startExtendingTransaction(transactionUrl);
                    keepItOpen = true;
                    boolean bl = true;
                    return bl;
                }
            }
            InputStream content = response.getEntity().getContent();
            try {
                throw this.handleErrResponse(responseCode, content);
            }
            catch (Throwable throwable) {
                if (content != null) {
                    try {
                        content.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            if (!keepItOpen) {
                response.close();
            }
        }
    }

    public void openConnectionForSend(String transactionUrl, Peer peer) throws IOException {
        final CommunicationsSession commSession = peer.getCommunicationsSession();
        final String flowFilesPath = transactionUrl + "/flow-files";
        final HttpPost post = this.createPost(flowFilesPath);
        ((HttpCommunicationsSession)peer.getCommunicationsSession()).setDataTransferUrl(post.getURI().toString());
        post.setHeader("Content-Type", "application/octet-stream");
        post.setHeader("Accept", "text/plain");
        post.setHeader("x-nifi-site-to-site-protocol-version", String.valueOf(this.transportProtocolVersionNegotiator.getVersion()));
        this.setHandshakeProperties((HttpRequestBase)post);
        final CountDownLatch initConnectionLatch = new CountDownLatch(1);
        final URI requestUri = post.getURI();
        final PipedOutputStream outputStream = new PipedOutputStream();
        PipedInputStream inputStream = new PipedInputStream(outputStream, 16384);
        final ReadableByteChannel dataPacketChannel = Channels.newChannel(inputStream);
        HttpAsyncRequestProducer asyncRequestProducer = new HttpAsyncRequestProducer(){
            private final ByteBuffer buffer = ByteBuffer.allocate(16384);
            private long totalRead = 0L;
            private long totalProduced = 0L;
            private boolean requestHasBeenReset = false;
            private final AtomicBoolean bufferHasRemainingData = new AtomicBoolean(false);

            public HttpHost getTarget() {
                return URIUtils.extractHost((URI)requestUri);
            }

            public HttpRequest generateRequest() {
                logger.debug("sending data to {} has started...", (Object)flowFilesPath);
                ((HttpOutput)commSession.getOutput()).setOutputStream(outputStream);
                initConnectionLatch.countDown();
                BasicHttpEntity entity = new BasicHttpEntity();
                entity.setChunked(true);
                entity.setContentType("application/octet-stream");
                post.setEntity((HttpEntity)entity);
                return post;
            }

            public void produceContent(ContentEncoder encoder, IOControl ioControl) throws IOException {
                int read;
                if (SiteToSiteRestApiClient.this.shouldCheckProxyAuth() && SiteToSiteRestApiClient.this.proxyAuthRequiresResend.get() && !this.requestHasBeenReset) {
                    logger.debug("Need authentication with proxy server. Postpone producing content.");
                    encoder.complete();
                    return;
                }
                if (this.bufferHasRemainingData.get()) {
                    this.writeBuffer(encoder);
                    if (this.bufferHasRemainingData.get()) {
                        return;
                    }
                }
                if ((read = dataPacketChannel.read(this.buffer)) > -1) {
                    logger.trace("Read {} bytes from dataPacketChannel. {}", (Object)read, (Object)flowFilesPath);
                    this.totalRead += (long)read;
                    this.buffer.flip();
                    this.writeBuffer(encoder);
                } else {
                    long totalWritten = commSession.getOutput().getBytesWritten();
                    logger.debug("sending data to {} has reached to its end. produced {} bytes by reading {} bytes from channel. {} bytes written in this transaction.", new Object[]{flowFilesPath, this.totalProduced, this.totalRead, totalWritten});
                    if (this.totalRead != totalWritten || this.totalProduced != totalWritten) {
                        String msg = "Sending data to %s has reached to its end, but produced : read : wrote byte sizes (%d : %d : %d) were not equal. Something went wrong.";
                        throw new RuntimeException(String.format("Sending data to %s has reached to its end, but produced : read : wrote byte sizes (%d : %d : %d) were not equal. Something went wrong.", flowFilesPath, this.totalProduced, this.totalRead, totalWritten));
                    }
                    SiteToSiteRestApiClient.this.transferDataLatch.countDown();
                    encoder.complete();
                    dataPacketChannel.close();
                }
            }

            private void writeBuffer(ContentEncoder encoder) throws IOException {
                while (this.buffer.hasRemaining()) {
                    int written = encoder.write(this.buffer);
                    logger.trace("written {} bytes to encoder.", (Object)written);
                    if (written == 0) {
                        logger.trace("Buffer still has remaining. {}", (Object)this.buffer);
                        this.bufferHasRemainingData.set(true);
                        return;
                    }
                    this.totalProduced += (long)written;
                }
                this.bufferHasRemainingData.set(false);
                this.buffer.clear();
            }

            public void requestCompleted(HttpContext context) {
                logger.debug("Sending data to {} completed.", (Object)flowFilesPath);
                SiteToSiteRestApiClient.this.debugProxyAuthState(context);
            }

            public void failed(Exception ex) {
                String msg = String.format("Failed to send data to %s due to %s", flowFilesPath, ex.toString());
                logger.error(msg, (Throwable)ex);
                SiteToSiteRestApiClient.this.eventReporter.reportEvent(Severity.WARNING, SiteToSiteRestApiClient.EVENT_CATEGORY, msg);
            }

            public boolean isRepeatable() {
                return true;
            }

            public void resetRequest() {
                logger.debug("Sending data request to {} has been reset...", (Object)flowFilesPath);
                this.requestHasBeenReset = true;
            }

            public void close() {
                logger.debug("Closing sending data request to {}", (Object)flowFilesPath);
                SiteToSiteRestApiClient.this.closeSilently(outputStream);
                SiteToSiteRestApiClient.this.closeSilently(dataPacketChannel);
                SiteToSiteRestApiClient.this.stopExtendingTransaction();
            }
        };
        this.postResult = this.getHttpAsyncClient().execute(asyncRequestProducer, (HttpAsyncResponseConsumer)new BasicAsyncResponseConsumer(), null);
        try {
            if (!initConnectionLatch.await(this.connectTimeoutMillis, TimeUnit.MILLISECONDS)) {
                throw new IOException("Awaiting initConnectionLatch has been timeout.");
            }
            this.transferDataLatch = new CountDownLatch(1);
            this.startExtendingTransaction(transactionUrl);
        }
        catch (InterruptedException e) {
            throw new IOException("Awaiting initConnectionLatch has been interrupted.", e);
        }
    }

    public void finishTransferFlowFiles(CommunicationsSession commSession) throws IOException {
        HttpResponse response;
        if (this.postResult == null) {
            new IllegalStateException("Data transfer has not started yet.");
        }
        commSession.getOutput().getOutputStream().close();
        logger.debug("{} FinishTransferFlowFiles no more data can be sent", (Object)this);
        try {
            if (!this.transferDataLatch.await(this.requestExpirationMillis, TimeUnit.MILLISECONDS)) {
                throw new IOException("Awaiting transferDataLatch has been timeout.");
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Awaiting transferDataLatch has been interrupted.", e);
        }
        this.stopExtendingTransaction();
        try {
            response = this.postResult.get(this.readTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            logger.debug("Something has happened at sending data thread. {}", (Object)e.getMessage());
            throw this.toIOException(e);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new IOException(e);
        }
        int responseCode = response.getStatusLine().getStatusCode();
        switch (responseCode) {
            case 202: {
                String receivedChecksum = EntityUtils.toString((HttpEntity)response.getEntity());
                ((HttpInput)commSession.getInput()).setInputStream(new ByteArrayInputStream(receivedChecksum.getBytes()));
                ((HttpCommunicationsSession)commSession).setChecksum(receivedChecksum);
                logger.debug("receivedChecksum={}", (Object)receivedChecksum);
                break;
            }
            default: {
                InputStream content = response.getEntity().getContent();
                try {
                    throw this.handleErrResponse(responseCode, content);
                }
                catch (Throwable throwable) {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    private void startExtendingTransaction(String transactionUrl) {
        if (this.ttlExtendingFuture != null) {
            return;
        }
        int extendFrequency = this.serverTransactionTtl / 2;
        logger.debug("Extend Transaction Started [{}] Frequency [{} seconds]", (Object)transactionUrl, (Object)extendFrequency);
        ExtendTransactionCommand command = new ExtendTransactionCommand(this, transactionUrl, this.eventReporter);
        this.ttlExtendingFuture = this.ttlExtendTaskExecutor.scheduleWithFixedDelay(command, extendFrequency, extendFrequency, TimeUnit.SECONDS);
    }

    private void closeSilently(Closeable closeable) {
        block3: {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (IOException e) {
                logger.warn("Got an exception when closing {}: {}", (Object)closeable, (Object)e.getMessage());
                if (!logger.isDebugEnabled()) break block3;
                logger.warn("", (Throwable)e);
            }
        }
    }

    public TransactionResultEntity extendTransaction(String transactionUrl) throws IOException {
        logger.debug("Sending extendTransaction request to transactionUrl: {}", (Object)transactionUrl);
        HttpPut put = this.createPut(transactionUrl);
        put.setHeader("Accept", "application/json");
        put.setHeader("x-nifi-site-to-site-protocol-version", String.valueOf(this.transportProtocolVersionNegotiator.getVersion()));
        this.setHandshakeProperties((HttpRequestBase)put);
        try (CloseableHttpResponse response = this.getHttpClient().execute((HttpUriRequest)put);){
            int responseCode = response.getStatusLine().getStatusCode();
            logger.debug("extendTransaction responseCode={}", (Object)responseCode);
            try (InputStream content = response.getEntity().getContent();){
                switch (responseCode) {
                    case 200: {
                        TransactionResultEntity transactionResultEntity = this.readResponse(content);
                        return transactionResultEntity;
                    }
                }
                throw this.handleErrResponse(responseCode, content);
            }
        }
    }

    private void stopExtendingTransaction() {
        if (!this.ttlExtendTaskExecutor.isShutdown()) {
            this.ttlExtendTaskExecutor.shutdown();
        }
        if (this.ttlExtendingFuture != null && !this.ttlExtendingFuture.isCancelled()) {
            boolean cancelled = this.ttlExtendingFuture.cancel(true);
            logger.debug("Extend Transaction Cancelled [{}]", (Object)cancelled);
        }
    }

    private IOException handleErrResponse(int responseCode, InputStream in) throws IOException {
        if (in == null) {
            return new IOException("Unexpected response code: " + responseCode);
        }
        TransactionResultEntity errEntity = this.readResponse(in);
        ResponseCode errCode = ResponseCode.fromCode(errEntity.getResponseCode());
        switch (errCode) {
            case UNKNOWN_PORT: {
                return new UnknownPortException(errEntity.getMessage());
            }
            case PORT_NOT_IN_VALID_STATE: {
                return new PortNotRunningException(errEntity.getMessage());
            }
        }
        switch (responseCode) {
            case 403: {
                return new HandshakeException(errEntity.getMessage());
            }
        }
        return new IOException("Unexpected response code: " + responseCode + " errCode:" + String.valueOf((Object)errCode) + " errMessage:" + errEntity.getMessage());
    }

    private TransactionResultEntity readResponse(InputStream inputStream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamUtils.copy((InputStream)inputStream, (OutputStream)bos);
        String responseMessage = null;
        try {
            responseMessage = new String(bos.toByteArray(), StandardCharsets.UTF_8);
            logger.debug("readResponse responseMessage={}", (Object)responseMessage);
            ObjectMapper mapper = new ObjectMapper();
            return (TransactionResultEntity)mapper.readValue(responseMessage, TransactionResultEntity.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to parse JSON.", e);
            }
            TransactionResultEntity entity = new TransactionResultEntity();
            entity.setResponseCode(ResponseCode.ABORT.getCode());
            entity.setMessage(responseMessage);
            return entity;
        }
    }

    private String readTransactionUrl(HttpResponse response) {
        Header locationUriIntentHeader = response.getFirstHeader("x-location-uri-intent");
        logger.debug("locationUriIntentHeader={}", (Object)locationUriIntentHeader);
        if (locationUriIntentHeader != null && "transaction-url".equals(locationUriIntentHeader.getValue())) {
            Header transactionUrl = response.getFirstHeader("Location");
            logger.debug("transactionUrl={}", (Object)transactionUrl);
            if (transactionUrl != null) {
                return transactionUrl.getValue();
            }
        }
        return null;
    }

    private void setHandshakeProperties(HttpRequestBase httpRequest) {
        if (this.compress) {
            httpRequest.setHeader("x-nifi-site-to-site-use-compression", "true");
        }
        if (this.requestExpirationMillis > 0L) {
            httpRequest.setHeader("x-nifi-site-to-site-request-expiration", String.valueOf(this.requestExpirationMillis));
        }
        if (this.batchCount > 0) {
            httpRequest.setHeader("x-nifi-site-to-site-batch-count", String.valueOf(this.batchCount));
        }
        if (this.batchSize > 0L) {
            httpRequest.setHeader("x-nifi-site-to-site-batch-size", String.valueOf(this.batchSize));
        }
        if (this.batchDurationMillis > 0L) {
            httpRequest.setHeader("x-nifi-site-to-site-batch-duration", String.valueOf(this.batchDurationMillis));
        }
    }

    private URI getUri(String path) {
        URI url;
        try {
            if (HTTP_ABS_URL.matcher(path).find()) {
                url = new URI(path);
            } else {
                if (StringUtils.isEmpty((CharSequence)this.getBaseUrl())) {
                    throw new IllegalStateException("API baseUrl is not resolved yet, call setBaseUrl or resolveBaseUrl before sending requests with relative path.");
                }
                url = new URI(this.baseUrl + path);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return url;
    }

    private HttpGet createGet(String path) {
        URI url = this.getUri(path);
        HttpGet get = new HttpGet(url);
        get.setConfig(this.getRequestConfig());
        return get;
    }

    private HttpPost createPost(String path) {
        URI url = this.getUri(path);
        HttpPost post = new HttpPost(url);
        post.setConfig(this.getRequestConfig());
        return post;
    }

    private HttpPut createPut(String path) {
        URI url = this.getUri(path);
        HttpPut put = new HttpPut(url);
        put.setConfig(this.getRequestConfig());
        return put;
    }

    private HttpDelete createDelete(String path) {
        URI url = this.getUri(path);
        HttpDelete delete = new HttpDelete(url);
        delete.setConfig(this.getRequestConfig());
        return delete;
    }

    private String execute(HttpGet get) throws IOException {
        CloseableHttpClient httpClient = this.getHttpClient();
        if (logger.isTraceEnabled()) {
            Arrays.stream(get.getAllHeaders()).forEach(h -> logger.debug("REQ| {}", h));
        }
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);){
            String responseMessage;
            StatusLine statusLine;
            int statusCode;
            if (logger.isTraceEnabled()) {
                Arrays.stream(response.getAllHeaders()).forEach(h -> logger.debug("RES| {}", h));
            }
            if (200 != (statusCode = (statusLine = response.getStatusLine()).getStatusCode())) {
                throw new HttpGetFailedException(statusCode, statusLine.getReasonPhrase(), null);
            }
            HttpEntity entity = response.getEntity();
            String string = responseMessage = EntityUtils.toString((HttpEntity)entity);
            return string;
        }
    }

    private <T> T execute(HttpGet get, Class<T> entityClass) throws IOException {
        get.setHeader("Accept", "application/json");
        String responseMessage = this.execute(get);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            return (T)mapper.readValue(responseMessage, entityClass);
        }
        catch (JsonParseException e) {
            String msg = "Failed to parse Json. The specified URL " + this.baseUrl + " is not a proper remote NiFi endpoint for Site-to-Site communication.";
            logger.warn("{} requestedUrl={}, response={}", new Object[]{msg, get.getURI(), responseMessage});
            throw new IOException(msg, e);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public void setCacheExpirationMillis(long expirationMillis) {
        this.cacheExpirationMillis = expirationMillis;
    }

    public static String getFirstUrl(String clusterUrlStr) {
        if (clusterUrlStr == null) {
            return null;
        }
        int commaIndex = clusterUrlStr.indexOf(44);
        if (commaIndex > -1) {
            return clusterUrlStr.substring(0, commaIndex);
        }
        return clusterUrlStr;
    }

    public static Set<String> parseClusterUrls(String clusterUrlStr) {
        LinkedHashSet urls = new LinkedHashSet();
        if (clusterUrlStr != null && clusterUrlStr.length() > 0) {
            Arrays.stream(clusterUrlStr.split(",")).map(s -> s.trim()).filter(s -> s.length() > 0).forEach(s -> {
                SiteToSiteRestApiClient.validateUriString(s);
                urls.add(SiteToSiteRestApiClient.resolveBaseUrl(s).intern());
            });
        }
        if (urls.size() == 0) {
            throw new IllegalArgumentException("Cluster URL was not specified.");
        }
        Predicate<String> isHttps = url -> url.toLowerCase().startsWith("https:");
        if (urls.stream().anyMatch(isHttps) && urls.stream().anyMatch(isHttps.negate())) {
            throw new IllegalArgumentException("Different protocols are used in the cluster URLs " + clusterUrlStr);
        }
        return Collections.unmodifiableSet(urls);
    }

    private static void validateUriString(String s) {
        URI uri;
        try {
            uri = URI.create(s);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The specified remote process group URL is malformed: " + s);
        }
        if (uri.getScheme() == null || uri.getHost() == null) {
            throw new IllegalArgumentException("The specified remote process group URL is malformed: " + s);
        }
        if (!uri.getScheme().equalsIgnoreCase("http") && !uri.getScheme().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("The specified remote process group URL is invalid because it is not http or https: " + s);
        }
    }

    private static String resolveBaseUrl(String clusterUrl) {
        URI uri;
        Objects.requireNonNull(clusterUrl, "clusterUrl cannot be null.");
        try {
            uri = new URI(clusterUrl.trim());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The specified URL is malformed: " + clusterUrl);
        }
        return SiteToSiteRestApiClient.resolveBaseUrl(uri);
    }

    private static String resolveBaseUrl(URI clusterUrl) {
        if (clusterUrl.getScheme() == null || clusterUrl.getHost() == null) {
            throw new IllegalArgumentException("The specified URL is malformed: " + String.valueOf(clusterUrl));
        }
        if (!clusterUrl.getScheme().equalsIgnoreCase("http") && !clusterUrl.getScheme().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("The specified URL is invalid because it is not http or https: " + String.valueOf(clusterUrl));
        }
        Object uriPath = clusterUrl.getPath().trim();
        if (StringUtils.isEmpty((CharSequence)uriPath) || ((String)uriPath).equals("/")) {
            uriPath = "/nifi";
        } else if (((String)uriPath).endsWith("/")) {
            uriPath = ((String)uriPath).substring(0, ((String)uriPath).length() - 1);
        }
        if (((String)uriPath).endsWith("/nifi")) {
            uriPath = (String)uriPath + "-api";
        } else if (!((String)uriPath).endsWith("/nifi-api")) {
            uriPath = (String)uriPath + "/nifi-api";
        }
        try {
            return new URIBuilder().setScheme(clusterUrl.getScheme()).setHost(clusterUrl.getHost()).setPort(clusterUrl.getPort()).setPath((String)uriPath).build().toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setBaseUrl(String scheme, String host, int port) {
        this.setBaseUrl(scheme, host, port, "/nifi-api");
    }

    private void setBaseUrl(String scheme, String host, int port, String path) {
        String baseUri;
        try {
            baseUri = new URIBuilder().setScheme(scheme).setHost(host).setPort(port).setPath(path).build().toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        this.setBaseUrl(baseUri);
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void setLocalAddress(InetAddress localAddress) {
        this.localAddress = localAddress;
    }

    public void setRequestExpirationMillis(long requestExpirationMillis) {
        if (requestExpirationMillis < 0L) {
            throw new IllegalArgumentException("requestExpirationMillis can't be a negative value.");
        }
        this.requestExpirationMillis = requestExpirationMillis;
    }

    public void setBatchCount(int batchCount) {
        if (batchCount < 0) {
            throw new IllegalArgumentException("batchCount can't be a negative value.");
        }
        this.batchCount = batchCount;
    }

    public void setBatchSize(long batchSize) {
        if (batchSize < 0L) {
            throw new IllegalArgumentException("batchSize can't be a negative value.");
        }
        this.batchSize = batchSize;
    }

    public void setBatchDurationMillis(long batchDurationMillis) {
        if (batchDurationMillis < 0L) {
            throw new IllegalArgumentException("batchDurationMillis can't be a negative value.");
        }
        this.batchDurationMillis = batchDurationMillis;
    }

    public Integer getTransactionProtocolVersion() {
        return this.transportProtocolVersionNegotiator.getTransactionProtocolVersion();
    }

    public String getTrustedPeerDn() {
        return this.trustedPeerDn;
    }

    public TransactionResultEntity commitReceivingFlowFiles(String transactionUrl, ResponseCode clientResponse, String checksum) throws IOException {
        logger.debug("Sending commitReceivingFlowFiles request to transactionUrl: {}, clientResponse={}, checksum={}", new Object[]{transactionUrl, clientResponse, checksum});
        this.stopExtendingTransaction();
        StringBuilder urlBuilder = new StringBuilder(transactionUrl).append("?responseCode=").append(clientResponse.getCode());
        if (ResponseCode.CONFIRM_TRANSACTION.equals((Object)clientResponse)) {
            urlBuilder.append("&checksum=").append(checksum);
        }
        HttpDelete delete = this.createDelete(urlBuilder.toString());
        delete.setHeader("Accept", "application/json");
        delete.setHeader("x-nifi-site-to-site-protocol-version", String.valueOf(this.transportProtocolVersionNegotiator.getVersion()));
        this.setHandshakeProperties((HttpRequestBase)delete);
        try (CloseableHttpResponse response = this.getHttpClient().execute((HttpUriRequest)delete);){
            int responseCode = response.getStatusLine().getStatusCode();
            logger.debug("commitReceivingFlowFiles responseCode={}", (Object)responseCode);
            try (InputStream content = response.getEntity().getContent();){
                switch (responseCode) {
                    case 200: {
                        TransactionResultEntity transactionResultEntity = this.readResponse(content);
                        return transactionResultEntity;
                    }
                    case 400: {
                        TransactionResultEntity transactionResultEntity = this.readResponse(content);
                        return transactionResultEntity;
                    }
                }
                throw this.handleErrResponse(responseCode, content);
            }
        }
    }

    public TransactionResultEntity commitTransferFlowFiles(String transactionUrl, ResponseCode clientResponse) throws IOException {
        String requestUrl = transactionUrl + "?responseCode=" + clientResponse.getCode();
        logger.debug("Sending commitTransferFlowFiles request to transactionUrl: {}", (Object)requestUrl);
        HttpDelete delete = this.createDelete(requestUrl);
        delete.setHeader("Accept", "application/json");
        delete.setHeader("x-nifi-site-to-site-protocol-version", String.valueOf(this.transportProtocolVersionNegotiator.getVersion()));
        this.setHandshakeProperties((HttpRequestBase)delete);
        try (CloseableHttpResponse response = this.getHttpClient().execute((HttpUriRequest)delete);){
            int responseCode = response.getStatusLine().getStatusCode();
            logger.debug("commitTransferFlowFiles responseCode={}", (Object)responseCode);
            try (InputStream content = response.getEntity().getContent();){
                switch (responseCode) {
                    case 200: {
                        TransactionResultEntity transactionResultEntity = this.readResponse(content);
                        return transactionResultEntity;
                    }
                    case 400: {
                        TransactionResultEntity transactionResultEntity = this.readResponse(content);
                        return transactionResultEntity;
                    }
                }
                throw this.handleErrResponse(responseCode, content);
            }
        }
    }

    private class HttpsResponseInterceptor
    implements HttpResponseInterceptor {
        private HttpsResponseInterceptor() {
        }

        public void process(HttpResponse response, HttpContext httpContext) throws HttpException, IOException {
            SSLSession sslSession;
            HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)httpContext);
            HttpInetConnection conn = (HttpInetConnection)coreContext.getConnection(HttpInetConnection.class);
            if (!conn.isOpen()) {
                return;
            }
            if (conn instanceof ManagedHttpClientConnection) {
                sslSession = ((ManagedHttpClientConnection)conn).getSSLSession();
            } else if (conn instanceof ManagedNHttpClientConnection) {
                sslSession = ((ManagedNHttpClientConnection)conn).getSSLSession();
            } else {
                throw new RuntimeException("Unexpected connection type was used, " + String.valueOf(conn));
            }
            if (sslSession != null) {
                Certificate[] certChain = sslSession.getPeerCertificates();
                if (certChain == null || certChain.length == 0) {
                    throw new SSLPeerUnverifiedException("No certificates found");
                }
                try {
                    X509Certificate cert = (X509Certificate)certChain[0];
                    SiteToSiteRestApiClient.this.trustedPeerDn = StandardPrincipalFormatter.getInstance().getSubject(cert);
                }
                catch (RuntimeException e) {
                    String msg = "Could not extract subject DN from SSL session peer certificate";
                    logger.warn("Could not extract subject DN from SSL session peer certificate");
                    SiteToSiteRestApiClient.this.eventReporter.reportEvent(Severity.WARNING, SiteToSiteRestApiClient.EVENT_CATEGORY, "Could not extract subject DN from SSL session peer certificate");
                    throw new SSLPeerUnverifiedException("Could not extract subject DN from SSL session peer certificate");
                }
            }
        }
    }

    private static class RemoteGroupContents {
        private final ControllerDTO contents;
        private final long timestamp;

        public RemoteGroupContents(ControllerDTO contents) {
            this.contents = contents;
            this.timestamp = System.currentTimeMillis();
        }

        public ControllerDTO getContents() {
            return this.contents;
        }

        public boolean isOlderThan(long millis) {
            long millisSinceRefresh = System.currentTimeMillis() - this.timestamp;
            return millisSinceRefresh > millis;
        }
    }

    public class HttpGetFailedException
    extends IOException {
        private static final long serialVersionUID = 7920714957269466946L;
        private final int responseCode;
        private final String responseMessage;
        private final String explanation;

        public HttpGetFailedException(int responseCode, String responseMessage, String explanation) {
            super("response code " + responseCode + ":" + responseMessage + " with explanation: " + explanation);
            this.responseCode = responseCode;
            this.responseMessage = responseMessage;
            this.explanation = explanation;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getDescription() {
            return !StringUtils.isEmpty((CharSequence)this.explanation) ? this.explanation : this.responseMessage;
        }
    }
}

