/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto.status;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.nifi.web.api.dto.status.ConnectionStatisticsSnapshotDTO;
import org.apache.nifi.web.api.dto.status.NodeConnectionStatisticsSnapshotDTO;
import org.apache.nifi.web.api.dto.util.TimeAdapter;

@XmlType(name="connectionStatistics")
public class ConnectionStatisticsDTO
implements Cloneable {
    private String id;
    private Date statsLastRefreshed;
    private ConnectionStatisticsSnapshotDTO aggregateSnapshot;
    private List<NodeConnectionStatisticsSnapshotDTO> nodeSnapshots;

    @Schema(description="The ID of the connection")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Schema(description="The status snapshot that represents the aggregate stats of the cluster")
    public ConnectionStatisticsSnapshotDTO getAggregateSnapshot() {
        return this.aggregateSnapshot;
    }

    public void setAggregateSnapshot(ConnectionStatisticsSnapshotDTO aggregateSnapshot) {
        this.aggregateSnapshot = aggregateSnapshot;
    }

    @Schema(description="A list of status snapshots for each node")
    public List<NodeConnectionStatisticsSnapshotDTO> getNodeSnapshots() {
        return this.nodeSnapshots;
    }

    public void setNodeSnapshots(List<NodeConnectionStatisticsSnapshotDTO> nodeSnapshots) {
        this.nodeSnapshots = nodeSnapshots;
    }

    @XmlJavaTypeAdapter(value=TimeAdapter.class)
    @Schema(description="The timestamp of when the stats were last refreshed", type="string")
    public Date getStatsLastRefreshed() {
        return this.statsLastRefreshed;
    }

    public void setStatsLastRefreshed(Date statsLastRefreshed) {
        this.statsLastRefreshed = statsLastRefreshed;
    }

    public ConnectionStatisticsDTO clone() {
        ConnectionStatisticsDTO other = new ConnectionStatisticsDTO();
        other.setId(this.getId());
        other.setAggregateSnapshot(this.getAggregateSnapshot().clone());
        List<NodeConnectionStatisticsSnapshotDTO> nodeStatuses = this.getNodeSnapshots();
        ArrayList<NodeConnectionStatisticsSnapshotDTO> nodeStatusClones = new ArrayList<NodeConnectionStatisticsSnapshotDTO>(nodeStatuses.size());
        for (NodeConnectionStatisticsSnapshotDTO nodeStatus : nodeStatuses) {
            nodeStatusClones.add(nodeStatus.clone());
        }
        other.setNodeSnapshots(nodeStatusClones);
        return other;
    }
}

