/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.kafkamigrator.service;

import org.apache.nifi.toolkit.kafkamigrator.MigratorConfiguration;
import org.apache.nifi.toolkit.kafkamigrator.descriptor.KafkaProcessorDescriptor;
import org.apache.nifi.toolkit.kafkamigrator.descriptor.KafkaProcessorType;
import org.apache.nifi.toolkit.kafkamigrator.descriptor.TemplatePropertyXpathDescriptor;
import org.apache.nifi.toolkit.kafkamigrator.migrator.ConsumeKafkaTemplateMigrator;
import org.apache.nifi.toolkit.kafkamigrator.migrator.Migrator;
import org.apache.nifi.toolkit.kafkamigrator.migrator.PublishKafkaTemplateMigrator;
import org.apache.nifi.toolkit.kafkamigrator.service.KafkaMigrationService;

public class KafkaTemplateMigrationService
implements KafkaMigrationService {
    private static final String XPATH_FOR_PROCESSORS_IN_TEMPLATE = ".//processors";
    private static final String TYPE_TAG_NAME = "type";

    @Override
    public String getPathForProcessors() {
        return XPATH_FOR_PROCESSORS_IN_TEMPLATE;
    }

    @Override
    public String getPathForClass() {
        return TYPE_TAG_NAME;
    }

    @Override
    public Migrator createPublishMigrator(MigratorConfiguration.MigratorConfigurationBuilder configurationBuilder) {
        configurationBuilder.setIsVersion8Processor(IS_NOT_VERSION_EIGHT_PROCESSOR).setProcessorDescriptor(new KafkaProcessorDescriptor(KafkaProcessorType.PUBLISH)).setPropertyXpathDescriptor(new TemplatePropertyXpathDescriptor(KafkaProcessorType.PUBLISH));
        return new PublishKafkaTemplateMigrator(configurationBuilder.build());
    }

    @Override
    public Migrator createConsumeMigrator(MigratorConfiguration.MigratorConfigurationBuilder configurationBuilder) {
        configurationBuilder.setIsVersion8Processor(IS_NOT_VERSION_EIGHT_PROCESSOR).setProcessorDescriptor(new KafkaProcessorDescriptor(KafkaProcessorType.CONSUME)).setPropertyXpathDescriptor(new TemplatePropertyXpathDescriptor(KafkaProcessorType.CONSUME));
        return new ConsumeKafkaTemplateMigrator(configurationBuilder.build());
    }

    @Override
    public Migrator createVersionEightPublishMigrator(MigratorConfiguration.MigratorConfigurationBuilder configurationBuilder) {
        configurationBuilder.setIsVersion8Processor(IS_VERSION_EIGHT_PROCESSOR).setProcessorDescriptor(new KafkaProcessorDescriptor(KafkaProcessorType.PUBLISH)).setPropertyXpathDescriptor(new TemplatePropertyXpathDescriptor(KafkaProcessorType.PUBLISH));
        return new PublishKafkaTemplateMigrator(configurationBuilder.build());
    }

    @Override
    public Migrator createVersionEightConsumeMigrator(MigratorConfiguration.MigratorConfigurationBuilder configurationBuilder) {
        configurationBuilder.setIsVersion8Processor(IS_VERSION_EIGHT_PROCESSOR).setProcessorDescriptor(new KafkaProcessorDescriptor(KafkaProcessorType.CONSUME)).setPropertyXpathDescriptor(new TemplatePropertyXpathDescriptor(KafkaProcessorType.CONSUME));
        return new ConsumeKafkaTemplateMigrator(configurationBuilder.build());
    }
}

