/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.kafkamigrator.migrator;

import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.kafkamigrator.MigratorConfiguration;
import org.apache.nifi.toolkit.kafkamigrator.migrator.Migrator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractKafkaMigrator
implements Migrator {
    static final XPath XPATH = XPathFactory.newInstance().newXPath();
    private static final String NEW_KAFKA_PROCESSOR_VERSION = "_2_0";
    private static final String ARTIFACT = "nifi-kafka-2-0-nar";
    private static final String PATH_FOR_ARTIFACT = "bundle/artifact";
    final boolean isVersion8Processor;
    final boolean isKafkaBrokersPresent;
    final Map<String, String> kafkaProcessorProperties;
    final Map<String, String> propertiesToBeSaved;
    final Map<String, String> controllerServices;
    final String xpathForProperties;
    final String propertyKeyTagName;
    final String propertyTagName;
    final String xpathForTransactionProperty;
    final String transactionTagName;
    final boolean transaction;

    public AbstractKafkaMigrator(MigratorConfiguration configuration) {
        String kafkaBrokers = configuration.getKafkaBrokers();
        this.isKafkaBrokersPresent = !kafkaBrokers.isEmpty();
        this.isVersion8Processor = configuration.isVersion8Processor();
        this.kafkaProcessorProperties = new HashMap<String, String>(configuration.getProcessorDescriptor().getProcessorProperties());
        this.propertiesToBeSaved = configuration.getProcessorDescriptor().getPropertiesToBeSaved();
        this.controllerServices = configuration.getProcessorDescriptor().getControllerServicesForTemplates();
        this.xpathForProperties = configuration.getPropertyXpathDescriptor().getXpathForProperties();
        this.propertyKeyTagName = configuration.getPropertyXpathDescriptor().getPropertyKeyTagName();
        this.propertyTagName = configuration.getPropertyXpathDescriptor().getPropertyTagName();
        this.xpathForTransactionProperty = configuration.getPropertyXpathDescriptor().getXpathForTransactionProperty();
        this.transactionTagName = configuration.getPropertyXpathDescriptor().getTransactionTagName();
        this.transaction = configuration.isTransaction();
        if (this.isKafkaBrokersPresent) {
            this.kafkaProcessorProperties.put("bootstrap.servers", kafkaBrokers);
        }
    }

    @Override
    public void configureProperties(Node node) throws XPathExpressionException {
        if (this.isVersion8Processor && this.isKafkaBrokersPresent) {
            NodeList properties = (NodeList)XPATH.evaluate(this.xpathForProperties, node, XPathConstants.NODESET);
            for (int i = 0; i < properties.getLength(); ++i) {
                Node property = properties.item(i);
                this.saveRequiredProperties(property);
                this.removeElement(node, property);
            }
            this.addNewProperties(node);
        }
    }

    @Override
    public void configureDescriptors(Node node) throws XPathExpressionException {
        if (this.isVersion8Processor && this.isKafkaBrokersPresent) {
            Element descriptorElement = (Element)XPATH.evaluate("config/descriptors", node, XPathConstants.NODE);
            NodeList descriptors = (NodeList)XPATH.evaluate("entry", descriptorElement, XPathConstants.NODESET);
            for (int i = 0; i < descriptors.getLength(); ++i) {
                Node descriptor = descriptors.item(i);
                this.removeElement(descriptorElement, descriptor);
            }
            this.addNewDescriptors(descriptorElement);
        }
    }

    @Override
    public void configureComponentSpecificSteps(Node node) throws XPathExpressionException {
        String transactionString = Boolean.toString(this.transaction);
        Element transactionsElement = (Element)XPATH.evaluate(this.xpathForTransactionProperty, node, XPathConstants.NODE);
        if (transactionsElement != null) {
            transactionsElement.setTextContent(transactionString);
        } else {
            this.addNewProperty(node, this.transactionTagName, transactionString);
        }
        this.kafkaProcessorProperties.put(this.transactionTagName, transactionString);
    }

    public void replaceClassName(Element className) {
        String processorName = StringUtils.substringAfterLast((String)className.getTextContent(), (String)".");
        String newClassName = AbstractKafkaMigrator.replaceClassNameWithNewProcessorName(className.getTextContent(), processorName);
        className.setTextContent(newClassName);
    }

    public void replaceArtifact(Node processor) throws XPathExpressionException {
        ((Element)XPATH.evaluate(PATH_FOR_ARTIFACT, processor, XPathConstants.NODE)).setTextContent(ARTIFACT);
    }

    private static String replaceClassNameWithNewProcessorName(String className, String processorName) {
        String newProcessorName = StringUtils.replaceEach((String)processorName, (String[])new String[]{"Get", "Put"}, (String[])new String[]{"pubsub.Consume", "pubsub.Publish"});
        String processorNameWithNewVersion = newProcessorName.replaceFirst("$|_0_1\\d?", NEW_KAFKA_PROCESSOR_VERSION);
        return StringUtils.replace((String)className, (String)processorName, (String)processorNameWithNewVersion);
    }

    private void addNewDescriptors(Node node) {
        for (String key : this.kafkaProcessorProperties.keySet()) {
            Element descriptorElement = node.getOwnerDocument().createElement("entry");
            node.appendChild(descriptorElement);
            Element descriptorKeyElement = descriptorElement.getOwnerDocument().createElement("key");
            descriptorKeyElement.setTextContent(key);
            descriptorElement.appendChild(descriptorKeyElement);
            Element descriptorValueElement = descriptorElement.getOwnerDocument().createElement("value");
            descriptorElement.appendChild(descriptorValueElement);
            Element descriptorNameElement = descriptorValueElement.getOwnerDocument().createElement("name");
            descriptorNameElement.setTextContent(key);
            descriptorValueElement.appendChild(descriptorNameElement);
            if (!this.controllerServices.containsKey(key)) continue;
            Element controllerServiceElement = descriptorValueElement.getOwnerDocument().createElement("identifiesControllerService");
            controllerServiceElement.setTextContent(this.controllerServices.get(key));
            descriptorValueElement.appendChild(controllerServiceElement);
        }
    }

    private void saveRequiredProperties(Node property) throws XPathExpressionException {
        String propertyToBeSaved = this.propertiesToBeSaved.get(XPATH.evaluate(this.propertyKeyTagName, property));
        if (propertyToBeSaved != null) {
            String propertyValue = XPATH.evaluate("value", property);
            this.kafkaProcessorProperties.put(propertyToBeSaved, this.convert(propertyValue));
        }
    }

    private String convert(String propertyValue) {
        return propertyValue.isEmpty() ? null : propertyValue;
    }

    private void addNewProperties(Node node) {
        for (Map.Entry<String, String> entry : this.kafkaProcessorProperties.entrySet()) {
            this.addNewProperty(node, entry.getKey(), entry.getValue());
        }
    }

    private void addNewProperty(Node node, String key, String value) {
        Element propertyElement = node.getOwnerDocument().createElement(this.propertyTagName);
        node.appendChild(propertyElement);
        Element propertyKeyElement = propertyElement.getOwnerDocument().createElement(this.propertyKeyTagName);
        propertyKeyElement.setTextContent(key);
        propertyElement.appendChild(propertyKeyElement);
        if (value != null) {
            Element propertyValueElement = propertyElement.getOwnerDocument().createElement("value");
            propertyValueElement.setTextContent(value);
            propertyElement.appendChild(propertyValueElement);
        }
    }

    private void removeElement(Node node, Node element) {
        node.removeChild(element);
    }
}

