/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flow.encryptor;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.flow.encryptor.AbstractFlowEncryptor;
import org.apache.nifi.flow.encryptor.FlowEncryptor;
import org.apache.nifi.flow.encryptor.JsonFlowEncryptor;
import org.apache.nifi.flow.encryptor.XmlFlowEncryptor;

public class StandardFlowEncryptor
implements FlowEncryptor {
    private static final int XML_DECLARATION = 60;

    @Override
    public void processFlow(InputStream inputStream, OutputStream outputStream, PropertyEncryptor inputEncryptor, PropertyEncryptor outputEncryptor) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(1);
        try {
            int firstByte = bufferedInputStream.read();
            bufferedInputStream.reset();
            AbstractFlowEncryptor flowEncryptor = firstByte == 60 ? new XmlFlowEncryptor() : new JsonFlowEncryptor();
            flowEncryptor.processFlow(bufferedInputStream, outputStream, inputEncryptor, outputEncryptor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

