/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.internal.UserAgentUtils;
import software.amazon.awssdk.services.kms.model.GrantListEntry;
import software.amazon.awssdk.services.kms.model.ListGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListGrantsResponse;

public class ListGrantsPublisher
implements SdkPublisher<ListGrantsResponse> {
    private final KmsAsyncClient client;
    private final ListGrantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGrantsPublisher(KmsAsyncClient client, ListGrantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGrantsPublisher(KmsAsyncClient client, ListGrantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGrantsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGrantsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GrantListEntry> grants() {
        Function<ListGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.grants() != null) {
                return response.grants().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGrantsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGrantsResponseFetcher
    implements AsyncPageFetcher<ListGrantsResponse> {
        private ListGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListGrantsResponse previousPage) {
            return previousPage.truncated() != null && previousPage.truncated() != false;
        }

        public CompletableFuture<ListGrantsResponse> nextPage(ListGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListGrantsPublisher.this.client.listGrants(ListGrantsPublisher.this.firstRequest);
            }
            return ListGrantsPublisher.this.client.listGrants((ListGrantsRequest)((Object)ListGrantsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

