/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.expression;

import v14.h2.engine.Database;
import v14.h2.engine.Session;
import v14.h2.expression.ConcatenationOperation;
import v14.h2.expression.Expression;
import v14.h2.expression.ExpressionVisitor;
import v14.h2.expression.IntervalOperation;
import v14.h2.expression.UnaryOperation;
import v14.h2.expression.ValueExpression;
import v14.h2.expression.function.Function;
import v14.h2.message.DbException;
import v14.h2.table.ColumnResolver;
import v14.h2.table.TableFilter;
import v14.h2.value.DataType;
import v14.h2.value.TypeInfo;
import v14.h2.value.Value;
import v14.h2.value.ValueInt;
import v14.h2.value.ValueNull;
import v14.h2.value.ValueString;

public class BinaryOperation
extends Expression {
    private OpType opType;
    private Expression left;
    private Expression right;
    private TypeInfo type;
    private boolean convertRight = true;

    public BinaryOperation(OpType opType, Expression expression, Expression expression2) {
        this.opType = opType;
        this.left = expression;
        this.right = expression2;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder, bl).append(' ').append(this.getOperationToken()).append(' ');
        return this.right.getSQL(stringBuilder, bl).append(')');
    }

    private String getOperationToken() {
        switch (this.opType) {
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case MODULUS: {
                return "%";
            }
        }
        throw DbException.throwInternalError("opType=" + (Object)((Object)this.opType));
    }

    @Override
    public Value getValue(Session session) {
        Database database = session.getDatabase();
        Value value = this.left.getValue(session).convertTo(this.type, database, true, null);
        Value value2 = this.right.getValue(session);
        if (this.convertRight) {
            value2 = value2.convertTo(this.type, database, true, null);
        }
        switch (this.opType) {
            case PLUS: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value.add(value2);
            }
            case MINUS: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value.subtract(value2);
            }
            case MULTIPLY: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value.multiply(value2);
            }
            case DIVIDE: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value.divide(value2);
            }
            case MODULUS: {
                if (value == ValueNull.INSTANCE || value2 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return value.modulus(value2);
            }
        }
        throw DbException.throwInternalError("type=" + (Object)((Object)this.opType));
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
        this.right.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        switch (this.opType) {
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULUS: {
                int n = this.left.getType().getValueType();
                int n2 = this.right.getType().getValueType();
                if (n == 0 && n2 == 0 || n == -1 && n2 == -1) {
                    if (this.opType == OpType.PLUS && session.getDatabase().getMode().allowPlusForStringConcat) {
                        return new ConcatenationOperation(this.left, this.right).optimize(session);
                    }
                    this.type = TypeInfo.TYPE_DECIMAL_DEFAULT;
                    break;
                }
                if (DataType.isIntervalType(n) || DataType.isIntervalType(n2)) {
                    return this.optimizeInterval(session, n, n2);
                }
                if (DataType.isDateTimeType(n) || DataType.isDateTimeType(n2)) {
                    return this.optimizeDateTime(session, n, n2);
                }
                int n3 = Value.getHigherOrder(n, n2);
                if (n3 == 25) {
                    this.type = TypeInfo.TYPE_INT;
                    break;
                }
                this.type = TypeInfo.getTypeInfo(n3);
                if (!DataType.isStringType(n3) || !session.getDatabase().getMode().allowPlusForStringConcat) break;
                return new ConcatenationOperation(this.left, this.right).optimize(session);
            }
            default: {
                DbException.throwInternalError("type=" + (Object)((Object)this.opType));
            }
        }
        if (this.left.isConstant() && this.right.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    private Expression optimizeInterval(Session session, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (DataType.isIntervalType(n)) {
            bl = true;
        } else if (DataType.isNumericType(n)) {
            bl2 = true;
        } else if (DataType.isDateTimeType(n)) {
            bl3 = true;
        } else {
            throw this.getUnsupported(n, n2);
        }
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (DataType.isIntervalType(n2)) {
            bl4 = true;
        } else if (DataType.isNumericType(n2)) {
            bl5 = true;
        } else if (DataType.isDateTimeType(n2)) {
            bl6 = true;
        } else {
            throw this.getUnsupported(n, n2);
        }
        switch (this.opType) {
            case PLUS: {
                if (bl && bl4) {
                    if (DataType.isYearMonthIntervalType(n) != DataType.isYearMonthIntervalType(n2)) break;
                    return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_PLUS_INTERVAL, this.left, this.right);
                }
                if (bl && bl6) {
                    if (n2 == 9 && DataType.isYearMonthIntervalType(n)) break;
                    return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_PLUS_INTERVAL, this.right, this.left);
                }
                if (!bl3 || !bl4 || n == 9 && DataType.isYearMonthIntervalType(n2)) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_PLUS_INTERVAL, this.left, this.right);
            }
            case MINUS: {
                if (bl && bl4) {
                    if (DataType.isYearMonthIntervalType(n) != DataType.isYearMonthIntervalType(n2)) break;
                    return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_MINUS_INTERVAL, this.left, this.right);
                }
                if (!bl3 || !bl4 || n == 9 && DataType.isYearMonthIntervalType(n2)) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_MINUS_INTERVAL, this.left, this.right);
            }
            case MULTIPLY: {
                if (bl && bl5) {
                    return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_MULTIPLY_NUMERIC, this.left, this.right);
                }
                if (!bl2 || !bl4) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_MULTIPLY_NUMERIC, this.right, this.left);
            }
            case DIVIDE: {
                if (!bl) break;
                if (bl5) {
                    return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_DIVIDE_NUMERIC, this.left, this.right);
                }
                if (!bl4 || DataType.isYearMonthIntervalType(n) != DataType.isYearMonthIntervalType(n2)) break;
                return new IntervalOperation(IntervalOperation.IntervalOpType.INTERVAL_DIVIDE_INTERVAL, this.left, this.right);
            }
        }
        throw this.getUnsupported(n, n2);
    }

    private Expression optimizeDateTime(Session session, int n, int n2) {
        switch (this.opType) {
            case PLUS: {
                if (n2 != Value.getHigherOrder(n, n2)) {
                    this.swap();
                    int n3 = n;
                    n = n2;
                    n2 = n3;
                }
                switch (n) {
                    case 4: {
                        return Function.getFunctionWithArgs(session.getDatabase(), 105, ValueExpression.get(ValueString.get("DAY")), this.left, this.right).optimize(session);
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return Function.getFunctionWithArgs(session.getDatabase(), 105, ValueExpression.get(ValueString.get("SECOND")), new BinaryOperation(OpType.MULTIPLY, ValueExpression.get(ValueInt.get(86400)), this.left), this.right).optimize(session);
                    }
                    case 9: 
                    case 41: {
                        if (n2 == 9 || n2 == 41 || n2 == 24) {
                            this.type = TypeInfo.getTypeInfo(n2);
                            return this;
                        }
                        this.type = TypeInfo.TYPE_TIMESTAMP;
                        return this;
                    }
                }
                break;
            }
            case MINUS: {
                switch (n) {
                    case 10: 
                    case 11: 
                    case 24: {
                        switch (n2) {
                            case 4: {
                                return Function.getFunctionWithArgs(session.getDatabase(), 105, ValueExpression.get(ValueString.get("DAY")), new UnaryOperation(this.right), this.left).optimize(session);
                            }
                            case 6: 
                            case 7: 
                            case 8: {
                                return Function.getFunctionWithArgs(session.getDatabase(), 105, ValueExpression.get(ValueString.get("SECOND")), new UnaryOperation(new BinaryOperation(OpType.MULTIPLY, ValueExpression.get(ValueInt.get(86400)), this.right)), this.left).optimize(session);
                            }
                            case 9: 
                            case 41: {
                                this.type = TypeInfo.TYPE_TIMESTAMP;
                                return this;
                            }
                            case 10: 
                            case 11: 
                            case 24: {
                                return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_MINUS_DATETIME, this.left, this.right);
                            }
                        }
                        break;
                    }
                    case 9: 
                    case 41: {
                        if (n2 != 9 && n2 != 41) break;
                        return new IntervalOperation(IntervalOperation.IntervalOpType.DATETIME_MINUS_DATETIME, this.left, this.right);
                    }
                }
                break;
            }
            case MULTIPLY: {
                if (n == 9) {
                    this.type = TypeInfo.TYPE_TIME;
                    this.convertRight = false;
                    return this;
                }
                if (n2 != 9) break;
                this.swap();
                this.type = TypeInfo.TYPE_TIME;
                this.convertRight = false;
                return this;
            }
            case DIVIDE: {
                if (n != 9) break;
                this.type = TypeInfo.TYPE_TIME;
                this.convertRight = false;
                return this;
            }
        }
        throw this.getUnsupported(n, n2);
    }

    private DbException getUnsupported(int n, int n2) {
        return DbException.getUnsupportedException(DataType.getDataType((int)n).name + ' ' + this.getOperationToken() + ' ' + DataType.getDataType((int)n2).name);
    }

    private void swap() {
        Expression expression = this.left;
        this.left = this.right;
        this.right = expression;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.right.setEvaluatable(tableFilter, bl);
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
        this.right.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.right.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.right.getCost() + 1;
    }

    @Override
    public int getSubexpressionCount() {
        return 2;
    }

    @Override
    public Expression getSubexpression(int n) {
        switch (n) {
            case 0: {
                return this.left;
            }
            case 1: {
                return this.right;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public static enum OpType {
        PLUS,
        MINUS,
        MULTIPLY,
        DIVIDE,
        MODULUS;

    }
}

