/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.event;

import org.apache.nifi.registry.authorization.User;
import org.apache.nifi.registry.authorization.UserGroup;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.event.StandardEvent;
import org.apache.nifi.registry.extension.bundle.Bundle;
import org.apache.nifi.registry.extension.bundle.BundleVersion;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.hook.Event;
import org.apache.nifi.registry.hook.EventFieldName;
import org.apache.nifi.registry.hook.EventType;
import org.apache.nifi.registry.security.authorization.user.NiFiUserUtils;

public class EventFactory {
    public static Event bucketCreated(Bucket bucket) {
        return new StandardEvent.Builder().eventType(EventType.CREATE_BUCKET).addField(EventFieldName.BUCKET_ID, bucket.getIdentifier()).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event bucketUpdated(Bucket bucket) {
        return new StandardEvent.Builder().eventType(EventType.UPDATE_BUCKET).addField(EventFieldName.BUCKET_ID, bucket.getIdentifier()).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event bucketDeleted(Bucket bucket) {
        return new StandardEvent.Builder().eventType(EventType.DELETE_BUCKET).addField(EventFieldName.BUCKET_ID, bucket.getIdentifier()).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event flowCreated(VersionedFlow versionedFlow) {
        return new StandardEvent.Builder().eventType(EventType.CREATE_FLOW).addField(EventFieldName.BUCKET_ID, versionedFlow.getBucketIdentifier()).addField(EventFieldName.FLOW_ID, versionedFlow.getIdentifier()).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event flowUpdated(VersionedFlow versionedFlow) {
        return new StandardEvent.Builder().eventType(EventType.UPDATE_FLOW).addField(EventFieldName.BUCKET_ID, versionedFlow.getBucketIdentifier()).addField(EventFieldName.FLOW_ID, versionedFlow.getIdentifier()).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event flowDeleted(VersionedFlow versionedFlow) {
        return new StandardEvent.Builder().eventType(EventType.DELETE_FLOW).addField(EventFieldName.BUCKET_ID, versionedFlow.getBucketIdentifier()).addField(EventFieldName.FLOW_ID, versionedFlow.getIdentifier()).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event flowVersionCreated(VersionedFlowSnapshot versionedFlowSnapshot) {
        String versionComments = versionedFlowSnapshot.getSnapshotMetadata().getComments() == null ? "" : versionedFlowSnapshot.getSnapshotMetadata().getComments();
        return new StandardEvent.Builder().eventType(EventType.CREATE_FLOW_VERSION).addField(EventFieldName.BUCKET_ID, versionedFlowSnapshot.getSnapshotMetadata().getBucketIdentifier()).addField(EventFieldName.FLOW_ID, versionedFlowSnapshot.getSnapshotMetadata().getFlowIdentifier()).addField(EventFieldName.VERSION, String.valueOf(versionedFlowSnapshot.getSnapshotMetadata().getVersion())).addField(EventFieldName.USER, versionedFlowSnapshot.getSnapshotMetadata().getAuthor()).addField(EventFieldName.COMMENT, versionComments).build();
    }

    public static Event extensionBundleCreated(Bundle bundle) {
        return new StandardEvent.Builder().eventType(EventType.CREATE_EXTENSION_BUNDLE).addField(EventFieldName.BUCKET_ID, bundle.getBucketIdentifier()).addField(EventFieldName.EXTENSION_BUNDLE_ID, bundle.getIdentifier()).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event extensionBundleDeleted(Bundle bundle) {
        return new StandardEvent.Builder().eventType(EventType.DELETE_EXTENSION_BUNDLE).addField(EventFieldName.BUCKET_ID, bundle.getBucketIdentifier()).addField(EventFieldName.EXTENSION_BUNDLE_ID, bundle.getIdentifier()).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event extensionBundleVersionCreated(BundleVersion bundleVersion) {
        return new StandardEvent.Builder().eventType(EventType.CREATE_EXTENSION_BUNDLE_VERSION).addField(EventFieldName.BUCKET_ID, bundleVersion.getVersionMetadata().getBucketId()).addField(EventFieldName.EXTENSION_BUNDLE_ID, bundleVersion.getVersionMetadata().getBundleId()).addField(EventFieldName.VERSION, String.valueOf(bundleVersion.getVersionMetadata().getVersion())).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event extensionBundleVersionDeleted(BundleVersion bundleVersion) {
        return new StandardEvent.Builder().eventType(EventType.DELETE_EXTENSION_BUNDLE_VERSION).addField(EventFieldName.BUCKET_ID, bundleVersion.getVersionMetadata().getBucketId()).addField(EventFieldName.EXTENSION_BUNDLE_ID, bundleVersion.getVersionMetadata().getBundleId()).addField(EventFieldName.VERSION, String.valueOf(bundleVersion.getVersionMetadata().getVersion())).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event userCreated(User user) {
        return new StandardEvent.Builder().eventType(EventType.CREATE_USER).addField(EventFieldName.USER_ID, user.getIdentifier()).addField(EventFieldName.USER_IDENTITY, user.getIdentity()).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event userUpdated(User user) {
        return new StandardEvent.Builder().eventType(EventType.UPDATE_USER).addField(EventFieldName.USER_ID, user.getIdentifier()).addField(EventFieldName.USER_IDENTITY, user.getIdentity()).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event userDeleted(User user) {
        return new StandardEvent.Builder().eventType(EventType.DELETE_USER).addField(EventFieldName.USER_ID, user.getIdentifier()).addField(EventFieldName.USER_IDENTITY, user.getIdentity()).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event userGroupCreated(UserGroup userGroup) {
        return new StandardEvent.Builder().eventType(EventType.CREATE_USER_GROUP).addField(EventFieldName.USER_GROUP_ID, userGroup.getIdentifier()).addField(EventFieldName.USER_GROUP_IDENTITY, userGroup.getIdentity()).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event userGroupUpdated(UserGroup userGroup) {
        return new StandardEvent.Builder().eventType(EventType.UPDATE_USER_GROUP).addField(EventFieldName.USER_GROUP_ID, userGroup.getIdentifier()).addField(EventFieldName.USER_GROUP_IDENTITY, userGroup.getIdentity()).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }

    public static Event userGroupDeleted(UserGroup userGroup) {
        return new StandardEvent.Builder().eventType(EventType.DELETE_USER_GROUP).addField(EventFieldName.USER_GROUP_ID, userGroup.getIdentifier()).addField(EventFieldName.USER_GROUP_IDENTITY, userGroup.getIdentity()).addField(EventFieldName.USER, NiFiUserUtils.getNiFiUserIdentity()).build();
    }
}

