/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.nifi.minifi.c2.configuration;

import org.apache.nifi.minifi.c2.service.C2JsonProviderFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;

public class C2ResourceConfig extends ResourceConfig {

    public C2ResourceConfig(@Context ServletContext servletContext) {
        final ApplicationContext appCtx = WebApplicationContextUtils.getWebApplicationContext(servletContext);

        // register Jackson Object Mapper Resolver
        register(C2JsonProviderFeature.class);
        register(appCtx.getBean("configService"));
    }
}
