/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.kms;

import java.security.KeyManagementException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.SecretKey;
import org.apache.nifi.security.kms.KeyProvider;

public class StaticKeyProvider
implements KeyProvider {
    private final Map<String, SecretKey> keys;

    public StaticKeyProvider(Map<String, SecretKey> keys) {
        this.keys = Collections.unmodifiableMap(Objects.requireNonNull(keys, "Keys required"));
    }

    @Override
    public SecretKey getKey(String keyId) throws KeyManagementException {
        SecretKey secretKey = this.keys.get(keyId);
        if (secretKey == null) {
            throw new KeyManagementException(String.format("Secret Key [%s] not found", keyId));
        }
        return secretKey;
    }

    @Override
    public boolean keyExists(String keyId) {
        return this.keys.containsKey(keyId);
    }

    @Override
    public List<String> getAvailableKeyIds() {
        return new ArrayList<String>(this.keys.keySet());
    }
}

