/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.mp.AbstractSSequence;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.WaitStrategy;

public class SCSequence
extends AbstractSSequence {
    public SCSequence(WaitStrategy waitStrategy) {
        super(waitStrategy);
    }

    public SCSequence(long value, WaitStrategy waitStrategy) {
        super(waitStrategy);
        this.setCurrent(value);
    }

    public SCSequence() {
    }

    public long available() {
        return this.cache + 1L;
    }

    @Override
    public long availableIndex(long lo) {
        return this.value;
    }

    public <T> boolean consumeAll(RingQueue<T> queue, QueueConsumer<T> consumer) {
        long cursor = this.next();
        if (cursor < 0L) {
            return false;
        }
        do {
            if (cursor <= -1L) continue;
            long available = this.available();
            while (cursor < available) {
                consumer.consume(queue.get(cursor++));
            }
            this.done(available - 1L);
        } while ((cursor = this.next()) != -1L);
        return true;
    }

    @Override
    public long current() {
        return this.value;
    }

    @Override
    public void done(long cursor) {
        this.value = cursor;
        this.barrier.getWaitStrategy().signal();
    }

    @Override
    public long next() {
        long next = this.getValue();
        if (next < this.cache) {
            return next + 1L;
        }
        return this.next0(next + 1L);
    }

    @Override
    public final void setCurrent(long value) {
        this.value = value;
    }

    private long next0(long next) {
        this.cache = this.barrier.availableIndex(next);
        return next > this.cache ? -1L : next;
    }
}

