/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.params;

import org.apache.nifi.registry.params.SortOrder;

public class SortParameter {
    public static final String API_PARAM_DESCRIPTION = "Apply client-defined sorting to the resulting list of resource objects. The value of this parameter should be in the format \"field:order\". Valid values for 'field' can be discovered via GET :resourceURI/fields. Valid values for 'order' are 'ASC' (ascending order), 'DESC' (descending order).";
    private final String fieldName;
    private final SortOrder order;

    public SortParameter(String fieldName, SortOrder order) {
        this.fieldName = fieldName;
        this.order = order;
        if (this.fieldName == null) {
            throw new IllegalStateException("Field Name cannot be null");
        }
        if (this.fieldName.trim().isEmpty()) {
            throw new IllegalStateException("Field Name cannot be blank");
        }
        if (this.order == null) {
            throw new IllegalStateException("Order cannot be null");
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public SortOrder getOrder() {
        return this.order;
    }

    public static SortParameter fromString(String sortExpression) {
        if (sortExpression == null) {
            throw new IllegalArgumentException("Sort cannot be null");
        }
        String[] sortParts = sortExpression.split("[:]");
        if (sortParts.length != 2) {
            throw new IllegalArgumentException("Sort must be in the form field:order");
        }
        String fieldName = sortParts[0];
        SortOrder order = SortOrder.fromString(sortParts[1]);
        return new SortParameter(fieldName, order);
    }

    public String toString() {
        return this.fieldName + ":" + this.order.getName();
    }
}

