/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.std.Chars;
import io.questdb.std.Sinkable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AbstractCharSink;
import io.questdb.std.str.CharSink;

public class LogRecordSink
extends AbstractCharSink
implements Sinkable {
    protected final long address;
    protected final long lim;
    protected long _wptr;
    private int level;

    LogRecordSink(long address, long addressSize) {
        this.address = this._wptr = address;
        this.lim = address + addressSize;
    }

    public void clear() {
        this._wptr = this.address;
    }

    public long getAddress() {
        return this.address;
    }

    public int getLevel() {
        return this.level;
    }

    public int length() {
        return (int)(this._wptr - this.address);
    }

    @Override
    public CharSink put(CharSequence cs) {
        int rem = (int)(this.lim - this._wptr);
        int len = cs.length();
        int n = Math.min(rem, len);
        Chars.asciiStrCpy(cs, n, this._wptr);
        this._wptr += (long)n;
        return this;
    }

    @Override
    public CharSink put(CharSequence cs, int lo, int hi) {
        int rem = (int)(this.lim - this._wptr);
        int len = hi - lo;
        int n = Math.min(rem, len);
        Chars.asciiStrCpy(cs, lo, n, this._wptr);
        this._wptr += (long)n;
        return this;
    }

    @Override
    public CharSink put(char c) {
        if (this._wptr < this.lim) {
            Unsafe.getUnsafe().putByte(this._wptr++, (byte)c);
        }
        return this;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void toSink(CharSink sink) {
        Chars.utf8Decode(this.address, this._wptr, sink);
    }
}

