/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.HeapRowCursor;
import io.questdb.std.ObjList;

public class HeapRowCursorFactory
implements RowCursorFactory {
    private final HeapRowCursor cursor;
    private final ObjList<? extends RowCursorFactory> cursorFactories;
    private final ObjList<RowCursor> cursors;
    private int[] cursorFactoriesIdx;

    public HeapRowCursorFactory(ObjList<? extends RowCursorFactory> cursorFactories, int[] cursorFactoriesIdx) {
        this.cursorFactories = cursorFactories;
        this.cursors = new ObjList();
        this.cursor = new HeapRowCursor();
        this.cursorFactoriesIdx = cursorFactoriesIdx;
    }

    @Override
    public RowCursor getCursor(DataFrame dataFrame) {
        int n = this.cursorFactories.size();
        for (int i = 0; i < n; ++i) {
            this.cursors.extendAndSet(i, this.cursorFactories.getQuick(i).getCursor(dataFrame));
        }
        this.cursor.of(this.cursors, this.cursorFactoriesIdx[0]);
        return this.cursor;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public void prepareCursor(TableReader tableReader, SqlExecutionContext sqlExecutionContext) throws SqlException {
        RowCursorFactory.prepareCursor(this.cursorFactories, tableReader, sqlExecutionContext);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Table-order scan");
        int n = this.cursorFactories.size();
        for (int i = 0; i < n; ++i) {
            sink.child(this.cursorFactories.getQuick(i));
        }
    }
}

