/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.EventQueue;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/**
 * Represents <em>Modules</em> tab in the NetBeans platforms customizer.
 *
 * @author Martin Krauskopf
 */
final class NbPlatformCustomizerModules extends JPanel {

    private static final RequestProcessor RP = new RequestProcessor(NbPlatformCustomizerModules.class.getName());
    
    /** Creates new form NbPlatformCustomizerModules */
    NbPlatformCustomizerModules() {
        initComponents();
        initAccessibility();
    }
    
    void setPlatform(final NbPlatform plaf) {
        moduleList.setModel(createWaitModel());
        RP.post(new Runnable() {
            public void run() {
                final ModuleEntry[] modules = plaf.getSortedModules();
                EventQueue.invokeLater(new Runnable() {
                    public void run() {
                        moduleList.setModel(new PlatformComponentFactory.ModuleEntryListModel(modules));
                    }
                });
            }
        });
    }
    
    void reset() {
        moduleList.setModel(new DefaultListModel());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        moduleLabel = new javax.swing.JLabel();
        moduleSP = new javax.swing.JScrollPane();
        moduleList = new javax.swing.JList();

        setLayout(new java.awt.GridBagLayout());

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(12, 12, 12, 12)));
        moduleLabel.setLabelFor(moduleList);
        org.openide.awt.Mnemonics.setLocalizedText(moduleLabel, org.openide.util.NbBundle.getMessage(NbPlatformCustomizerModules.class, "LBL_PlatformModules"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(moduleLabel, gridBagConstraints);

        moduleList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        moduleSP.setViewportView(moduleList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(moduleSP, gridBagConstraints);

    }
    // </editor-fold>//GEN-END:initComponents
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel moduleLabel;
    private javax.swing.JList moduleList;
    private javax.swing.JScrollPane moduleSP;
    // End of variables declaration//GEN-END:variables
    
    private void initAccessibility() {
        moduleList.getAccessibleContext().setAccessibleDescription(getMessage("ACS_CTL_moduleList"));
    }
    
    private String getMessage(String key) {
        return NbBundle.getMessage(NbPlatformCustomizerJavadoc.class, key);
    }
    
    private ListModel createWaitModel() {
        DefaultListModel waitModel = new DefaultListModel();
        waitModel.addElement(NbBundle.getMessage(
                NbPlatformCustomizerModules.class, "LBL_PleaseWait")); // NOI18N
        return waitModel;
    }
    
}
