"use strict";
/*Queue ->
    enqueue
        -> no delay
            -> push runnable into the queue
                -> task running Y  -> EOP
                -> task running N  -> trigger queue loop

*/
Object.defineProperty(exports, "__esModule", { value: true });
let activeTimeout = null;
function debounce(runnable, timeout) {
    if (!!activeTimeout) {
        clearTimeout(activeTimeout);
    }
    if (timeout > 0) {
        activeTimeout = setTimeout(() => {
            try {
                runnable();
            }
            finally {
                clearTimeout(activeTimeout);
                activeTimeout = null;
            }
        }, timeout);
    }
    else {
        runnable();
    }
}
class XhrQueueController {
    constructor() {
        this.queue = [];
        this.taskRunning = false;
        document.body.addEventListener("xhrNext", () => this.next());
        document.body.addEventListener("xhrClear", () => this.clear());
    }
    enqueue(request, timeOut) {
        debounce(() => {
            if (!this.taskRunning) {
                this.signalTaskRunning();
                request.start();
            }
            else {
                this.queue.push(request);
            }
        }, timeOut);
    }
    signalTaskRunning() {
        this.taskRunning = true;
    }
    next() {
        const next = this.queue.shift();
        this.taskRunning = !!this.queue.length;
        next === null || next === void 0 ? void 0 : next.start();
    }
    clear() {
        this.queue.length = 0;
        this.taskRunning = false;
    }
}
//# sourceMappingURL=XhrQueueController.js.map