/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.view.facelets.AbstractFaceletContext;
import org.apache.myfaces.view.facelets.ELExpressionCacheMode;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.TemplateClient;
import org.apache.myfaces.view.facelets.TemplateContext;
import org.apache.myfaces.view.facelets.el.FaceletStateValueExpression;
import org.apache.myfaces.view.facelets.impl.TemplateContextImpl;
import org.apache.myfaces.view.facelets.tag.ComponentContainerHandler;
import org.apache.myfaces.view.facelets.tag.TagHandlerUtils;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.tag.jsf.FaceletState;
import org.apache.myfaces.view.facelets.tag.ui.DefineHandler;

final class UserTagHandler
extends TagHandler
implements TemplateClient,
ComponentContainerHandler {
    protected final TagAttribute[] _vars;
    protected final URL _location;
    protected final Map<String, DefineHandler> _handlers;

    public UserTagHandler(TagConfig config, URL location) {
        super(config);
        this._vars = this.tag.getAttributes().getAll();
        this._location = location;
        Collection<DefineHandler> defines = TagHandlerUtils.findNextByType(this.nextHandler, DefineHandler.class);
        if (defines.isEmpty()) {
            this._handlers = null;
        } else {
            this._handlers = new HashMap<String, DefineHandler>();
            for (DefineHandler handler : defines) {
                this._handlers.put(handler.getName(), handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        try {
            String[] names = null;
            ValueExpression[] values = null;
            if (this._vars.length > 0) {
                names = new String[this._vars.length];
                values = new ValueExpression[this._vars.length];
                for (int i = 0; i < this._vars.length; ++i) {
                    names[i] = this._vars[i].getLocalName();
                    values[i] = this._vars[i].getValueExpression(ctx, Object.class);
                }
            }
            actx.pushTemplateContext(new TemplateContextImpl());
            actx.pushClient(this);
            FaceletCompositionContext fcc = FaceletCompositionContext.getCurrentInstance(ctx);
            String uniqueId = fcc.startComponentUniqueIdSection();
            try {
                if (this._vars.length > 0) {
                    if (ELExpressionCacheMode.alwaysRecompile.equals((Object)actx.getELExpressionCacheMode())) {
                        FaceletState faceletState = ComponentSupport.getFaceletState(ctx, parent, true);
                        for (int i = 0; i < this._vars.length; ++i) {
                            faceletState.putBinding(uniqueId, names[i], values[i]);
                            FaceletStateValueExpression ve = new FaceletStateValueExpression(uniqueId, names[i]);
                            actx.getTemplateContext().setParameter(names[i], ve);
                        }
                    } else {
                        for (int i = 0; i < this._vars.length; ++i) {
                            ((AbstractFaceletContext)ctx).getTemplateContext().setParameter(names[i], values[i]);
                        }
                    }
                }
                if (!ELExpressionCacheMode.alwaysRecompile.equals((Object)actx.getELExpressionCacheMode())) {
                    actx.getTemplateContext().setAllowCacheELExpressions(false);
                }
                ctx.includeFacelet(parent, this._location);
            }
            finally {
                fcc.endComponentUniqueIdSection();
            }
        }
        catch (FileNotFoundException e) {
            throw new TagException(this.tag, e.getMessage());
        }
        finally {
            actx.popClient(this);
            actx.popTemplateContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply(FaceletContext ctx, UIComponent parent, String name) throws IOException, FacesException, FaceletException, ELException {
        if (name != null) {
            if (this._handlers == null) {
                return false;
            }
            DefineHandler handler = this._handlers.get(name);
            if (handler != null) {
                AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
                TemplateContext itc = actx.popTemplateContext();
                try {
                    handler.applyDefinition(ctx, parent);
                }
                finally {
                    actx.pushTemplateContext(itc);
                }
                return true;
            }
            return false;
        }
        AbstractFaceletContext actx = (AbstractFaceletContext)ctx;
        TemplateContext itc = actx.popTemplateContext();
        try {
            this.nextHandler.apply(ctx, parent);
        }
        finally {
            actx.pushTemplateContext(itc);
        }
        return true;
    }
}

