/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0045_muc.storage;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.Room;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.model.RoomType;
import org.apache.vysper.xmpp.modules.extension.xep0045_muc.storage.RoomStorageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryRoomStorageProvider
implements RoomStorageProvider {
    private Map<Entity, Room> rooms = new ConcurrentHashMap<Entity, Room>();

    @Override
    public void initialize() {
    }

    @Override
    public Room createRoom(Entity jid, String name, RoomType ... roomTypes) {
        Room room = new Room(jid, name, roomTypes);
        this.rooms.put(jid, room);
        return room;
    }

    @Override
    public Collection<Room> getAllRooms() {
        return Collections.unmodifiableCollection(this.rooms.values());
    }

    @Override
    public Room findRoom(Entity jid) {
        return this.rooms.get(jid);
    }

    @Override
    public boolean roomExists(Entity jid) {
        return this.rooms.containsKey(jid);
    }

    @Override
    public void deleteRoom(Entity jid) {
        this.rooms.remove(jid);
    }
}

