/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.storageprovider;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.ItemVisitor;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.MemberAffiliationVisitor;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubAffiliation;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.SubscriberVisitor;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.LastOwnerResignedException;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.LeafNode;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.PayloadItem;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.storageprovider.LeafNodeStorageProvider;

public class LeafNodeInMemoryStorageProvider
implements LeafNodeStorageProvider {
    protected Map<String, Map<Entity, PubSubAffiliation>> nodeAffiliations;
    protected Map<String, Map<String, Entity>> nodeSubscribers = new TreeMap<String, Map<String, Entity>>();
    protected Map<String, Map<String, PayloadItem>> nodeMessages = new TreeMap<String, Map<String, PayloadItem>>();

    public LeafNodeInMemoryStorageProvider() {
        this.nodeAffiliations = new TreeMap<String, Map<Entity, PubSubAffiliation>>();
    }

    public void addSubscriber(String nodeName, String subscriptionID, Entity subscriber) {
        Map<String, Entity> subscribers = this.nodeSubscribers.get(nodeName);
        subscribers.put(subscriptionID, subscriber);
    }

    public boolean containsSubscriber(String nodeName, Entity subscriber) {
        Map<String, Entity> subscribers = this.nodeSubscribers.get(nodeName);
        return subscribers.containsValue(subscriber);
    }

    public boolean containsSubscriber(String nodeName, String subscriptionId) {
        Map<String, Entity> subscribers = this.nodeSubscribers.get(nodeName);
        return subscribers.containsKey(subscriptionId);
    }

    public Entity getSubscriber(String nodeName, String subscriptionId) {
        Map<String, Entity> subscribers = this.nodeSubscribers.get(nodeName);
        return subscribers.get(subscriptionId);
    }

    public boolean removeSubscription(String nodeName, String subscriptionId) {
        Map<String, Entity> subscribers = this.nodeSubscribers.get(nodeName);
        return subscribers.remove(subscriptionId) != null;
    }

    public boolean removeSubscriber(String nodeName, Entity subscriber) {
        Map<String, Entity> subscribers = this.nodeSubscribers.get(nodeName);
        return subscribers.values().remove(subscriber);
    }

    public int countSubscriptions(String nodeName, Entity subscriber) {
        Map<String, Entity> subscribers = this.nodeSubscribers.get(nodeName);
        int count = 0;
        for (Entity sub : subscribers.values()) {
            if (!subscriber.equals(sub)) continue;
            ++count;
        }
        return count;
    }

    public int countSubscriptions(String nodeName) {
        Map<String, Entity> subscribers = this.nodeSubscribers.get(nodeName);
        return subscribers.size();
    }

    public void addMessage(Entity publisher, String nodeName, String itemID, XMLElement payload) {
        Map<String, PayloadItem> messages = this.nodeMessages.get(nodeName);
        messages.put(itemID, new PayloadItem(publisher, payload, itemID));
    }

    public void acceptForEachSubscriber(String nodeName, SubscriberVisitor subscriberVisitor) {
        Map<String, Entity> subscribers = this.nodeSubscribers.get(nodeName);
        for (String subID : subscribers.keySet()) {
            subscriberVisitor.visit(nodeName, subID, subscribers.get(subID));
        }
    }

    public void initialize() {
    }

    public void acceptForEachItem(String nodeName, ItemVisitor iv) {
        Map<String, PayloadItem> messages = this.nodeMessages.get(nodeName);
        for (String itemID : messages.keySet()) {
            iv.visit(itemID, messages.get(itemID));
        }
    }

    public void initialize(LeafNode leafNode) {
        this.nodeMessages.put(leafNode.getName(), new TreeMap());
        this.nodeSubscribers.put(leafNode.getName(), new TreeMap());
        this.nodeAffiliations.put(leafNode.getName(), new HashMap());
    }

    public void delete(String name) {
        this.nodeMessages.remove(name);
        this.nodeSubscribers.remove(name);
        this.nodeAffiliations.remove(name);
    }

    public void setAffiliation(String nodeName, Entity entity, PubSubAffiliation affiliation) throws LastOwnerResignedException {
        Map<Entity, PubSubAffiliation> affils = this.nodeAffiliations.get(nodeName);
        Entity bareJID = entity.getBareJID();
        if (this.getAffiliation(nodeName, bareJID).equals((Object)PubSubAffiliation.OWNER) && !affiliation.equals((Object)PubSubAffiliation.OWNER) && this.countAffiliations(nodeName, PubSubAffiliation.OWNER) == 1) {
            throw new LastOwnerResignedException(bareJID.getFullQualifiedName() + " tried to resign from " + nodeName);
        }
        if (affiliation.equals((Object)PubSubAffiliation.NONE)) {
            affils.remove(bareJID);
        } else {
            affils.put(bareJID, affiliation);
        }
    }

    private int countAffiliations(String nodeName, PubSubAffiliation affiliation) {
        Map<Entity, PubSubAffiliation> affils = this.nodeAffiliations.get(nodeName);
        int i = 0;
        for (PubSubAffiliation a : affils.values()) {
            if (!a.equals((Object)affiliation)) continue;
            ++i;
        }
        return i;
    }

    public PubSubAffiliation getAffiliation(String nodeName, Entity entity) {
        PubSubAffiliation psa = this.nodeAffiliations.get(nodeName).get(entity.getBareJID());
        return psa != null ? psa : PubSubAffiliation.NONE;
    }

    public void acceptForEachMemberAffiliation(String name, MemberAffiliationVisitor mav) {
        Map<Entity, PubSubAffiliation> affils = this.nodeAffiliations.get(name);
        for (Entity jid : affils.keySet()) {
            PubSubAffiliation affil = affils.get(jid);
            mav.visit(jid, affil);
        }
    }
}

