/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import java.io.IOException;
import java.io.InputStream;

public class TrackingInputStream
extends InputStream {
    private final InputStream in;
    private long position;
    private long markPos;

    public TrackingInputStream(InputStream in) {
        this.in = in;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
        this.position = this.markPos;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
        this.markPos = this.position;
    }

    public long skip(long n) throws IOException {
        long read = this.in.skip(n);
        if (read > 0L) {
            this.position += read;
        }
        return read;
    }

    public int read(byte[] b) throws IOException {
        int read = this.in.read(b);
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    public int read() throws IOException {
        int read = this.in.read();
        if (read >= 0) {
            ++this.position;
        }
        return read;
    }

    public long getPosition() {
        return this.position;
    }
}

