/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.servicediscovery.handler;

import java.util.List;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.core.base.handler.DefaultIQHandler;
import org.apache.vysper.xmpp.modules.servicediscovery.collection.ServiceCollector;
import org.apache.vysper.xmpp.modules.servicediscovery.management.InfoRequest;
import org.apache.vysper.xmpp.modules.servicediscovery.management.Item;
import org.apache.vysper.xmpp.modules.servicediscovery.management.ServiceDiscoveryRequestException;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoItemIQHandler
extends DefaultIQHandler {
    final Logger logger = LoggerFactory.getLogger(DiscoItemIQHandler.class);

    protected boolean verifyNamespace(Stanza stanza) {
        return this.verifyInnerNamespace(stanza, "http://jabber.org/protocol/disco#items");
    }

    protected boolean verifyInnerElement(Stanza stanza) {
        return this.verifyInnerElementWorker(stanza, "query");
    }

    protected Stanza handleGet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        List<Item> items;
        ServiceCollector serviceCollector = null;
        try {
            serviceCollector = (ServiceCollector)serverRuntimeContext.getServerRuntimeContextService("discoRequestListenerRegistry");
        }
        catch (Exception e) {
            this.logger.error("error retrieving ServiceCollector service {}", (Throwable)e);
            serviceCollector = null;
        }
        if (serviceCollector == null) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.INTERNAL_SERVER_ERROR, stanza, StanzaErrorType.CANCEL, "cannot retrieve IQ-get-items result from internal components", this.getErrorLanguage(serverRuntimeContext, sessionContext), null);
        }
        Entity to = stanza.getTo();
        boolean isServerInfoRequest = false;
        boolean isComponentInfoRequest = false;
        if (to == null) {
            isServerInfoRequest = true;
        } else if (!to.isNodeSet()) {
            isServerInfoRequest = serverRuntimeContext.getServerEnitity().equals(to);
            boolean bl = isComponentInfoRequest = serverRuntimeContext.getComponentStanzaProcessor(to) != null;
            if (!isServerInfoRequest && !isComponentInfoRequest) {
                return ServerErrorResponses.getStanzaError(StanzaErrorCondition.ITEM_NOT_FOUND, stanza, StanzaErrorType.CANCEL, "server does not handle items query requests for " + to.getFullQualifiedName(), this.getErrorLanguage(serverRuntimeContext, sessionContext), null);
            }
        }
        XMLElement queryElement = stanza.getFirstInnerElement();
        String node = queryElement != null ? queryElement.getAttributeValue("node") : null;
        try {
            Entity from = stanza.getFrom();
            if (from == null) {
                from = sessionContext.getInitiatingEntity();
            }
            items = serviceCollector.processItemRequest(new InfoRequest(from, stanza.getTo(), node, stanza.getID()));
        }
        catch (ServiceDiscoveryRequestException e) {
            StanzaErrorCondition stanzaErrorCondition = e.getErrorCondition();
            if (stanzaErrorCondition == null) {
                stanzaErrorCondition = StanzaErrorCondition.INTERNAL_SERVER_ERROR;
            }
            return ServerErrorResponses.getStanzaError(stanzaErrorCondition, stanza, StanzaErrorType.CANCEL, "disco info request failed.", this.getErrorLanguage(serverRuntimeContext, sessionContext), null);
        }
        StanzaBuilder stanzaBuilder = (StanzaBuilder)StanzaBuilder.createIQStanza(to, stanza.getFrom(), IQStanzaType.RESULT, stanza.getID()).startInnerElement("query", "http://jabber.org/protocol/disco#items");
        if (node != null) {
            stanzaBuilder.addAttribute("node", node);
        }
        for (Item item : items) {
            item.insertElement(stanzaBuilder);
        }
        stanzaBuilder.endInnerElement();
        return (Stanza)stanzaBuilder.build();
    }
}

