# Introduced in 2.17.0

## Bug Fixes

Github issues:

* [GH-469](https://github.com/apache/mina-sshd/issues/469) AKA [SSHD-897](https://issues.apache.org/jira/browse/SSHD-897) Fix duplicate character echo with interactive shells
* [GH-721](https://github.com/apache/mina-sshd/issues/721) SSH client: schedule session timeout checks on demand only
* [GH-807](https://github.com/apache/mina-sshd/issues/807) Handle "verified" flag for sk-* keys
* [GH-809](https://github.com/apache/mina-sshd/pull/809) Fix server-side authentication for FIDO/U2F sk-* keys with flags in `authorized_keys`
* [GH-827](https://github.com/apache/mina-sshd/issues/827) Don't fail on invalid `known_hosts` lines; log and skip them
* [GH-830](https://github.com/apache/mina-sshd/issues/830) EC public keys: let Bouncy Castle generate X.509 encodings with the curve OID as algorithm parameter
* [GH-855](https://github.com/apache/mina-sshd/issues/855) SFTP: use a single `SftpClient` per `SftpFileSystem`
* [GH-856](https://github.com/apache/mina-sshd/issues/856) Fix using ed25519 with BC-FIPS
* [GH-861](https://github.com/apache/mina-sshd/issues/861) SFTP client: prevent sending zero-length writes in `SftpOutputStreamAsync`

JIRA issues:

* [SSHD-897](https://issues.apache.org/jira/browse/SSHD-897) AKA [GH-469](https://github.com/apache/mina-sshd/issues/469) Fix duplicate character echo with interactive shells
* [SSHD-1348](https://issues.apache.org/jira/browse/SSHD-1348) Fix zero-length SFTP reads
* [SSHD-1349](https://issues.apache.org/jira/browse/SSHD-1349) Bump PMD to 7.20.0 to avoid StackOverflowError when compiling on Java 26-ea

## New Features

* [GH-814](https://github.com/apache/mina-sshd/pull/814) Include a fix for CVE-2020-36843 in optional dependency net.i2p.crypto:eddsa:0.3.0: perform the missing range check in Apache MINA SSHD before delegating to the signature verification in net.i2p.crypto:eddsa:0.3.0. This means that using net.i2p.crypto:eddsa:0.3.0 in Apache MINA SSHD is safe despite that CVE in the dependency.
* [GH-865](https://github.com/apache/mina-sshd/issues/865) replace `%h` in `HostName` SSH config

## Potential Compatibility Issues

[GH-855](https://github.com/apache/mina-sshd/issues/855) changes the way `SftpFileSystem` deals with multiple threads. It newly uses a single SSH channel via a single thread-safe `SftpClient`, serializing writes at the channel level. The properties relating to the previously used pool of `SftpClient`s have been deprecated and have no effect anymore. User applications using the library should not see any changes.

A beneficial side-effect of this change is that an `SftpFileSystem` creates the SSH session and SFTP channel only when the first SFTP operation is performed. Previously the session and channel were opened right away when an `SftpFileSystem` was instantiated.

## Major Code Re-factoring
