/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.V2RequestSupport;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.DelegationTokenHttpSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.impl.SolrClientBuilder;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@Deprecated(since="9.0")
public class HttpSolrClient
extends BaseHttpSolrClient {
    private static final Charset FALLBACK_CHARSET = StandardCharsets.UTF_8;
    private static final String DEFAULT_PATH = "/select";
    private static final long serialVersionUID = -946812319974801896L;
    protected static final Set<Integer> UNMATCHED_ACCEPTED_ERROR_CODES = Collections.singleton(429);
    public static final String AGENT = "Solr[" + HttpSolrClient.class.getName() + "] 1.0";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final Class<HttpSolrClient> cacheKey = HttpSolrClient.class;
    protected volatile String baseUrl;
    protected ModifiableSolrParams invariantParams;
    protected volatile ResponseParser parser;
    protected volatile RequestWriter requestWriter = new BinaryRequestWriter();
    private final HttpClient httpClient;
    private volatile Boolean followRedirects = false;
    private volatile boolean useMultiPartPost;
    private final boolean internalClient;
    private volatile Set<String> queryParams = Collections.emptySet();
    private volatile Integer connectionTimeout;
    private volatile Integer soTimeout;
    private static final List<String> errPath = Arrays.asList("metadata", "error-class");

    protected HttpSolrClient(Builder builder) {
        this.baseUrl = builder.baseSolrUrl;
        if (this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl.substring(0, this.baseUrl.length() - 1);
        }
        if (this.baseUrl.indexOf(63) >= 0) {
            throw new RuntimeException("Invalid base url for solrj.  The base URL must not contain parameters: " + this.baseUrl);
        }
        if (builder.httpClient != null) {
            this.httpClient = builder.httpClient;
            this.internalClient = false;
        } else {
            this.internalClient = true;
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("followRedirects", this.followRedirects);
            params.set("allowCompression", builder.compression);
            this.httpClient = HttpClientUtil.createClient(params);
        }
        this.parser = builder.responseParser;
        this.invariantParams = builder.invariantParams;
        this.connectionTimeout = builder.connectionTimeoutMillis;
        this.soTimeout = builder.socketTimeoutMillis;
    }

    public Set<String> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(Set<String> queryParams) {
        this.queryParams = queryParams;
    }

    @Override
    public NamedList<Object> request(SolrRequest<?> request, String collection) throws SolrServerException, IOException {
        ResponseParser responseParser = request.getResponseParser();
        if (responseParser == null) {
            responseParser = this.parser;
        }
        return this.request(request, responseParser, collection);
    }

    public NamedList<Object> request(SolrRequest<?> request, ResponseParser processor) throws SolrServerException, IOException {
        return this.request(request, processor, null);
    }

    public NamedList<Object> request(SolrRequest<?> request, ResponseParser processor, String collection) throws SolrServerException, IOException {
        HttpRequestBase method = this.createMethod(request, collection);
        this.setBasicAuthHeader(request, method);
        if (request.getHeaders() != null) {
            Map<String, String> headers = request.getHeaders();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                method.setHeader(entry.getKey(), entry.getValue());
            }
        }
        return this.executeMethod(method, request.getUserPrincipal(), processor, this.isV2ApiRequest(request));
    }

    private boolean isV2ApiRequest(SolrRequest<?> request) {
        return request instanceof V2Request || request.getPath().contains("/____v2");
    }

    private void setBasicAuthHeader(SolrRequest<?> request, HttpRequestBase method) throws UnsupportedEncodingException {
        if (request.getBasicAuthUser() != null && request.getBasicAuthPassword() != null) {
            String userPass = request.getBasicAuthUser() + ":" + request.getBasicAuthPassword();
            String encoded = Base64.getEncoder().encodeToString(userPass.getBytes(FALLBACK_CHARSET));
            method.setHeader((Header)new BasicHeader("Authorization", "Basic " + encoded));
        }
    }

    public HttpUriRequestResponse httpUriRequest(SolrRequest<?> request) throws SolrServerException, IOException {
        ResponseParser responseParser = request.getResponseParser();
        if (responseParser == null) {
            responseParser = this.parser;
        }
        return this.httpUriRequest(request, responseParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpUriRequestResponse httpUriRequest(SolrRequest<?> request, ResponseParser processor) throws SolrServerException, IOException {
        HttpUriRequestResponse mrr = new HttpUriRequestResponse();
        HttpRequestBase method = this.createMethod(request, null);
        ExecutorService pool = ExecutorUtil.newMDCAwareFixedThreadPool(1, new SolrNamedThreadFactory("httpUriRequest"));
        try {
            MDC.put((String)"HttpSolrClient.url", (String)this.baseUrl);
            mrr.future = pool.submit(() -> this.executeMethod(method, request.getUserPrincipal(), processor, this.isV2ApiRequest(request)));
        }
        finally {
            pool.shutdown();
            MDC.remove((String)"HttpSolrClient.url");
        }
        assert (method != null);
        mrr.httpUriRequest = method;
        return mrr;
    }

    protected ModifiableSolrParams calculateQueryParams(Set<String> queryParamNames, ModifiableSolrParams wparams) {
        ModifiableSolrParams queryModParams = new ModifiableSolrParams();
        if (queryParamNames != null) {
            for (String param : queryParamNames) {
                String[] value = wparams.getParams(param);
                if (value == null) continue;
                for (String v : value) {
                    queryModParams.add(param, v);
                }
                wparams.remove(param);
            }
        }
        return queryModParams;
    }

    static String changeV2RequestEndpoint(String basePath) throws MalformedURLException {
        URL oldURL = new URL(basePath);
        String newPath = oldURL.getPath().replaceFirst("/solr", "/api");
        return new URL(oldURL.getProtocol(), oldURL.getHost(), oldURL.getPort(), newPath).toString();
    }

    protected HttpRequestBase createMethod(SolrRequest<?> request, String collection) throws IOException, SolrServerException {
        ResponseParser parser;
        if (request instanceof V2RequestSupport) {
            request = ((V2RequestSupport)((Object)request)).getV2Request();
        }
        SolrParams params = request.getParams();
        final RequestWriter.ContentWriter contentWriter = this.requestWriter.getContentWriter(request);
        Collection<ContentStream> streams = contentWriter == null ? this.requestWriter.getContentStreams(request) : null;
        String path = this.requestWriter.getPath(request);
        if (path == null || !path.startsWith("/")) {
            path = DEFAULT_PATH;
        }
        if ((parser = request.getResponseParser()) == null) {
            parser = this.parser;
        }
        Header[] contextHeaders = this.buildRequestSpecificHeaders(request);
        ModifiableSolrParams wparams = new ModifiableSolrParams(params);
        if (parser != null) {
            wparams.set("wt", parser.getWriterType());
            wparams.set("version", parser.getVersion());
        }
        if (this.invariantParams != null) {
            wparams.add(this.invariantParams);
        }
        Object basePath = this.baseUrl;
        if (collection != null) {
            basePath = (String)basePath + "/" + collection;
        }
        if (request instanceof V2Request) {
            basePath = System.getProperty("solr.v2RealPath") == null || ((V2Request)request).isForceV2() ? this.baseUrl.replace("/solr", "/api") : this.baseUrl + "/____v2";
        }
        if (SolrRequest.METHOD.GET == request.getMethod()) {
            if (streams != null || contentWriter != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GET can't send streams!");
            }
            HttpGet result = new HttpGet((String)basePath + path + wparams.toQueryString());
            this.populateHeaders((HttpMessage)result, contextHeaders);
            return result;
        }
        if (SolrRequest.METHOD.DELETE == request.getMethod()) {
            return new HttpDelete((String)basePath + path + wparams.toQueryString());
        }
        if (SolrRequest.METHOD.POST == request.getMethod() || SolrRequest.METHOD.PUT == request.getMethod()) {
            String url = (String)basePath + path;
            boolean hasNullStreamName = false;
            if (streams != null) {
                for (ContentStream cs : streams) {
                    if (cs.getName() != null) continue;
                    hasNullStreamName = true;
                    break;
                }
            }
            boolean isMultipart = (this.useMultiPartPost && SolrRequest.METHOD.POST == request.getMethod() || streams != null && streams.size() > 1) && !hasNullStreamName;
            LinkedList<NameValuePair> postOrPutParams = new LinkedList<NameValuePair>();
            if (contentWriter != null) {
                String fullQueryUrl = url + wparams.toQueryString();
                HttpPost postOrPut = SolrRequest.METHOD.POST == request.getMethod() ? new HttpPost(fullQueryUrl) : new HttpPut(fullQueryUrl);
                postOrPut.addHeader("Content-Type", contentWriter.getContentType());
                postOrPut.setEntity((HttpEntity)new BasicHttpEntity(){

                    public boolean isStreaming() {
                        return true;
                    }

                    public void writeTo(OutputStream outstream) throws IOException {
                        contentWriter.write(outstream);
                    }
                });
                this.populateHeaders((HttpMessage)postOrPut, contextHeaders);
                return postOrPut;
            }
            if (streams == null || isMultipart) {
                ModifiableSolrParams queryParams = this.calculateQueryParams(this.queryParams, wparams);
                queryParams.add(this.calculateQueryParams(request.getQueryParams(), wparams));
                String fullQueryUrl = url + queryParams.toQueryString();
                HttpEntityEnclosingRequestBase postOrPut = this.fillContentStream(request, streams, wparams, isMultipart, postOrPutParams, fullQueryUrl);
                return postOrPut;
            }
            String fullQueryUrl = url + wparams.toQueryString();
            HttpPost postOrPut = SolrRequest.METHOD.POST == request.getMethod() ? new HttpPost(fullQueryUrl) : new HttpPut(fullQueryUrl);
            this.fillSingleContentStream(streams, (HttpEntityEnclosingRequestBase)postOrPut);
            return postOrPut;
        }
        throw new SolrServerException("Unsupported method: " + request.getMethod());
    }

    private void fillSingleContentStream(Collection<ContentStream> streams, HttpEntityEnclosingRequestBase postOrPut) throws IOException {
        final ContentStream[] contentStream = new ContentStream[1];
        Iterator<ContentStream> iterator = streams.iterator();
        if (iterator.hasNext()) {
            ContentStream content;
            contentStream[0] = content = iterator.next();
        }
        Long size = contentStream[0].getSize();
        postOrPut.setEntity((HttpEntity)new InputStreamEntity(contentStream[0].getStream(), size == null ? -1L : size){

            public Header getContentType() {
                return new BasicHeader("Content-Type", contentStream[0].getContentType());
            }

            public boolean isRepeatable() {
                return false;
            }
        });
    }

    private HttpEntityEnclosingRequestBase fillContentStream(SolrRequest<?> request, Collection<ContentStream> streams, ModifiableSolrParams wparams, boolean isMultipart, LinkedList<NameValuePair> postOrPutParams, String fullQueryUrl) throws IOException {
        HttpPost postOrPut;
        Object object = postOrPut = SolrRequest.METHOD.POST == request.getMethod() ? new HttpPost(fullQueryUrl) : new HttpPut(fullQueryUrl);
        if (!isMultipart) {
            postOrPut.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        }
        LinkedList<FormBodyPart> parts = new LinkedList<FormBodyPart>();
        Iterator<String> iter = wparams.getParameterNamesIterator();
        while (iter.hasNext()) {
            String p = iter.next();
            String[] vals = wparams.getParams(p);
            if (vals == null) continue;
            for (String v : vals) {
                if (isMultipart) {
                    parts.add(new FormBodyPart(p, (ContentBody)new StringBody(v, StandardCharsets.UTF_8)));
                    continue;
                }
                postOrPutParams.add((NameValuePair)new BasicNameValuePair(p, v));
            }
        }
        if (isMultipart && streams != null) {
            for (ContentStream content : streams) {
                String name;
                String contentType = content.getContentType();
                if (contentType == null) {
                    contentType = "application/octet-stream";
                }
                if ((name = content.getName()) == null) {
                    name = "";
                }
                parts.add(new FormBodyPart(name, (ContentBody)new InputStreamBody(content.getStream(), ContentType.parse((String)contentType), content.getName())));
            }
        }
        if (parts.size() > 0) {
            MultipartEntity entity = new MultipartEntity(HttpMultipartMode.STRICT);
            for (FormBodyPart p : parts) {
                entity.addPart(p);
            }
            postOrPut.setEntity((HttpEntity)entity);
        } else {
            postOrPut.setEntity((HttpEntity)new UrlEncodedFormEntity(postOrPutParams, StandardCharsets.UTF_8));
        }
        return postOrPut;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NamedList<Object> executeMethod(HttpRequestBase method, Principal userPrincipal, ResponseParser processor, boolean isV2Api) throws SolrServerException {
        NamedList<Object> namedList;
        block38: {
            String charsetName;
            Charset charset;
            String mimeType;
            int httpStatus;
            HttpResponse response;
            boolean shouldClose;
            InputStream respBody;
            HttpEntity entity;
            block35: {
                NamedList<Object> namedList2;
                block36: {
                    method.addHeader("User-Agent", AGENT);
                    RequestConfig.Builder requestConfigBuilder = HttpClientUtil.createDefaultRequestConfigBuilder();
                    if (this.soTimeout != null) {
                        requestConfigBuilder.setSocketTimeout(this.soTimeout.intValue());
                    }
                    if (this.connectionTimeout != null) {
                        requestConfigBuilder.setConnectTimeout(this.connectionTimeout.intValue());
                    }
                    if (this.followRedirects != null) {
                        requestConfigBuilder.setRedirectsEnabled(this.followRedirects.booleanValue());
                    }
                    method.setConfig(requestConfigBuilder.build());
                    entity = null;
                    respBody = null;
                    shouldClose = true;
                    HttpClientContext httpClientRequestContext = HttpClientUtil.createNewHttpClientRequestContext();
                    if (userPrincipal != null) {
                        httpClientRequestContext.setUserToken((Object)userPrincipal);
                    }
                    response = this.httpClient.execute((HttpUriRequest)method, (HttpContext)httpClientRequestContext);
                    httpStatus = response.getStatusLine().getStatusCode();
                    entity = response.getEntity();
                    respBody = entity.getContent();
                    mimeType = null;
                    charset = null;
                    charsetName = null;
                    ContentType contentType = ContentType.get((HttpEntity)entity);
                    if (contentType != null) {
                        mimeType = contentType.getMimeType().trim().toLowerCase(Locale.ROOT);
                        charset = contentType.getCharset();
                        if (charset != null) {
                            charsetName = charset.name();
                        }
                    }
                    switch (httpStatus) {
                        case 200: 
                        case 400: 
                        case 409: {
                            break;
                        }
                        case 301: 
                        case 302: {
                            if (this.followRedirects.booleanValue()) break;
                            throw new SolrServerException("Server at " + this.getBaseURL() + " sent back a redirect (" + httpStatus + ").");
                        }
                        default: {
                            if (processor != null && contentType != null) break;
                            throw new BaseHttpSolrClient.RemoteSolrException(this.baseUrl, httpStatus, "non ok status: " + httpStatus + ", message:" + response.getStatusLine().getReasonPhrase(), null);
                        }
                    }
                    if (processor != null && !(processor instanceof InputStreamResponseParser)) break block35;
                    NamedList<Object> rsp = new NamedList<Object>();
                    rsp.add("stream", respBody);
                    rsp.add("closeableResponse", response);
                    shouldClose = false;
                    namedList2 = rsp;
                    if (!shouldClose) break block36;
                    Utils.consumeFully(entity);
                }
                return namedList2;
            }
            try {
                Object error;
                String procMimeType;
                String procCt = processor.getContentType();
                if (procCt != null && !(procMimeType = ContentType.parse((String)procCt).getMimeType().trim().toLowerCase(Locale.ROOT)).equals(mimeType)) {
                    if (this.isUnmatchedErrorCode(mimeType, httpStatus)) {
                        throw new BaseHttpSolrClient.RemoteSolrException(this.baseUrl, httpStatus, "non ok status: " + httpStatus + ", message:" + response.getStatusLine().getReasonPhrase(), null);
                    }
                    String prefix = "Expected mime type " + procMimeType + " but got " + mimeType + ". ";
                    Charset exceptionCharset = charset != null ? charset : FALLBACK_CHARSET;
                    try {
                        ByteArrayOutputStream body = new ByteArrayOutputStream();
                        respBody.transferTo(body);
                        throw new BaseHttpSolrClient.RemoteSolrException(this.baseUrl, httpStatus, prefix + body.toString(exceptionCharset), null);
                    }
                    catch (IOException e) {
                        throw new BaseHttpSolrClient.RemoteSolrException(this.baseUrl, httpStatus, "Could not parse response with encoding " + exceptionCharset, e);
                    }
                }
                NamedList<Object> rsp = null;
                try {
                    rsp = processor.processResponse(respBody, charsetName);
                }
                catch (Exception e) {
                    throw new BaseHttpSolrClient.RemoteSolrException(this.baseUrl, httpStatus, e.getMessage(), e);
                }
                Object object = error = rsp == null ? null : rsp.get("error");
                if (error != null && (isV2Api || String.valueOf(Utils.getObjectByPath(error, true, errPath)).endsWith("ExceptionWithErrObject"))) {
                    throw BaseHttpSolrClient.RemoteExecutionException.create(this.baseUrl, rsp);
                }
                if (httpStatus != 200 && !isV2Api) {
                    String reason;
                    NamedList<String> metadata;
                    block37: {
                        metadata = null;
                        reason = null;
                        try {
                            Object metadataObj;
                            if (error == null) break block37;
                            reason = (String)Utils.getObjectByPath(error, false, Collections.singletonList("msg"));
                            if (reason == null) {
                                reason = (String)Utils.getObjectByPath(error, false, Collections.singletonList("trace"));
                            }
                            if ((metadataObj = Utils.getObjectByPath(error, false, Collections.singletonList("metadata"))) instanceof NamedList) {
                                metadata = (NamedList<String>)metadataObj;
                                break block37;
                            }
                            if (metadataObj instanceof List) {
                                List list = (List)metadataObj;
                                metadata = new NamedList(list.size() / 2);
                                for (int i = 0; i < list.size(); i += 2) {
                                    metadata.add((String)list.get(i), (String)list.get(i + 1));
                                }
                                break block37;
                            }
                            if (metadataObj instanceof Map) {
                                metadata = new NamedList<String>((Map)metadataObj);
                            }
                        }
                        catch (Exception metadataObj) {
                            // empty catch block
                        }
                    }
                    if (reason == null) {
                        StringBuilder msg = new StringBuilder();
                        msg.append(response.getStatusLine().getReasonPhrase()).append("\n\n").append("request: ").append(method.getURI());
                        reason = URLDecoder.decode(msg.toString(), FALLBACK_CHARSET);
                    }
                    BaseHttpSolrClient.RemoteSolrException rss = new BaseHttpSolrClient.RemoteSolrException(this.baseUrl, httpStatus, reason, null);
                    if (metadata != null) {
                        rss.setMetadata(metadata);
                    }
                    throw rss;
                }
                namedList = rsp;
                if (!shouldClose) break block38;
            }
            catch (ConnectException e) {
                try {
                    throw new SolrServerException("Server refused connection at: " + this.getBaseURL(), e);
                    catch (SocketTimeoutException e2) {
                        throw new SolrServerException("Timeout occurred while waiting response from server at: " + this.getBaseURL(), e2);
                    }
                    catch (IOException e3) {
                        throw new SolrServerException("IOException occurred when talking to server at: " + this.getBaseURL(), e3);
                    }
                }
                catch (Throwable throwable) {
                    if (shouldClose) {
                        Utils.consumeFully(entity);
                    }
                    throw throwable;
                }
            }
            Utils.consumeFully(entity);
        }
        return namedList;
    }

    private boolean isUnmatchedErrorCode(String mimeType, int httpStatus) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.equalsIgnoreCase("text/html") && UNMATCHED_ACCEPTED_ERROR_CODES.contains(httpStatus);
    }

    private Header[] buildRequestSpecificHeaders(SolrRequest<?> request) {
        Header[] contextHeaders = new Header[]{new BasicHeader("Solr-Request-Context", this.getContext().toString()), new BasicHeader("Solr-Request-Type", request.getRequestType())};
        return contextHeaders;
    }

    private void populateHeaders(HttpMessage message, Header[] contextHeaders) {
        message.addHeader(contextHeaders[0]);
        message.addHeader(contextHeaders[1]);
    }

    public ModifiableSolrParams getInvariantParams() {
        return this.invariantParams;
    }

    public String getBaseURL() {
        return this.baseUrl;
    }

    public void setBaseURL(String baseURL) {
        this.baseUrl = baseURL;
    }

    public ResponseParser getParser() {
        return this.parser;
    }

    public void setParser(ResponseParser processor) {
        this.parser = processor;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient != null && this.internalClient) {
            HttpClientUtil.close(this.httpClient);
        }
    }

    public boolean isUseMultiPartPost() {
        return this.useMultiPartPost;
    }

    public void setUseMultiPartPost(boolean useMultiPartPost) {
        this.useMultiPartPost = useMultiPartPost;
    }

    @Deprecated(since="9.0")
    public static class Builder
    extends SolrClientBuilder<Builder> {
        protected String baseSolrUrl;
        protected boolean compression;
        protected ModifiableSolrParams invariantParams = new ModifiableSolrParams();

        public Builder() {
            this.responseParser = new BinaryResponseParser();
        }

        public Builder withBaseSolrUrl(String baseSolrUrl) {
            this.baseSolrUrl = baseSolrUrl;
            return this;
        }

        public Builder(String baseSolrUrl) {
            this.baseSolrUrl = baseSolrUrl;
            this.responseParser = new BinaryResponseParser();
        }

        public Builder allowCompression(boolean compression) {
            this.compression = compression;
            return this;
        }

        public Builder withKerberosDelegationToken(String delegationToken) {
            if (this.invariantParams.get("delegation") != null) {
                throw new IllegalStateException("delegation is already defined!");
            }
            this.invariantParams.add("delegation", delegationToken);
            return this;
        }

        public Builder withInvariantParams(ModifiableSolrParams params) {
            Objects.requireNonNull(params, "params must be non null!");
            for (String name : params.getParameterNames()) {
                if (this.invariantParams.get(name) == null) continue;
                throw new IllegalStateException("parameter " + name + " is redefined.");
            }
            this.invariantParams.add(params);
            return this;
        }

        public HttpSolrClient build() {
            if (this.baseSolrUrl == null) {
                throw new IllegalArgumentException("Cannot create HttpSolrClient without a valid baseSolrUrl!");
            }
            if (this.invariantParams.get("delegation") == null) {
                return new HttpSolrClient(this);
            }
            return new DelegationTokenHttpSolrClient(this);
        }

        @Override
        public Builder getThis() {
            return this;
        }
    }

    public static class HttpUriRequestResponse {
        public HttpUriRequest httpUriRequest;
        public Future<NamedList<Object>> future;
    }
}

