/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.CharacterInput;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.ILimitChecker;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.NullCheckClause;
import org.apache.manifoldcf.core.interfaces.ResultSpecification;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.system.Logging;

public class Carrydown
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: Carrydown.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String jobIDField = "jobid";
    public static final String parentIDHashField = "parentidhash";
    public static final String childIDHashField = "childidhash";
    public static final String dataNameField = "dataname";
    public static final String dataValueHashField = "datavaluehash";
    public static final String dataValueField = "datavalue";
    public static final String newField = "isnew";
    public static final String processIDField = "processid";
    protected static final int ISNEW_BASE = 0;
    protected static final int ISNEW_NEW = 1;
    protected static final int ISNEW_EXISTING = 2;
    protected static Map isNewMap = new HashMap();

    public Carrydown(IDBInterface database) throws ManifoldCFException {
        super(database, "carrydown");
    }

    public void install(String jobsTable, String jobsColumn) throws ManifoldCFException {
        block7: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(jobIDField, new ColumnDescription("BIGINT", false, false, jobsTable, jobsColumn, false));
                map.put(parentIDHashField, new ColumnDescription("VARCHAR(40)", false, true, null, null, false));
                map.put(childIDHashField, new ColumnDescription("VARCHAR(40)", false, false, null, null, false));
                map.put(dataNameField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
                map.put(dataValueHashField, new ColumnDescription("VARCHAR(40)", false, true, null, null, false));
                map.put(dataValueField, new ColumnDescription("LONGTEXT", false, true, null, null, false));
                map.put(newField, new ColumnDescription("CHAR(1)", false, true, null, null, false));
                map.put(processIDField, new ColumnDescription("VARCHAR(16)", false, true, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription uniqueIndex = new IndexDescription(true, new String[]{jobIDField, parentIDHashField, childIDHashField, dataNameField, dataValueHashField});
            IndexDescription jobChildDataIndex = new IndexDescription(false, new String[]{jobIDField, childIDHashField, dataNameField});
            IndexDescription newIndex = new IndexDescription(false, new String[]{newField, processIDField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (uniqueIndex != null && id.equals((Object)uniqueIndex)) {
                    uniqueIndex = null;
                    continue;
                }
                if (jobChildDataIndex != null && id.equals((Object)jobChildDataIndex)) {
                    jobChildDataIndex = null;
                    continue;
                }
                if (newIndex != null && id.equals((Object)newIndex)) {
                    newIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (jobChildDataIndex != null) {
                this.performAddIndex(null, jobChildDataIndex);
            }
            if (newIndex != null) {
                this.performAddIndex(null, newIndex);
            }
            if (uniqueIndex == null) break block7;
            this.performAddIndex(null, uniqueIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public void analyzeTables() throws ManifoldCFException {
        long startTime = System.currentTimeMillis();
        Logging.perf.debug((Object)"Beginning to analyze carrydown table");
        this.analyzeTable();
        Logging.perf.debug((Object)("Done analyzing carrydown table in " + new Long(System.currentTimeMillis() - startTime) + " ms"));
    }

    public void deleteOwner(Long jobID) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID)});
        this.performDelete("WHERE " + query, list, null);
    }

    public void restart(String processID) throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(newField, (Object)Carrydown.statusToString(1)), new UnitaryClause(processIDField, (Object)processID)});
        this.performDelete("WHERE " + query, list, null);
        map.put(newField, Carrydown.statusToString(0));
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(newField, (Object)Carrydown.statusToString(2)), new UnitaryClause(processIDField, (Object)processID)});
        this.performUpdate(map, "WHERE " + query, list, null);
    }

    public void restart() throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(newField, (Object)Carrydown.statusToString(1))});
        this.performDelete("WHERE " + query, list, null);
        map.put(newField, Carrydown.statusToString(0));
        list.clear();
        query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(newField, (Object)Carrydown.statusToString(2))});
        this.performUpdate(map, "WHERE " + query, list, null);
    }

    public void restartCluster() throws ManifoldCFException {
    }

    public boolean recordCarrydownData(Long jobID, String parentDocumentIDHash, String childDocumentIDHash, String[] documentDataNames, String[][] documentDataValueHashes, Object[][] documentDataValues, String processID) throws ManifoldCFException {
        return this.recordCarrydownDataMultiple(jobID, parentDocumentIDHash, new String[]{childDocumentIDHash}, new String[][]{documentDataNames}, new String[][][]{documentDataValueHashes}, new Object[][][]{documentDataValues}, processID)[0];
    }

    public boolean[] recordCarrydownDataMultiple(Long jobID, String parentDocumentIDHash, String[] childDocumentIDHashes, String[][] dataNames, String[][][] dataValueHashes, Object[][][] dataValues, String processID) throws ManifoldCFException {
        HashSet<ValueRecord> duplicateRemoval = new HashSet<ValueRecord>();
        HashSet<ValueRecord> presentSet = new HashSet<ValueRecord>();
        int maxClause = this.getMaxOrClause();
        StringBuilder sb = new StringBuilder();
        ArrayList list = new ArrayList();
        int i = 0;
        int k = 0;
        while (k < childDocumentIDHashes.length) {
            String childDocumentIDHash = childDocumentIDHashes[k];
            String[] documentDataNames = dataNames[k];
            String[][] documentDataValueHashes = dataValueHashes[k];
            Object[][] documentDataValues = dataValues[k];
            ++k;
            int q = 0;
            while (q < documentDataNames.length) {
                String documentDataName = documentDataNames[q];
                String[] documentDataValueHashSet = documentDataValueHashes[q];
                Object[] documentDataValueSet = documentDataValues[q];
                ++q;
                if (documentDataValueHashSet == null) continue;
                int p = 0;
                while (p < documentDataValueHashSet.length) {
                    ValueRecord vr;
                    String documentDataValueHash = documentDataValueHashSet[p];
                    Object documentDataValue = documentDataValueSet[p];
                    if (documentDataValueHash != null && documentDataValueHash.length() == 0) {
                        documentDataValueHash = null;
                    }
                    if (duplicateRemoval.contains(vr = new ValueRecord(childDocumentIDHash, documentDataName, documentDataValueHash, documentDataValue))) continue;
                    duplicateRemoval.add(vr);
                    if (i == maxClause) {
                        this.performExistsCheck(presentSet, sb.toString(), list);
                        i = 0;
                        sb.setLength(0);
                        list.clear();
                    }
                    if (i > 0) {
                        sb.append(" OR ");
                    }
                    sb.append(this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(parentIDHashField, (Object)parentDocumentIDHash), new UnitaryClause(childIDHashField, (Object)childDocumentIDHash), new UnitaryClause(dataNameField, (Object)documentDataName), documentDataValueHash == null ? new NullCheckClause(dataValueHashField, true) : new UnitaryClause(dataValueHashField, (Object)documentDataValueHash)}));
                    ++i;
                    ++p;
                }
            }
        }
        if (i > 0) {
            this.performExistsCheck(presentSet, sb.toString(), list);
        }
        HashMap<String, Boolean> insertHappened = new HashMap<String, Boolean>();
        boolean j = false;
        for (ValueRecord childDocumentRecord : duplicateRemoval) {
            String childDocumentIDHash = childDocumentRecord.getDocumentIDHash();
            HashMap<String, Object> map = new HashMap<String, Object>();
            String dataName = childDocumentRecord.getDataName();
            String dataValueHash = childDocumentRecord.getDataValueHash();
            Object dataValue = childDocumentRecord.getDataValue();
            if (!presentSet.contains(childDocumentRecord)) {
                map.put(jobIDField, jobID);
                map.put(parentIDHashField, parentDocumentIDHash);
                map.put(childIDHashField, childDocumentIDHash);
                map.put(dataNameField, dataName);
                if (dataValueHash != null) {
                    map.put(dataValueHashField, dataValueHash);
                    map.put(dataValueField, dataValue);
                }
                map.put(newField, Carrydown.statusToString(1));
                map.put(processIDField, processID);
                this.performInsert(map, null);
                this.noteModifications(1, 0, 0);
                insertHappened.put(childDocumentIDHash, new Boolean(true));
                continue;
            }
            sb = new StringBuilder("WHERE ");
            ArrayList updateList = new ArrayList();
            sb.append(this.buildConjunctionClause(updateList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(parentIDHashField, (Object)parentDocumentIDHash), new UnitaryClause(childIDHashField, (Object)childDocumentIDHash), new UnitaryClause(dataNameField, (Object)dataName), dataValueHash == null ? new NullCheckClause(dataValueHashField, true) : new UnitaryClause(dataValueHashField, (Object)dataValueHash)}));
            map.put(newField, Carrydown.statusToString(2));
            map.put(processIDField, processID);
            this.performUpdate(map, sb.toString(), updateList, null);
            this.noteModifications(0, 1, 0);
        }
        boolean[] rval = new boolean[childDocumentIDHashes.length];
        i = 0;
        while (i < rval.length) {
            String childDocumentIDHash = childDocumentIDHashes[i];
            rval[i++] = insertHappened.get(childDocumentIDHash) != null;
        }
        return rval;
    }

    protected void performExistsCheck(Set<ValueRecord> presentSet, String query, ArrayList list) throws ManifoldCFException {
        IResultSet result = this.performQuery("SELECT childidhash,dataname,datavaluehash FROM " + this.getTableName() + " WHERE " + query + " FOR UPDATE", list, null, null);
        int i = 0;
        while (i < result.getRowCount()) {
            IResultRow row = result.getRow(i++);
            String documentIDHash = (String)row.getValue(childIDHashField);
            String dataName = (String)row.getValue(dataNameField);
            String dataValueHash = (String)row.getValue(dataValueHashField);
            ValueRecord vr = new ValueRecord(documentIDHash, dataName, dataValueHash, null);
            presentSet.add(vr);
        }
    }

    public void revertRecords(Long jobID, String[] parentDocumentIDHashes) throws ManifoldCFException {
        int maxClause = this.getMaxInClause();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        int k = 0;
        for (String parentDocumentIDHash : parentDocumentIDHashes) {
            if (k == maxClause) {
                this.performRevertRecords(sb.toString(), jobID, list);
                sb.setLength(0);
                list.clear();
                k = 0;
            }
            if (k > 0) {
                sb.append(",");
            }
            sb.append("?");
            list.add(parentDocumentIDHash);
            ++k;
        }
        if (k > 0) {
            this.performRevertRecords(sb.toString(), jobID, list);
        }
    }

    protected void performRevertRecords(String query, Long jobID, List<String> list) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("WHERE ");
        ArrayList<String> newList = new ArrayList<String>();
        sb.append(this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(parentIDHashField, list)})).append(" AND ");
        sb.append(newField).append("=?");
        newList.add(Carrydown.statusToString(1));
        this.performDelete(sb.toString(), newList, null);
        sb = new StringBuilder("WHERE ");
        newList.clear();
        sb.append(this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(parentIDHashField, list)})).append(" AND ");
        sb.append(newField).append("=?");
        newList.add(Carrydown.statusToString(2));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(newField, Carrydown.statusToString(0));
        map.put(processIDField, null);
        this.performUpdate(map, sb.toString(), newList, null);
        this.noteModifications(0, list.size(), 0);
    }

    public void restoreRecords(Long jobID, String[] parentDocumentIDHashes) throws ManifoldCFException {
        int maxClause = this.getMaxInClause();
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        int k = 0;
        for (String parentDocumentIDHash : parentDocumentIDHashes) {
            if (k == maxClause) {
                this.performRestoreRecords(sb.toString(), jobID, list);
                sb.setLength(0);
                list.clear();
                k = 0;
            }
            if (k > 0) {
                sb.append(",");
            }
            sb.append("?");
            list.add(parentDocumentIDHash);
            ++k;
        }
        if (k > 0) {
            this.performRestoreRecords(sb.toString(), jobID, list);
        }
    }

    protected void performRestoreRecords(String query, Long jobID, List<String> list) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("WHERE ");
        ArrayList<String> newList = new ArrayList<String>();
        sb.append(this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(parentIDHashField, list)})).append(" AND ");
        sb.append(newField).append("=?");
        newList.add(Carrydown.statusToString(0));
        this.performDelete(sb.toString(), newList, null);
        sb = new StringBuilder("WHERE ");
        newList.clear();
        sb.append(this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(parentIDHashField, list)})).append(" AND ");
        sb.append(newField).append(" IN (?,?)");
        newList.add(Carrydown.statusToString(2));
        newList.add(Carrydown.statusToString(1));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(newField, Carrydown.statusToString(0));
        map.put(processIDField, null);
        this.performUpdate(map, sb.toString(), newList, null);
        this.noteModifications(0, list.size(), 0);
    }

    public void deleteRecords(Long jobID, String[] documentIDHashes) throws ManifoldCFException {
        int maxClause = this.maxClausePerformDeleteRecords(jobID);
        ArrayList<String> list = new ArrayList<String>();
        int k = 0;
        for (String documentIDHash : documentIDHashes) {
            if (k == maxClause) {
                this.performDeleteRecords(jobID, list);
                list.clear();
                k = 0;
            }
            list.add(documentIDHash);
            ++k;
        }
        if (k > 0) {
            this.performDeleteRecords(jobID, list);
        }
    }

    protected int maxClausePerformDeleteRecords(Long jobID) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID)});
    }

    protected void performDeleteRecords(Long jobID, List<String> list) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("WHERE ");
        ArrayList newList = new ArrayList();
        sb.append(this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(childIDHashField, list)}));
        this.performDelete(sb.toString(), newList, null);
        sb = new StringBuilder("WHERE ");
        newList.clear();
        sb.append(this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(parentIDHashField, list)}));
        this.performDelete(sb.toString(), newList, null);
        this.noteModifications(0, 0, list.size() * 2);
    }

    public String[] getDataValues(Long jobID, String documentIdentifierHash, String dataName) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(childIDHashField, (Object)documentIdentifierHash), new UnitaryClause(dataNameField, (Object)dataName)});
        IResultSet set = this.getDBInterface().performQuery("SELECT datavaluehash,datavalue FROM " + this.getTableName() + " WHERE " + query + " ORDER BY 1 ASC", list, null, null, -1, null, (ILimitChecker)new ResultDuplicateEliminator());
        String[] rval = new String[set.getRowCount()];
        for (int i = 0; i < rval.length; ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (String)row.getValue(dataValueField);
            if (rval[i] != null) continue;
            rval[i] = "";
        }
        return rval;
    }

    public CharacterInput[] getDataValuesAsFiles(Long jobID, String documentIdentifierHash, String dataName) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(childIDHashField, (Object)documentIdentifierHash), new UnitaryClause(dataNameField, (Object)dataName)});
        ResultSpecification rs = new ResultSpecification();
        rs.setForm(dataValueField, 2);
        IResultSet set = this.getDBInterface().performQuery("SELECT datavaluehash,datavalue FROM " + this.getTableName() + " WHERE " + query + " ORDER BY 1 ASC", list, null, null, -1, rs, (ILimitChecker)new ResultDuplicateEliminator());
        CharacterInput[] rval = new CharacterInput[set.getRowCount()];
        for (int i = 0; i < rval.length; ++i) {
            IResultRow row = set.getRow(i);
            rval[i] = (CharacterInput)row.getValue(dataValueField);
        }
        return rval;
    }

    public static int stringToStatus(String status) {
        Integer value = (Integer)isNewMap.get(status);
        return value;
    }

    public static String statusToString(int status) {
        switch (status) {
            case 0: {
                return "B";
            }
            case 1: {
                return "N";
            }
            case 2: {
                return "E";
            }
        }
        return null;
    }

    static {
        isNewMap.put("B", new Integer(0));
        isNewMap.put("N", new Integer(1));
        isNewMap.put("E", new Integer(2));
    }

    protected static class DuplicateFinder
    implements ILimitChecker {
        protected Long prevJobID = null;
        protected String prevParentIDHash = null;
        protected String prevChildIDHash = null;
        protected String prevDataName = null;
        protected String prevDataValue = null;

        public boolean doesCompareWork() {
            return false;
        }

        public ILimitChecker duplicate() {
            DuplicateFinder df = new DuplicateFinder();
            df.prevJobID = this.prevJobID;
            df.prevParentIDHash = this.prevParentIDHash;
            df.prevChildIDHash = this.prevChildIDHash;
            df.prevDataName = this.prevDataName;
            df.prevDataValue = this.prevDataValue;
            return df;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }

        public boolean checkInclude(IResultRow row) throws ManifoldCFException {
            String childIDHash;
            Long jobID = (Long)row.getValue(Carrydown.jobIDField);
            String parentIDHash = (String)row.getValue(Carrydown.parentIDHashField);
            if (parentIDHash == null) {
                parentIDHash = "";
            }
            if ((childIDHash = (String)row.getValue(Carrydown.childIDHashField)) == null) {
                childIDHash = "";
            }
            String dataName = (String)row.getValue(Carrydown.dataNameField);
            String dataValue = (String)row.getValue(Carrydown.dataValueField);
            if (dataValue == null) {
                dataValue = "";
            }
            if (this.prevJobID != null && jobID.equals(this.prevJobID) && dataName.equals(this.prevDataName) && dataValue.equals(this.prevDataValue) && parentIDHash.equals(this.prevParentIDHash) && childIDHash.equals(this.prevChildIDHash)) {
                return true;
            }
            this.prevJobID = jobID;
            this.prevDataName = dataName;
            this.prevParentIDHash = parentIDHash;
            this.prevChildIDHash = childIDHash;
            this.prevDataValue = dataValue;
            return false;
        }

        public boolean checkContinue() throws ManifoldCFException {
            return true;
        }
    }

    protected static class ValueRecord {
        protected String documentIdentifierHash;
        protected String dataName;
        protected String dataValueHash;
        protected Object dataValue;

        public ValueRecord(String documentIdentifierHash, String dataName, String dataValueHash, Object dataValue) {
            this.documentIdentifierHash = documentIdentifierHash;
            this.dataName = dataName;
            this.dataValueHash = dataValueHash;
            this.dataValue = dataValue;
        }

        public String getDocumentIDHash() {
            return this.documentIdentifierHash;
        }

        public String getDataName() {
            return this.dataName;
        }

        public String getDataValueHash() {
            return this.dataValueHash;
        }

        public Object getDataValue() {
            return this.dataValue;
        }

        public int hashCode() {
            return this.documentIdentifierHash.hashCode() + this.dataName.hashCode() + (this.dataValueHash == null ? 0 : this.dataValueHash.hashCode());
        }

        public boolean equals(Object o) {
            if (!(o instanceof ValueRecord)) {
                return false;
            }
            ValueRecord v = (ValueRecord)o;
            if (!this.documentIdentifierHash.equals(v.documentIdentifierHash)) {
                return false;
            }
            if (!this.dataName.equals(v.dataName)) {
                return false;
            }
            if (this.dataValueHash == null && v.dataValueHash != null) {
                return false;
            }
            if (this.dataValueHash != null && v.dataValueHash == null) {
                return false;
            }
            if (this.dataValueHash == null) {
                return true;
            }
            return this.dataValueHash.equals(v.dataValueHash);
        }
    }

    protected static class ResultDuplicateEliminator
    implements ILimitChecker {
        protected String currentDataHashValue = null;

        public boolean doesCompareWork() {
            return false;
        }

        public ILimitChecker duplicate() {
            return null;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }

        public boolean checkInclude(IResultRow row) throws ManifoldCFException {
            String value = (String)row.getValue(Carrydown.dataValueHashField);
            if (value == null) {
                value = "";
            }
            if (this.currentDataHashValue == null || !value.equals(this.currentDataHashValue)) {
                this.currentDataHashValue = value;
                return true;
            }
            return false;
        }

        public boolean checkContinue() throws ManifoldCFException {
            return true;
        }
    }
}

