/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BinaryItem;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.Compact64bitInt;

public class DataElementHash
extends StreamObject {
    public Compact64bitInt dataElementHashScheme;
    public BinaryItem dataElementHashData;

    public DataElementHash() {
        super(StreamObjectTypeHeaderStart.DataElementHash);
    }

    @Override
    protected void deserializeItemsFromByteArray(byte[] byteArray, AtomicInteger currentIndex, int lengthOfItems) throws TikaException, IOException {
        AtomicInteger index = new AtomicInteger(currentIndex.get());
        this.dataElementHashScheme = BasicObject.parse(byteArray, index, Compact64bitInt.class);
        this.dataElementHashData = BasicObject.parse(byteArray, index, BinaryItem.class);
        if (index.get() - currentIndex.get() != lengthOfItems) {
            throw new StreamObjectParseErrorException(currentIndex.get(), "DataElementHash", "Stream object over-parse error", null);
        }
        currentIndex.set(index.get());
    }

    @Override
    protected int serializeItemsToByteList(List<Byte> byteList) throws IOException {
        int startPoint = byteList.size();
        byteList.addAll(this.dataElementHashScheme.serializeToByteList());
        byteList.addAll(this.dataElementHashData.serializeToByteList());
        return byteList.size() - startPoint;
    }
}

