/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.tools;

import com.sun.istack.tools.DefaultAuthenticator;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class Utils {
    private static final Logger LOGGER = Logger.getLogger(DefaultAuthenticator.class.getName());

    private Utils() {
    }

    static Authenticator getCurrentAuthenticator() {
        Field f = Utils.getTheAuthenticator();
        if (f == null) {
            return null;
        }
        try {
            AccessController.doPrivileged(() -> {
                f.setAccessible(true);
                return null;
            });
            Authenticator authenticator = (Authenticator)f.get(null);
            return authenticator;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            LOGGER.log(Level.FINEST, "Cannot get Authenticator instance", ex);
            Authenticator authenticator = null;
            return authenticator;
        }
        finally {
            AccessController.doPrivileged(() -> {
                f.setAccessible(false);
                return null;
            });
        }
    }

    private static Field getTheAuthenticator() {
        try {
            return Authenticator.class.getDeclaredField("theAuthenticator");
        }
        catch (NoSuchFieldException | SecurityException ex) {
            LOGGER.log(Level.FINEST, "Cannot find Authenticator field", ex);
            return null;
        }
    }
}

