/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.transformation.opennlp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.InvalidFormatException;

public class OpenNlpExtractorConfig {
    public static final String NODE_SMODEL_PATH = "SModelPath";
    public static final String NODE_TMODEL_PATH = "TModelPath";
    public static final String NODE_FINDERMODEL = "FinderModel";
    public static final String ATTRIBUTE_VALUE = "value";
    public static final String ATTRIBUTE_PARAMETERNAME = "parametername";
    public static final String ATTRIBUTE_MODELFILE = "modelfile";
    private static final Map<File, SentenceModel> sModels = new HashMap<File, SentenceModel>();
    private static final Map<File, TokenizerModel> tModels = new HashMap<File, TokenizerModel>();
    private static final Map<File, TokenNameFinderModel> tnfModels = new HashMap<File, TokenNameFinderModel>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SentenceModel loadSModel(File path) throws InvalidFormatException, FileNotFoundException, IOException {
        Map<File, SentenceModel> map = sModels;
        synchronized (map) {
            SentenceModel sd = sModels.get(path);
            if (sd == null) {
                try (FileInputStream is = new FileInputStream(path);){
                    sd = new SentenceModel((InputStream)is);
                }
                sModels.put(path, sd);
            }
            return sd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static TokenizerModel loadTModel(File path) throws InvalidFormatException, FileNotFoundException, IOException {
        Map<File, TokenizerModel> map = tModels;
        synchronized (map) {
            TokenizerModel sd = tModels.get(path);
            if (sd == null) {
                try (FileInputStream is = new FileInputStream(path);){
                    sd = new TokenizerModel((InputStream)is);
                }
                tModels.put(path, sd);
            }
            return sd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static TokenNameFinderModel loadTnfModel(File path) throws InvalidFormatException, FileNotFoundException, IOException {
        Map<File, TokenNameFinderModel> map = tnfModels;
        synchronized (map) {
            TokenNameFinderModel sd = tnfModels.get(path);
            if (sd == null) {
                try (FileInputStream is = new FileInputStream(path);){
                    sd = new TokenNameFinderModel((InputStream)is);
                }
                tnfModels.put(path, sd);
            }
            return sd;
        }
    }

    public static final SentenceDetector sentenceDetector(File path) throws InvalidFormatException, FileNotFoundException, IOException {
        return new SentenceDetectorME(OpenNlpExtractorConfig.loadSModel(path));
    }

    public static final Tokenizer tokenizer(File path) throws InvalidFormatException, FileNotFoundException, IOException {
        return new TokenizerME(OpenNlpExtractorConfig.loadTModel(path));
    }

    public static final NameFinderME finder(File path) throws InvalidFormatException, FileNotFoundException, IOException {
        return new NameFinderME(OpenNlpExtractorConfig.loadTnfModel(path));
    }
}

