/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.transformation.tikaservice;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputCheckActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.transformation.BaseTransformationConnector;
import org.apache.manifoldcf.agents.transformation.tikaservice.Messages;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.VersionContext;
import org.json.simple.parser.ParseException;

public class TikaExtractor
extends BaseTransformationConnector {
    public static final String _rcsid = "@(#)$Id: TikaExtractor.java 1865954 2019-08-26 20:27:25Z schuch $";
    private static final String EDIT_CONFIGURATION_JS = "editConfiguration.js";
    private static final String EDIT_CONFIGURATION_SERVER_HTML = "editConfiguration_Server.html";
    private static final String VIEW_CONFIGURATION_HTML = "viewConfiguration.html";
    private static final String EDIT_SPECIFICATION_JS = "editSpecification.js";
    private static final String EDIT_SPECIFICATION_FIELDMAPPING_HTML = "editSpecification_FieldMapping.html";
    private static final String VIEW_SPECIFICATION_HTML = "viewSpecification.html";
    protected static final String ACTIVITY_EXTRACT = "extract";
    protected static final String[] activitiesList = new String[]{"extract"};
    protected static final long sessionExpirationInterval = 300000L;
    protected static final long inMemoryMaximumFile = 65536L;
    private String tikaHostname = null;
    private String tikaPortString = null;
    private long sessionTimeout = -1L;
    private int tikaPort = -1;
    private HttpClientConnectionManager connectionManager = null;
    private HttpClient httpClient = null;
    private HttpHost tikaHost = null;
    protected static final URI metaURI;
    protected static final URI contentURI;
    protected static final URI checkURI;

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
        this.tikaHostname = configParameters.getParameter("tikaHostname");
        this.tikaPortString = configParameters.getParameter("tikaPort");
    }

    public void disconnect() throws ManifoldCFException {
        this.expireSession();
        this.tikaHostname = null;
        this.tikaPortString = null;
        super.disconnect();
    }

    public void poll() throws ManifoldCFException {
        if (System.currentTimeMillis() >= this.sessionTimeout) {
            this.expireSession();
        }
        if (this.connectionManager != null) {
            this.connectionManager.closeIdleConnections(60000L, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isConnected() {
        return this.sessionTimeout != -1L;
    }

    protected void getSession() throws ManifoldCFException {
        if (this.sessionTimeout == -1L) {
            if (this.tikaHostname == null || this.tikaHostname.length() == 0) {
                throw new ManifoldCFException("Missing host name");
            }
            if (this.tikaPortString == null) {
                throw new ManifoldCFException("Missing port value");
            }
            try {
                this.tikaPort = Integer.parseInt(this.tikaPortString);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Bad port number: " + this.tikaPortString);
            }
            int connectionTimeout = 60000;
            int socketTimeout = 900000;
            PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build());
            poolingConnectionManager.setDefaultMaxPerRoute(1);
            poolingConnectionManager.setValidateAfterInactivity(2000);
            poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(900000).build());
            this.connectionManager = poolingConnectionManager;
            RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(900000).setExpectContinueEnabled(false).setConnectTimeout(60000).setConnectionRequestTimeout(900000);
            HttpClientBuilder builder = HttpClients.custom().setConnectionManager(this.connectionManager).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build());
            builder.setRequestExecutor(new HttpRequestExecutor(900000)).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
            this.httpClient = builder.build();
            this.tikaHost = new HttpHost(this.tikaHostname, this.tikaPort);
        }
        this.sessionTimeout = System.currentTimeMillis() + 300000L;
    }

    protected void expireSession() throws ManifoldCFException {
        this.tikaPort = -1;
        this.httpClient = null;
        this.tikaHost = null;
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
        }
        this.connectionManager = null;
        this.sessionTimeout = -1L;
    }

    public String check() throws ManifoldCFException {
        HttpResponse response;
        this.getSession();
        HttpPut httpPut = new HttpPut(metaURI);
        httpPut.addHeader("Accept", "application/json");
        InputStreamEntity entity = new InputStreamEntity((InputStream)new ByteArrayInputStream("this is a test".getBytes(StandardCharsets.UTF_8)));
        httpPut.setEntity((HttpEntity)entity);
        try {
            response = this.httpClient.execute(this.tikaHost, (HttpRequest)httpPut);
        }
        catch (IOException e) {
            return "Connection error: " + e.getMessage();
        }
        int responseCode = response.getStatusLine().getStatusCode();
        if (response.getStatusLine().getStatusCode() != 200) {
            return "Bad response: " + response.getStatusLine();
        }
        return super.check();
    }

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "TikaExtractor.TikaServerTabName"));
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_JS, null);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("TabName", tabName);
        TikaExtractor.fillInServerTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIGURATION_SERVER_HTML, velocityContext);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String tikaPort;
        String tikaHostname = variableContext.getParameter("tikaHostname");
        if (tikaHostname != null) {
            parameters.setParameter("tikaHostname", tikaHostname);
        }
        if ((tikaPort = variableContext.getParameter("tikaPort")) != null) {
            parameters.setParameter("tikaPort", tikaPort);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        TikaExtractor.fillInServerTab(velocityContext, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIGURATION_HTML, velocityContext);
    }

    protected static void fillInServerTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException {
        String tikaPort;
        String tikaHostname = parameters.getParameter("tikaHostname");
        if (tikaHostname == null) {
            tikaHostname = "localhost";
        }
        if ((tikaPort = parameters.getParameter("tikaPort")) == null) {
            tikaPort = "9998";
        }
        velocityContext.put("TIKAHOSTNAME", tikaHostname);
        velocityContext.put("TIKAPORT", tikaPort);
    }

    public VersionContext getPipelineDescription(Specification os) throws ManifoldCFException, ServiceInterruption {
        SpecPacker sp = new SpecPacker(os);
        return new VersionContext(sp.toPackedString(), this.params, os);
    }

    public boolean checkMimeTypeIndexable(VersionContext pipelineDescription, String mimeType, IOutputCheckActivity checkActivity) throws ManifoldCFException, ServiceInterruption {
        return checkActivity.checkMimeTypeIndexable("text/plain;charset=utf-8");
    }

    public boolean checkDocumentIndexable(VersionContext pipelineDescription, File localFile, IOutputCheckActivity checkActivity) throws ManifoldCFException, ServiceInterruption {
        return true;
    }

    public boolean checkLengthIndexable(VersionContext pipelineDescription, long length, IOutputCheckActivity checkActivity) throws ManifoldCFException, ServiceInterruption {
        return true;
    }

    /*
     * Exception decompiling
     */
    public int addOrReplaceDocumentWithException(String documentURI, VersionContext pipelineDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[TRYBLOCK]], but top level block is 32[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getFormCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecification";
    }

    public String getFormPresaveCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "s" + connectionSequenceNumber + "_checkSpecificationForSave";
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        tabsArray.add(Messages.getString(locale, "TikaExtractor.FieldMappingTabName"));
        TikaExtractor.fillInFieldMappingSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_JS, paramMap);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TABNAME", tabName);
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        paramMap.put("SELECTEDNUM", Integer.toString(actualSequenceNumber));
        TikaExtractor.fillInFieldMappingSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPECIFICATION_FIELDMAPPING_HTML, paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String x = variableContext.getParameter(seqPrefix + "fieldmapping_count");
        if (x != null && x.length() > 0) {
            int i = 0;
            while (i < os.getChildCount()) {
                SpecificationNode node = os.getChild(i);
                if (node.getType().equals("fieldmap") || node.getType().equals("keepAllMetadata") || node.getType().equals("lowerNames") || node.getType().equals("writeLimit")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            int count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                String suffix;
                String prefix = seqPrefix + "fieldmapping_";
                String op = variableContext.getParameter(prefix + "op" + (suffix = "_" + Integer.toString(i)));
                if (op != null && op.equals("Delete")) continue;
                String source = variableContext.getParameter(prefix + "source" + suffix);
                String target = variableContext.getParameter(prefix + "target" + suffix);
                if (target == null) {
                    target = "";
                }
                SpecificationNode node = new SpecificationNode("fieldmap");
                node.setAttribute("source", source);
                node.setAttribute("target", target);
                os.addChild(os.getChildCount(), (ConfigurationNode)node);
            }
            String addop = variableContext.getParameter(seqPrefix + "fieldmapping_op");
            if (addop != null && addop.equals("Add")) {
                String source = variableContext.getParameter(seqPrefix + "fieldmapping_source");
                String target = variableContext.getParameter(seqPrefix + "fieldmapping_target");
                if (target == null) {
                    target = "";
                }
                SpecificationNode node = new SpecificationNode("fieldmap");
                node.setAttribute("source", source);
                node.setAttribute("target", target);
                os.addChild(os.getChildCount(), (ConfigurationNode)node);
            }
            SpecificationNode node = new SpecificationNode("keepAllMetadata");
            String keepAll = variableContext.getParameter(seqPrefix + "keepallmetadata");
            if (keepAll != null) {
                node.setAttribute("value", keepAll);
            } else {
                node.setAttribute("value", "false");
            }
            os.addChild(os.getChildCount(), (ConfigurationNode)node);
            SpecificationNode node2 = new SpecificationNode("lowerNames");
            String lower = variableContext.getParameter(seqPrefix + "lowernames");
            if (lower != null) {
                node2.setAttribute("value", lower);
            } else {
                node2.setAttribute("value", "false");
            }
            os.addChild(os.getChildCount(), (ConfigurationNode)node2);
            SpecificationNode node3 = new SpecificationNode("writeLimit");
            String writeLimit = variableContext.getParameter(seqPrefix + "writelimit");
            if (writeLimit != null) {
                node3.setAttribute("value", writeLimit);
            } else {
                node3.setAttribute("value", "");
            }
            os.addChild(os.getChildCount(), (ConfigurationNode)node3);
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SEQNUM", Integer.toString(connectionSequenceNumber));
        TikaExtractor.fillInFieldMappingSpecificationMap(paramMap, os);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPECIFICATION_HTML, paramMap);
    }

    protected static void fillInFieldMappingSpecificationMap(Map<String, Object> paramMap, Specification os) {
        ArrayList fieldMappings = new ArrayList();
        String keepAllMetadataValue = "true";
        String lowernamesValue = "false";
        String writeLimitValue = "";
        for (int i = 0; i < os.getChildCount(); ++i) {
            SpecificationNode sn = os.getChild(i);
            if (sn.getType().equals("fieldmap")) {
                String targetDisplay;
                String source = sn.getAttributeValue("source");
                String target = sn.getAttributeValue("target");
                if (target == null) {
                    target = "";
                    targetDisplay = "(remove)";
                } else {
                    targetDisplay = target;
                }
                HashMap<String, String> fieldMapping = new HashMap<String, String>();
                fieldMapping.put("SOURCE", source);
                fieldMapping.put("TARGET", target);
                fieldMapping.put("TARGETDISPLAY", targetDisplay);
                fieldMappings.add(fieldMapping);
                continue;
            }
            if (sn.getType().equals("keepAllMetadata")) {
                keepAllMetadataValue = sn.getAttributeValue("value");
                continue;
            }
            if (sn.getType().equals("lowerNames")) {
                lowernamesValue = sn.getAttributeValue("value");
                continue;
            }
            if (!sn.getType().equals("writeLimit")) continue;
            writeLimitValue = sn.getAttributeValue("value");
        }
        paramMap.put("FIELDMAPPINGS", fieldMappings);
        paramMap.put("KEEPALLMETADATA", keepAllMetadataValue);
        paramMap.put("LOWERNAMES", lowernamesValue);
        paramMap.put("WRITELIMIT", writeLimitValue);
    }

    protected static int handleTikaServerRejects(String reason) throws IOException, ManifoldCFException, ServiceInterruption {
        Logging.ingest.warn((Object)("Tika Server: Tika Server rejects: " + reason));
        return 1;
    }

    protected static int handleTikaServerError(String description) throws IOException, ManifoldCFException, ServiceInterruption {
        Logging.ingest.warn((Object)("Tika Server: Tika Server error: " + description));
        return 1;
    }

    protected static int handleTikaServerException(IOException e) throws IOException, ManifoldCFException, ServiceInterruption {
        Logging.ingest.warn((Object)("Tika: Tika exception extracting: " + e.getMessage()), (Throwable)e);
        return 1;
    }

    protected static int handleTikaServerException(ParseException e) throws IOException, ManifoldCFException, ServiceInterruption {
        Logging.ingest.warn((Object)("Tika: Tika exception extracting: " + e.getMessage()), (Throwable)e);
        return 1;
    }

    protected static int handleIOException(IOException e) throws ManifoldCFException {
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
        }
        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
    }

    static {
        try {
            metaURI = new URI("/meta");
            contentURI = new URI("/tika");
            checkURI = new URI("/detect/stream");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected static class SpecPacker {
        private final Map<String, String> sourceTargets = new HashMap<String, String>();
        private final boolean keepAllMetadata;
        private final boolean lowerNames;
        private final int writeLimit;

        public SpecPacker(Specification os) {
            boolean keepAllMetadata = true;
            boolean lowerNames = false;
            int writeLimit = -1;
            boolean ignoreTikaException = true;
            for (int i = 0; i < os.getChildCount(); ++i) {
                String value;
                SpecificationNode sn = os.getChild(i);
                if (sn.getType().equals("keepAllMetadata")) {
                    value = sn.getAttributeValue("value");
                    keepAllMetadata = Boolean.parseBoolean(value);
                    continue;
                }
                if (sn.getType().equals("lowerNames")) {
                    value = sn.getAttributeValue("value");
                    lowerNames = Boolean.parseBoolean(value);
                    continue;
                }
                if (sn.getType().equals("writeLimit")) {
                    value = sn.getAttributeValue("value");
                    if (value.length() == 0) {
                        writeLimit = -1;
                        continue;
                    }
                    writeLimit = Integer.parseInt(value);
                    continue;
                }
                if (!sn.getType().equals("fieldmap")) continue;
                String source = sn.getAttributeValue("source");
                String target = sn.getAttributeValue("target");
                if (target == null) {
                    target = "";
                }
                this.sourceTargets.put(source, target);
            }
            this.keepAllMetadata = keepAllMetadata;
            this.lowerNames = lowerNames;
            this.writeLimit = writeLimit;
        }

        public String toPackedString() {
            StringBuilder sb = new StringBuilder();
            Object[] sortArray = new String[this.sourceTargets.size()];
            int i = 0;
            for (String source : this.sourceTargets.keySet()) {
                sortArray[i++] = source;
            }
            Arrays.sort(sortArray);
            ArrayList<String> packedMappings = new ArrayList<String>();
            String[] fixedList = new String[2];
            for (Object source : sortArray) {
                String target = this.sourceTargets.get(source);
                StringBuilder localBuffer = new StringBuilder();
                fixedList[0] = source;
                fixedList[1] = target;
                TikaExtractor.packFixedList((StringBuilder)localBuffer, (String[])fixedList, (char)':');
                packedMappings.add(localBuffer.toString());
            }
            TikaExtractor.packList((StringBuilder)sb, (List)packedMappings, (char)'+');
            if (this.keepAllMetadata) {
                sb.append('+');
            } else {
                sb.append('-');
            }
            if (this.lowerNames) {
                sb.append('+');
            } else {
                sb.append('-');
            }
            if (this.writeLimit != -1) {
                sb.append('+');
                sb.append(this.writeLimit);
            }
            return sb.toString();
        }

        public String getMapping(String source) {
            return this.sourceTargets.get(source);
        }

        public boolean keepAllMetadata() {
            return this.keepAllMetadata;
        }

        public boolean lowerNames() {
            return this.lowerNames;
        }

        public int writeLimit() {
            return this.writeLimit;
        }
    }

    protected static class MemoryDestinationStorage
    implements DestinationStorage {
        protected final ByteArrayOutputStream outputStream;

        public MemoryDestinationStorage(int sizeHint) {
            this.outputStream = new ByteArrayOutputStream(sizeHint);
        }

        @Override
        public OutputStream getOutputStream() throws ManifoldCFException {
            return this.outputStream;
        }

        @Override
        public long getBinaryLength() throws ManifoldCFException {
            return this.outputStream.size();
        }

        @Override
        public InputStream getInputStream() throws ManifoldCFException {
            return new ByteArrayInputStream(this.outputStream.toByteArray());
        }

        @Override
        public void close() throws ManifoldCFException {
        }
    }

    protected static class FileDestinationStorage
    implements DestinationStorage {
        protected final File outputFile;
        protected final OutputStream outputStream;

        public FileDestinationStorage() throws ManifoldCFException {
            FileOutputStream outputStream;
            File outputFile;
            try {
                outputFile = File.createTempFile("mcftika", "tmp");
                outputStream = new FileOutputStream(outputFile);
            }
            catch (IOException e) {
                TikaExtractor.handleIOException(e);
                outputFile = null;
                outputStream = null;
            }
            this.outputFile = outputFile;
            this.outputStream = outputStream;
        }

        @Override
        public OutputStream getOutputStream() throws ManifoldCFException {
            return this.outputStream;
        }

        @Override
        public long getBinaryLength() throws ManifoldCFException {
            return this.outputFile.length();
        }

        @Override
        public InputStream getInputStream() throws ManifoldCFException {
            try {
                return new FileInputStream(this.outputFile);
            }
            catch (IOException e) {
                TikaExtractor.handleIOException(e);
                return null;
            }
        }

        @Override
        public void close() throws ManifoldCFException {
            this.outputFile.delete();
        }
    }

    protected static interface DestinationStorage {
        public OutputStream getOutputStream() throws ManifoldCFException;

        public long getBinaryLength() throws ManifoldCFException;

        public InputStream getInputStream() throws ManifoldCFException;

        public void close() throws ManifoldCFException;
    }
}

