/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;

public class ThrottleSpecManager
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: ThrottleSpecManager.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String ownerNameField = "ownername";
    public static final String descriptionField = "description";
    public static final String matchField = "matchstring";
    public static final String throttleField = "throttle";

    public ThrottleSpecManager(IDBInterface database) throws ManifoldCFException {
        super(database, "throttlespec");
    }

    public void install(String ownerTable, String owningTablePrimaryKey) throws ManifoldCFException {
        block3: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(ownerNameField, new ColumnDescription("VARCHAR(32)", false, false, ownerTable, owningTablePrimaryKey, false));
                map.put(descriptionField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(matchField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(throttleField, new ColumnDescription("FLOAT", false, false, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription ownerIndex = new IndexDescription(false, new String[]{ownerNameField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (ownerIndex != null && id.equals((Object)ownerIndex)) {
                    ownerIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (ownerIndex == null) break block3;
            this.performAddIndex(null, ownerIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.performDrop(null);
    }

    public IResultSet readRows(String name) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(ownerNameField, (Object)name)});
        return this.performQuery("SELECT description AS description,matchstring AS match,throttle AS value FROM " + this.getTableName() + " WHERE " + query, list, null, null);
    }

    public int maxClauseGetRows() {
        return this.findConjunctionClauseMax(new ClauseDescription[0]);
    }

    public void getRows(IRepositoryConnection[] connections, Map indexMap, ArrayList ownerNameParams) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new MultiClause(ownerNameField, (List)ownerNameParams)});
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE " + query, list, null, null);
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            String ownerName = (String)row.getValue(ownerNameField);
            int index = (Integer)indexMap.get(ownerName);
            String description = (String)row.getValue(descriptionField);
            String match = (String)row.getValue(matchField);
            float throttle = new Float(row.getValue(throttleField).toString()).floatValue();
            connections[index].addThrottleValue(match, description, throttle);
        }
    }

    public void writeRows(String owner, IRepositoryConnection connection) throws ManifoldCFException {
        this.beginTransaction();
        try {
            int i = 0;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String[] matches = connection.getThrottles();
            while (i < matches.length) {
                String match = matches[i++];
                String description = connection.getThrottleDescription(match);
                float value = connection.getThrottleValue(match);
                map.clear();
                map.put(matchField, match);
                if (description != null && description.length() > 0) {
                    map.put(descriptionField, description);
                }
                map.put(throttleField, new Float(value));
                map.put(ownerNameField, owner);
                this.performInsert(map, null);
            }
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public void deleteRows(String owner) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(ownerNameField, (Object)owner)});
        this.performDelete("WHERE " + query, list, null);
    }
}

