/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.jdbcpool;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.jdbcpool.ConnectionPool;

public class ConnectionPoolManager {
    public static final String _rcsid = "@(#)$Id: ConnectionPoolManager.java 1695808 2015-08-14 01:03:18Z kwright $";
    protected final Map<String, ConnectionPool> poolMap;
    protected final ConnectionCloserThread connectionCloserThread;
    protected volatile AtomicBoolean shuttingDown = new AtomicBoolean(false);
    protected final boolean debug;

    public ConnectionPoolManager(int count, boolean debug) throws ManifoldCFException {
        this.debug = debug;
        this.poolMap = new HashMap<String, ConnectionPool>(count);
        this.connectionCloserThread = new ConnectionCloserThread();
        this.connectionCloserThread.start();
    }

    public synchronized ConnectionPool getPool(String poolKey) {
        return this.poolMap.get(poolKey);
    }

    public synchronized ConnectionPool addAlias(String poolKey, String driverClassName, String dbURL, String userName, String password, int maxSize, long expiration) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class.forName(driverClassName).newInstance();
        ConnectionPool cp = new ConnectionPool(dbURL, userName, password, maxSize, expiration, this.debug);
        this.poolMap.put(poolKey, cp);
        return cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ConnectionPoolManager connectionPoolManager = this;
        synchronized (connectionPoolManager) {
            for (String poolKey : this.poolMap.keySet()) {
                ConnectionPool cp = this.poolMap.get(poolKey);
                cp.flushPool();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shuttingDown.set(true);
        while (this.connectionCloserThread.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.connectionCloserThread.interrupt();
            }
        }
        ConnectionPoolManager connectionPoolManager = this;
        synchronized (connectionPoolManager) {
            for (String poolKey : this.poolMap.keySet()) {
                ConnectionPool cp = this.poolMap.get(poolKey);
                cp.closePool();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupExpiredConnections(long cleanupTime) {
        ConnectionPool[] connectionPools;
        ConnectionPoolManager connectionPoolManager = this;
        synchronized (connectionPoolManager) {
            connectionPools = new ConnectionPool[this.poolMap.size()];
            int i = 0;
            for (String poolKey : this.poolMap.keySet()) {
                connectionPools[i++] = this.poolMap.get(poolKey);
            }
        }
        for (int i = 0; i < connectionPools.length; ++i) {
            connectionPools[i].cleanupExpiredConnections(cleanupTime);
        }
    }

    protected class ConnectionCloserThread
    extends Thread {
        public ConnectionCloserThread() {
            this.setName("Connection pool reaper");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!ConnectionPoolManager.this.shuttingDown.get()) {
                ConnectionPoolManager.this.cleanupExpiredConnections(System.currentTimeMillis());
                if (ConnectionPoolManager.this.shuttingDown.get()) break;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

