/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.ldap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.ldap.LDAPProtocolEnum;
import org.apache.manifoldcf.authorities.authorities.ldap.Messages;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.connectorcommon.common.LdapEscaper;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.common.LDAPSSLSocketFactory;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.ICacheCreateHandle;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.ISSLSocketFactoryProducer;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;

public class LDAPAuthority
extends BaseAuthorityConnector {
    public static final String _rcsid = "@(#)$Id: LDAPAuthority.java 1905595 2022-11-29 08:03:25Z kwright $";
    private LdapContext session = null;
    private StartTlsResponse tls = null;
    private long sessionExpirationTime = -1L;
    private String bindUser;
    private String bindPass;
    private String serverProtocol;
    private String serverName;
    private String serverPort;
    private String serverBase;
    private String userBase;
    private String userSearch;
    private String groupBase;
    private String groupSearch;
    private String groupNameAttr;
    private boolean groupMemberDN;
    private boolean addUserRecord;
    private List<String> forcedTokens;
    private String userNameAttr;
    private String sslKeystoreData;
    private IKeystoreManager sslKeystore;
    private long responseLifetime = 60000L;
    private int LRUsize = 1000;
    private ICacheManager cacheManager = null;
    protected static StringSet emptyStringSet = new StringSet();

    public void setThreadContext(IThreadContext tc) throws ManifoldCFException {
        super.setThreadContext(tc);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.bindUser = configParams.getParameter("ldapBindUser");
        this.bindPass = configParams.getObfuscatedParameter("ldapBindPass");
        this.serverProtocol = configParams.getParameter("ldapProtocol");
        this.serverName = configParams.getParameter("ldapServerName");
        this.serverPort = configParams.getParameter("ldapServerPort");
        this.serverBase = configParams.getParameter("ldapServerBase");
        this.sslKeystoreData = configParams.getParameter("sslKeystore");
        this.userBase = configParams.getParameter("ldapUserBase");
        this.userSearch = configParams.getParameter("ldapUserSearch");
        this.groupBase = configParams.getParameter("ldapGroupBase");
        this.groupSearch = configParams.getParameter("ldapGroupSearch");
        this.groupNameAttr = configParams.getParameter("ldapGroupNameAttr");
        this.userNameAttr = configParams.getParameter("ldapUserNameAttr");
        this.groupMemberDN = "1".equals(LDAPAuthority.getParam(configParams, "ldapGroupMemberDn", ""));
        this.addUserRecord = "1".equals(LDAPAuthority.getParam(configParams, "ldapAddUserRecord", ""));
        this.forcedTokens = new ArrayList<String>();
        int i = 0;
        while (i < configParams.getChildCount()) {
            ConfigNode sn;
            if (!(sn = configParams.getChild(i++)).getType().equals("access")) continue;
            String token = sn.getAttributeValue("token");
            this.forcedTokens.add(token);
        }
    }

    protected LdapContext getSession() throws ManifoldCFException {
        try {
            LDAPProtocolEnum ldapProtocol = this.retrieveLDAPProtocol();
            if (this.session == null) {
                if (this.serverName == null || this.serverName.length() == 0) {
                    Logging.authorityConnectors.error((Object)"Server name parameter missing but required");
                    throw new ManifoldCFException("Server name parameter missing but required");
                }
                if (this.serverPort == null || this.serverPort.length() == 0) {
                    Logging.authorityConnectors.error((Object)"Server port parameter missing but required");
                    throw new ManifoldCFException("Server port parameter missing but required");
                }
                if (this.serverBase == null) {
                    Logging.authorityConnectors.error((Object)"Server base parameter missing but required");
                    throw new ManifoldCFException("Server base parameter missing but required");
                }
                if (this.userBase == null) {
                    Logging.authorityConnectors.error((Object)"User base parameter missing but required");
                    throw new ManifoldCFException("User base parameter missing but required");
                }
                if (this.userSearch == null || this.userSearch.length() == 0) {
                    Logging.authorityConnectors.error((Object)"User search expression missing but required");
                    throw new ManifoldCFException("User search expression missing but required");
                }
                if (this.groupBase == null) {
                    Logging.authorityConnectors.error((Object)"Group base parameter missing but required");
                    throw new ManifoldCFException("Group base parameter missing but required");
                }
                if (this.groupSearch == null || this.groupSearch.length() == 0) {
                    Logging.authorityConnectors.error((Object)"Group search expression missing but required");
                    throw new ManifoldCFException("Group search expression missing but required");
                }
                if (this.groupNameAttr == null || this.groupNameAttr.length() == 0) {
                    Logging.authorityConnectors.error((Object)"Group name attribute missing but required");
                    throw new ManifoldCFException("Group name attribute missing but required");
                }
                if (this.userNameAttr == null || this.userNameAttr.length() == 0) {
                    Logging.authorityConnectors.error((Object)"User name attribute missing but required");
                    throw new ManifoldCFException("User name attribute missing but required");
                }
                this.sslKeystore = this.sslKeystoreData != null ? KeystoreManagerFactory.make((String)"", (String)this.sslKeystoreData) : KeystoreManagerFactory.make((String)"");
                Hashtable<String, Object> env = new Hashtable<String, Object>();
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.provider.url", "ldap://" + this.serverName + ":" + this.serverPort + "/" + this.serverBase);
                if (LDAPProtocolEnum.LDAPS.equals((Object)ldapProtocol)) {
                    LDAPSSLSocketFactory.setSocketFactoryProducer((ISSLSocketFactoryProducer)this.sslKeystore);
                    env.put("java.naming.security.protocol", "ssl");
                    env.put("java.naming.ldap.factory.socket", "org.apache.manifoldcf.core.common.LDAPSSLSocketFactory");
                }
                if (this.bindUser != null && !this.bindUser.isEmpty()) {
                    env.put("java.naming.security.authentication", "simple");
                    env.put("java.naming.security.principal", this.bindUser);
                    env.put("java.naming.security.credentials", this.bindPass);
                }
                Logging.authorityConnectors.info((Object)("LDAP Context environment properties: " + this.printLdapContextEnvironment(env)));
                this.session = new InitialLdapContext(env, null);
                if (this.isLDAPTLS(ldapProtocol)) {
                    StartTlsResponse tls = (StartTlsResponse)this.session.extendedOperation(new StartTlsRequest());
                    tls.negotiate(this.sslKeystore.getSecureSocketFactory());
                }
            } else {
                if (this.isLDAPS(ldapProtocol)) {
                    LDAPSSLSocketFactory.setSocketFactoryProducer((ISSLSocketFactoryProducer)this.sslKeystore);
                }
                this.session.reconnect(null);
            }
            this.sessionExpirationTime = System.currentTimeMillis() + 300000L;
            return this.session;
        }
        catch (AuthenticationException e) {
            this.session = null;
            this.sessionExpirationTime = -1L;
            Logging.authorityConnectors.error((Object)("Authentication error: " + e.getMessage() + ", explanation: " + e.getExplanation()), (Throwable)e);
            throw new ManifoldCFException("Authentication error: " + e.getMessage() + ", explanation: " + e.getExplanation(), (Throwable)e);
        }
        catch (CommunicationException e) {
            this.session = null;
            this.sessionExpirationTime = -1L;
            Logging.authorityConnectors.error((Object)("Communication error: " + e.getMessage()), (Throwable)e);
            throw new ManifoldCFException("Communication error: " + e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            this.session = null;
            this.sessionExpirationTime = -1L;
            Logging.authorityConnectors.error((Object)("Naming exception: " + e.getMessage()), (Throwable)e);
            throw new ManifoldCFException("Naming exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedIOException e) {
            this.session = null;
            this.sessionExpirationTime = -1L;
            Logging.authorityConnectors.error((Object)("Interrupted IO error: " + e.getMessage()));
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        catch (IOException e) {
            this.session = null;
            this.sessionExpirationTime = -1L;
            Logging.authorityConnectors.error((Object)("IO error: " + e.getMessage()), (Throwable)e);
            throw new ManifoldCFException("IO error: " + e.getMessage(), (Throwable)e);
        }
    }

    private LDAPProtocolEnum retrieveLDAPProtocol() {
        LDAPProtocolEnum ldapProtocol;
        if (this.serverProtocol == null || this.serverProtocol.length() == 0) {
            return LDAPProtocolEnum.LDAP;
        }
        switch (this.serverProtocol.toUpperCase(Locale.ENGLISH)) {
            case "LDAP": {
                ldapProtocol = LDAPProtocolEnum.LDAP;
                break;
            }
            case "LDAPS": {
                ldapProtocol = LDAPProtocolEnum.LDAPS;
                break;
            }
            case "LDAP+TLS": {
                ldapProtocol = LDAPProtocolEnum.LDAP_TLS;
                break;
            }
            case "LDAPS+TLS": {
                ldapProtocol = LDAPProtocolEnum.LDAPS_TLS;
                break;
            }
            default: {
                ldapProtocol = LDAPProtocolEnum.LDAP;
            }
        }
        return ldapProtocol;
    }

    private boolean isLDAPTLS(LDAPProtocolEnum ldapProtocol) {
        return LDAPProtocolEnum.LDAP_TLS.equals((Object)ldapProtocol) || LDAPProtocolEnum.LDAPS_TLS.equals((Object)ldapProtocol);
    }

    private boolean isLDAPS(LDAPProtocolEnum ldapProtocol) {
        return LDAPProtocolEnum.LDAPS.equals((Object)ldapProtocol) || LDAPProtocolEnum.LDAPS_TLS.equals((Object)ldapProtocol);
    }

    public String check() throws ManifoldCFException {
        this.disconnectSession();
        this.getSession();
        return super.check();
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public void poll() throws ManifoldCFException {
        if (this.session != null && System.currentTimeMillis() > this.sessionExpirationTime) {
            this.disconnectSession();
        }
        super.poll();
    }

    protected void disconnectSession() {
        if (this.session != null) {
            try {
                if (this.tls != null) {
                    this.tls.close();
                }
                this.session.close();
            }
            catch (NamingException namingException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.tls = null;
            this.session = null;
            this.sessionExpirationTime = -1L;
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.disconnectSession();
        super.disconnect();
        this.serverName = null;
        this.serverPort = null;
        this.serverBase = null;
        this.userBase = null;
        this.userSearch = null;
        this.groupBase = null;
        this.groupSearch = null;
        this.groupNameAttr = null;
        this.userNameAttr = null;
        this.forcedTokens = null;
        this.sslKeystoreData = null;
        this.sslKeystore = null;
    }

    protected String createCacheConnectionString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serverName).append(":").append(this.serverPort).append("/").append(this.serverBase);
        return sb.toString();
    }

    protected String createUserSearchString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.userBase).append("|").append(this.userSearch).append("|").append(this.userNameAttr).append("|").append(this.addUserRecord ? (char)'Y' : 'N');
        return sb.toString();
    }

    protected String createGroupSearchString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupBase).append("|").append(this.groupSearch).append("|").append(this.groupNameAttr).append("|").append(this.groupMemberDN ? (char)'Y' : 'N');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        this.getSession();
        LdapAuthorizationResponseDescription objectDescription = new LdapAuthorizationResponseDescription(userName, this.createCacheConnectionString(), this.createUserSearchString(), this.createGroupSearchString(), this.responseLifetime, this.LRUsize);
        ICacheHandle ch = this.cacheManager.enterCache(new ICacheDescription[]{objectDescription}, null, null);
        try {
            AuthorizationResponse response;
            ICacheCreateHandle createHandle;
            block8: {
                AuthorizationResponse authorizationResponse;
                createHandle = this.cacheManager.enterCreateSection(ch);
                try {
                    response = (AuthorizationResponse)this.cacheManager.lookupObject(createHandle, (ICacheDescription)objectDescription);
                    if (response == null) break block8;
                    authorizationResponse = response;
                }
                catch (Throwable throwable) {
                    this.cacheManager.leaveCreateSection(createHandle);
                    throw throwable;
                }
                this.cacheManager.leaveCreateSection(createHandle);
                return authorizationResponse;
            }
            response = this.getAuthorizationResponseUncached(userName);
            this.cacheManager.saveObject(createHandle, (ICacheDescription)objectDescription, (Object)response);
            AuthorizationResponse authorizationResponse = response;
            this.cacheManager.leaveCreateSection(createHandle);
            return authorizationResponse;
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    protected AuthorizationResponse getAuthorizationResponseUncached(String userName) throws ManifoldCFException {
        this.getSession();
        try {
            Attribute attr;
            SearchResult usrRecord = this.getUserEntry(this.session, userName);
            if (usrRecord == null) {
                return RESPONSE_USERNOTFOUND;
            }
            ArrayList<String> theGroups = new ArrayList<String>();
            theGroups.addAll(this.forcedTokens);
            String usrName = userName.split("@")[0];
            if (this.userNameAttr != null && !"".equals(this.userNameAttr) && usrRecord.getAttributes() != null && (attr = usrRecord.getAttributes().get(this.userNameAttr)) != null) {
                usrName = attr.get().toString();
                if (this.addUserRecord) {
                    NamingEnumeration<?> values = attr.getAll();
                    while (values.hasMore()) {
                        theGroups.add(values.next().toString());
                    }
                }
            }
            if (this.groupSearch != null && !this.groupSearch.isEmpty()) {
                String searchFilter = this.groupSearch.replace("{0}", LdapEscaper.escapeFilter((String)(this.groupMemberDN ? usrRecord.getNameInNamespace() : usrName)));
                SearchControls searchCtls = new SearchControls();
                searchCtls.setSearchScope(2);
                String[] returnedAtts = new String[]{this.groupNameAttr};
                searchCtls.setReturningAttributes(returnedAtts);
                NamingEnumeration<SearchResult> answer = this.session.search(this.groupBase, searchFilter, searchCtls);
                while (answer.hasMoreElements()) {
                    SearchResult sr = answer.next();
                    Attributes attrs = sr.getAttributes();
                    if (attrs == null) continue;
                    NamingEnumeration<?> values = attrs.get(this.groupNameAttr).getAll();
                    while (values.hasMore()) {
                        theGroups.add(values.next().toString());
                    }
                }
            }
            String[] tokens = new String[theGroups.size()];
            for (int k = 0; k < tokens.length; ++k) {
                tokens[k] = (String)theGroups.get(k);
            }
            return new AuthorizationResponse(tokens, 0);
        }
        catch (NameNotFoundException e) {
            Logging.authorityConnectors.error((Object)("User does not exists: " + e.getMessage()), (Throwable)e);
            return RESPONSE_USERNOTFOUND;
        }
        catch (NamingException e) {
            Logging.authorityConnectors.error((Object)("Response Unreachable: " + e.getMessage()), (Throwable)e);
            return RESPONSE_UNREACHABLE;
        }
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE;
    }

    private String printLdapContextEnvironment(Hashtable env) {
        Hashtable<String, String> copyEnv = new Hashtable<String, String>(env);
        if (copyEnv.containsKey("java.naming.security.credentials")) {
            copyEnv.put("java.naming.security.credentials", "********");
        }
        return Arrays.toString(copyEnv.entrySet().toArray());
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "LDAP.LDAP"));
        tabsArray.add(Messages.getString(locale, "LDAP.ForcedTokens"));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        LDAPAuthority.fillInLDAPTab(paramMap, out, parameters);
        LDAPAuthority.fillInForcedTokensTab(paramMap, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration.js", paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        LDAPAuthority.fillInLDAPTab(paramMap, out, parameters);
        LDAPAuthority.fillInForcedTokensTab(paramMap, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_LDAP.html", paramMap);
        Messages.outputResourceWithVelocity(out, locale, "editConfiguration_ForcedTokens.html", paramMap);
    }

    private boolean copyParam(IPostParameters variableContext, ConfigParams parameters, String name) {
        String val = variableContext.getParameter(name);
        if (val == null) {
            return false;
        }
        parameters.setParameter(name, val);
        return true;
    }

    private void copyParam(IPostParameters variableContext, ConfigParams parameters, String name, String def) {
        String val = variableContext.getParameter(name);
        if (val == null) {
            val = def;
        }
        parameters.setParameter(name, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String xc;
        this.copyParam(variableContext, parameters, "ldapProtocol");
        this.copyParam(variableContext, parameters, "ldapServerName");
        this.copyParam(variableContext, parameters, "ldapServerPort");
        this.copyParam(variableContext, parameters, "ldapServerBase");
        this.copyParam(variableContext, parameters, "ldapUserBase");
        this.copyParam(variableContext, parameters, "ldapUserSearch");
        this.copyParam(variableContext, parameters, "ldapUserNameAttr");
        this.copyParam(variableContext, parameters, "ldapGroupBase");
        this.copyParam(variableContext, parameters, "ldapGroupSearch");
        this.copyParam(variableContext, parameters, "ldapGroupNameAttr");
        this.copyParam(variableContext, parameters, "ldapGroupMemberDn", "0");
        this.copyParam(variableContext, parameters, "ldapAddUserRecord", "0");
        this.copyParam(variableContext, parameters, "ldapBindUser");
        String bindPass = variableContext.getParameter("ldapBindPass");
        if (bindPass != null) {
            parameters.setObfuscatedParameter("ldapBindPass", variableContext.mapKeyToPassword(bindPass));
        }
        if ((xc = variableContext.getParameter("tokencount")) != null) {
            int i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode sn = parameters.getChild(i);
                if (sn.getType().equals("access")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = "accessop" + accessDescription;
                String command = variableContext.getParameter(accessOpName);
                if (command != null && command.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter("spectoken" + accessDescription);
                ConfigNode node = new ConfigNode("access");
                node.setAttribute("token", accessSpec);
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter("accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter("spectoken");
                ConfigNode node = new ConfigNode("access");
                node.setAttribute("token", accessspec);
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node);
            }
        }
        String sslKeystoreValue = variableContext.getParameter("sslkeystoredata");
        String sslConfigOp = variableContext.getParameter("sslconfigop");
        if (sslConfigOp != null) {
            String alias;
            if (sslConfigOp.equals("Delete")) {
                alias = variableContext.getParameter("sslkeystorealias");
                IKeystoreManager mgr = sslKeystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)sslKeystoreValue) : KeystoreManagerFactory.make((String)"");
                mgr.remove(alias);
                sslKeystoreValue = mgr.getString();
            } else if (sslConfigOp.equals("Add")) {
                alias = IDFactory.make((IThreadContext)threadContext);
                byte[] certificateValue = variableContext.getBinaryBytes("sslcertificate");
                IKeystoreManager mgr = sslKeystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)sslKeystoreValue) : KeystoreManagerFactory.make((String)"");
                ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                String certError = null;
                try {
                    mgr.importCertificate(alias, (InputStream)is);
                }
                catch (Throwable e) {
                    certError = e.getMessage();
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
                if (certError != null) {
                    return "Illegal certificate: " + certError;
                }
                sslKeystoreValue = mgr.getString();
            }
        }
        if (sslKeystoreValue != null) {
            parameters.setParameter("sslkeystore", sslKeystoreValue);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        LDAPAuthority.fillInLDAPTab(paramMap, out, parameters);
        LDAPAuthority.fillInForcedTokensTab(paramMap, out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "viewConfiguration.html", paramMap);
    }

    private static String getParam(ConfigParams parameters, String name, String def) {
        String rval = parameters.getParameter(name);
        return rval != null ? rval : def;
    }

    protected static void fillInForcedTokensTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        ArrayList<String> forcedTokenList = new ArrayList<String>();
        for (int i = 0; i < parameters.getChildCount(); ++i) {
            ConfigNode sn = parameters.getChild(i);
            if (!sn.getType().equals("access")) continue;
            forcedTokenList.add(sn.getAttributeValue("token"));
        }
        velocityContext.put("FORCEDTOKENS", forcedTokenList);
    }

    protected static void fillInLDAPTab(Map<String, Object> velocityContext, IHTTPOutput out, ConfigParams parameters) {
        velocityContext.put("FSERVERPROTOCOL", LDAPAuthority.getParam(parameters, "ldapProtocol", "ldap"));
        velocityContext.put("FSERVERNAME", LDAPAuthority.getParam(parameters, "ldapServerName", ""));
        velocityContext.put("FSERVERPORT", LDAPAuthority.getParam(parameters, "ldapServerPort", "389"));
        velocityContext.put("FSERVERBASE", LDAPAuthority.getParam(parameters, "ldapServerBase", ""));
        String sslKeystoreData = parameters.getParameter("sslkeystore");
        if (sslKeystoreData != null) {
            velocityContext.put("SSLKEYSTOREDATA", sslKeystoreData);
        }
        velocityContext.put("FUSERBASE", LDAPAuthority.getParam(parameters, "ldapUserBase", "ou=People"));
        velocityContext.put("FUSERSEARCH", LDAPAuthority.getParam(parameters, "ldapUserSearch", "(&(objectClass=inetOrgPerson)(uid={0}))"));
        velocityContext.put("FUSERNAMEATTR", LDAPAuthority.getParam(parameters, "ldapUserNameAttr", "uid"));
        velocityContext.put("FADDUSERRECORD", LDAPAuthority.getParam(parameters, "ldapAddUserRecord", ""));
        velocityContext.put("FGROUPBASE", LDAPAuthority.getParam(parameters, "ldapGroupBase", "ou=Groups"));
        velocityContext.put("FGROUPSEARCH", LDAPAuthority.getParam(parameters, "ldapGroupSearch", "(&(objectClass=groupOfNames)(member={0}))"));
        velocityContext.put("FGROUPNAMEATTR", LDAPAuthority.getParam(parameters, "ldapGroupNameAttr", "cn"));
        velocityContext.put("FGROUPMEMBERDN", LDAPAuthority.getParam(parameters, "ldapGroupMemberDn", ""));
        velocityContext.put("FBINDUSER", LDAPAuthority.getParam(parameters, "ldapBindUser", ""));
        String fBindPass = parameters.getObfuscatedParameter("ldapBindPass");
        fBindPass = fBindPass == null ? "" : out.mapPasswordToKey(fBindPass);
        velocityContext.put("FBINDPASS", fBindPass);
        HashMap<String, String> sslCertificatesMap = null;
        String message = null;
        try {
            IKeystoreManager localSslKeystore = sslKeystoreData == null ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)sslKeystoreData);
            String[] contents = localSslKeystore.getContents();
            if (contents.length > 0) {
                sslCertificatesMap = new HashMap<String, String>();
                for (String alias : contents) {
                    Object description = localSslKeystore.getDescription(alias);
                    if (((String)description).length() > 128) {
                        description = ((String)description).substring(0, 125) + "...";
                    }
                    sslCertificatesMap.put(alias, (String)description);
                }
            }
        }
        catch (ManifoldCFException e) {
            message = e.getMessage();
            Logging.authorityConnectors.warn((Object)e);
        }
        if (sslCertificatesMap != null) {
            velocityContext.put("SSLCERTIFICATESMAP", sslCertificatesMap);
        }
        if (message != null) {
            velocityContext.put("MESSAGE", message);
        }
    }

    protected SearchResult getUserEntry(LdapContext ctx, String userName) throws ManifoldCFException {
        String searchFilter = this.userSearch.replaceAll("\\{0\\}", LdapEscaper.escapeDN((String)userName.split("@")[0]));
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(this.userBase, searchFilter, searchCtls);
            if (answer.hasMoreElements()) {
                return answer.next();
            }
            return null;
        }
        catch (Exception e) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    protected class LdapAuthorizationResponseDescription
    extends BaseDescription {
        protected String userName;
        protected String connectionString;
        protected String userSearch;
        protected String groupSearch;
        protected long responseLifetime;
        protected long expirationTime;

        public LdapAuthorizationResponseDescription(String userName, String connectionString, String userSearch, String groupSearch, long responseLifetime, int LRUsize) {
            super("LDAPAuthority", LRUsize);
            this.expirationTime = -1L;
            this.userName = userName;
            this.connectionString = connectionString;
            this.userSearch = userSearch;
            this.groupSearch = groupSearch;
            this.responseLifetime = responseLifetime;
        }

        public StringSet getObjectKeys() {
            return emptyStringSet;
        }

        public String getCriticalSectionName() {
            StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getName());
            sb.append("-").append(this.userName).append("-").append(this.connectionString);
            return sb.toString();
        }

        public long getObjectExpirationTime(long currentTime) {
            if (this.expirationTime == -1L) {
                this.expirationTime = currentTime + this.responseLifetime;
            }
            return this.expirationTime;
        }

        public int hashCode() {
            return this.userName.hashCode() + this.connectionString.hashCode() + this.userSearch.hashCode() + this.groupSearch.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof LdapAuthorizationResponseDescription)) {
                return false;
            }
            LdapAuthorizationResponseDescription ard = (LdapAuthorizationResponseDescription)((Object)o);
            if (!ard.userName.equals(this.userName)) {
                return false;
            }
            if (!ard.connectionString.equals(this.connectionString)) {
                return false;
            }
            if (!ard.userSearch.equals(this.userSearch)) {
                return false;
            }
            return ard.groupSearch.equals(this.groupSearch);
        }
    }
}

