/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting.rules;

import java.lang.reflect.Field;

final class Constants {
    public static final boolean JRE_IS_64BIT;
    public static final String JAVA_VERSION;
    public static final String JAVA_VENDOR;
    public static final String JVM_VENDOR;
    public static final String JVM_VERSION;
    public static final String JVM_NAME;
    public static final String OS_ARCH;
    public static final String OS_VERSION;

    private Constants() {
    }

    static {
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_VENDOR = System.getProperty("java.vendor");
        JVM_VENDOR = System.getProperty("java.vm.vendor");
        JVM_VERSION = System.getProperty("java.vm.version");
        JVM_NAME = System.getProperty("java.vm.name");
        OS_ARCH = System.getProperty("os.arch");
        OS_VERSION = System.getProperty("os.version");
        String OS_ARCH = System.getProperty("os.arch");
        boolean is64Bit = false;
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Object unsafe = unsafeField.get(null);
            int addressSize = ((Number)unsafeClass.getMethod("addressSize", new Class[0]).invoke(unsafe, new Object[0])).intValue();
            is64Bit = addressSize >= 8;
        }
        catch (Exception e) {
            String x = System.getProperty("sun.arch.data.model");
            is64Bit = x != null ? x.indexOf("64") != -1 : OS_ARCH != null && OS_ARCH.indexOf("64") != -1;
        }
        JRE_IS_64BIT = is64Bit;
    }
}

