/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Comparer;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PersistenceException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

class AnnotationHandler
implements InvocationHandler {
    private static final String CLASS = "annotationType";
    private static final String STRING = "toString";
    private static final String REQUIRED = "required";
    private static final String ATTRIBUTE = "attribute";
    private static final String EQUAL = "equals";
    private final Comparer comparer = new Comparer();
    private final Class type;
    private final boolean attribute;
    private final boolean required;

    public AnnotationHandler(Class clazz) {
        this(clazz, true);
    }

    public AnnotationHandler(Class clazz, boolean bl) {
        this(clazz, bl, false);
    }

    public AnnotationHandler(Class clazz, boolean bl, boolean bl2) {
        this.attribute = bl2;
        this.required = bl;
        this.type = clazz;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        String string = method.getName();
        if (string.equals(STRING)) {
            return this.toString();
        }
        if (string.equals(EQUAL)) {
            return this.equals(object, objectArray);
        }
        if (string.equals(CLASS)) {
            return this.type;
        }
        if (string.equals(REQUIRED)) {
            return this.required;
        }
        if (string.equals(ATTRIBUTE)) {
            return this.attribute;
        }
        return method.getDefaultValue();
    }

    private boolean equals(Object object, Object[] objectArray) {
        Annotation annotation = (Annotation)object;
        Annotation annotation2 = (Annotation)objectArray[0];
        if (annotation.annotationType() != annotation2.annotationType()) {
            throw new PersistenceException("Annotation %s is not the same as %s", annotation, annotation2);
        }
        return this.comparer.equals(annotation, annotation2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.type != null) {
            this.name(stringBuilder);
            this.attributes(stringBuilder);
        }
        return stringBuilder.toString();
    }

    private void name(StringBuilder stringBuilder) {
        String string = this.type.getName();
        if (string != null) {
            stringBuilder.append('@');
            stringBuilder.append(string);
            stringBuilder.append('(');
        }
    }

    private void attributes(StringBuilder stringBuilder) {
        Method[] methodArray = this.type.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string = methodArray[i].getName();
            Object object = this.value(methodArray[i]);
            if (i > 0) {
                stringBuilder.append(',');
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append(object);
        }
        stringBuilder.append(')');
    }

    private Object value(Method method) {
        String string = method.getName();
        if (string.equals(REQUIRED)) {
            return this.required;
        }
        if (string.equals(ATTRIBUTE)) {
            return this.attribute;
        }
        return method.getDefaultValue();
    }
}

