/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jctools;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.kit.recycler.Recycler;
import org.apache.logging.log4j.kit.recycler.RecyclerFactory;
import org.apache.logging.log4j.kit.recycler.RecyclerFactoryProvider;
import org.apache.logging.log4j.kit.recycler.RecyclerProperties;
import org.apache.logging.log4j.kit.recycler.support.AbstractRecycler;
import org.jctools.queues.MpmcArrayQueue;

@ServiceProvider(value=RecyclerFactoryProvider.class)
public final class JCToolsRecyclerFactoryProvider
implements RecyclerFactoryProvider {
    public int getOrder() {
        return 600;
    }

    public String getName() {
        return "jctools-mpmc";
    }

    public RecyclerFactory createForEnvironment(PropertyEnvironment environment) {
        Objects.requireNonNull(environment, "environment");
        int capacity = ((RecyclerProperties)environment.getProperty(RecyclerProperties.class)).capacity();
        return new JCToolsMpmcRecyclerFactory(capacity);
    }

    private static final class JCToolsMpmcRecyclerFactory
    implements RecyclerFactory {
        private final int capacity;

        private JCToolsMpmcRecyclerFactory(int capacity) {
            this.capacity = capacity;
        }

        public <V> Recycler<V> create(Supplier<V> supplier, Consumer<V> cleaner) {
            Objects.requireNonNull(supplier, "supplier");
            Objects.requireNonNull(cleaner, "cleaner");
            MpmcArrayQueue queue = new MpmcArrayQueue(this.capacity);
            return new JCToolsMpmcRecycler<V>(supplier, cleaner, queue);
        }

        private static final class JCToolsMpmcRecycler<V>
        extends AbstractRecycler<V> {
            private final Consumer<V> cleaner;
            private final Queue<V> queue;

            private JCToolsMpmcRecycler(Supplier<V> supplier, Consumer<V> cleaner, Queue<V> queue) {
                super(supplier);
                this.cleaner = cleaner;
                this.queue = queue;
            }

            public V acquire() {
                V value = this.queue.poll();
                return (V)(value != null ? value : this.createInstance());
            }

            public void release(V value) {
                Objects.requireNonNull(value, "value");
                this.cleaner.accept(value);
                this.queue.offer(value);
            }
        }
    }
}

