/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.observers.BasicQueueDisposable;
import java.util.Iterator;

public final class ObservableFromIterable<T>
extends Observable<T> {
    final Iterable<? extends T> source;

    public ObservableFromIterable(Iterable<? extends T> source) {
        this.source = source;
    }

    @Override
    public void subscribeActual(Observer<? super T> s) {
        boolean hasNext;
        Iterator<T> it;
        try {
            it = this.source.iterator();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, s);
            return;
        }
        try {
            hasNext = it.hasNext();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, s);
            return;
        }
        if (!hasNext) {
            EmptyDisposable.complete(s);
            return;
        }
        FromIterableDisposable<T> d = new FromIterableDisposable<T>(s, it);
        s.onSubscribe(d);
        if (!d.fusionMode) {
            d.run();
        }
    }

    static final class FromIterableDisposable<T>
    extends BasicQueueDisposable<T> {
        final Observer<? super T> actual;
        final Iterator<? extends T> it;
        volatile boolean disposed;
        boolean fusionMode;
        boolean done;
        boolean checkNext;

        FromIterableDisposable(Observer<? super T> actual, Iterator<? extends T> it) {
            this.actual = actual;
            this.it = it;
        }

        void run() {
            boolean hasNext;
            do {
                T v;
                if (this.isDisposed()) {
                    return;
                }
                try {
                    v = ObjectHelper.requireNonNull(this.it.next(), "The iterator returned a null value");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.actual.onError(e);
                    return;
                }
                this.actual.onNext(v);
                if (this.isDisposed()) {
                    return;
                }
                try {
                    hasNext = this.it.hasNext();
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.actual.onError(e);
                    return;
                }
            } while (hasNext);
            if (!this.isDisposed()) {
                this.actual.onComplete();
            }
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 1) != 0) {
                this.fusionMode = true;
                return 1;
            }
            return 0;
        }

        @Override
        public T poll() {
            if (this.done) {
                return null;
            }
            if (this.checkNext) {
                if (!this.it.hasNext()) {
                    this.done = true;
                    return null;
                }
            } else {
                this.checkNext = true;
            }
            return ObjectHelper.requireNonNull(this.it.next(), "The iterator returned a null value");
        }

        @Override
        public boolean isEmpty() {
            return this.done;
        }

        @Override
        public void clear() {
            this.done = true;
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

