/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.deploy.yarn;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.deploy.yarn.ApplicationMasterArguments;
import org.apache.kyuubi.service.AbstractFrontendService;
import org.apache.kyuubi.service.Serverable;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.apache.kyuubi.util.command.CommandLineUtils$;
import org.apache.kyuubi.util.reflect.DynFields;
import org.apache.kyuubi.util.reflect.DynMethods;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ApplicationMaster$
implements Logging {
    public static ApplicationMaster$ MODULE$;
    private AMRMClient<AMRMClient.ContainerRequest> amClient;
    private YarnConfiguration yarnConf;
    private final KyuubiConf kyuubiConf;
    private String currentEngineMainClass;
    private Serverable currentEngine;
    private String finalMsg;
    private volatile boolean registered;
    private volatile boolean unregistered;
    private volatile FinalApplicationStatus finalStatus;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new ApplicationMaster$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private AMRMClient<AMRMClient.ContainerRequest> amClient() {
        return this.amClient;
    }

    private void amClient_$eq(AMRMClient<AMRMClient.ContainerRequest> x$1) {
        this.amClient = x$1;
    }

    private YarnConfiguration yarnConf() {
        return this.yarnConf;
    }

    private void yarnConf_$eq(YarnConfiguration x$1) {
        this.yarnConf = x$1;
    }

    private KyuubiConf kyuubiConf() {
        return this.kyuubiConf;
    }

    private String currentEngineMainClass() {
        return this.currentEngineMainClass;
    }

    private void currentEngineMainClass_$eq(String x$1) {
        this.currentEngineMainClass = x$1;
    }

    private Serverable currentEngine() {
        return this.currentEngine;
    }

    private void currentEngine_$eq(Serverable x$1) {
        this.currentEngine = x$1;
    }

    private String finalMsg() {
        return this.finalMsg;
    }

    private void finalMsg_$eq(String x$1) {
        this.finalMsg = x$1;
    }

    private boolean registered() {
        return this.registered;
    }

    private void registered_$eq(boolean x$1) {
        this.registered = x$1;
    }

    private boolean unregistered() {
        return this.unregistered;
    }

    private void unregistered_$eq(boolean x$1) {
        this.unregistered = x$1;
    }

    private FinalApplicationStatus finalStatus() {
        return this.finalStatus;
    }

    private void finalStatus_$eq(FinalApplicationStatus x$1) {
        this.finalStatus = x$1;
    }

    public void main(String[] args) {
        block2: {
            try {
                ApplicationMasterArguments amArgs = new ApplicationMasterArguments(args);
                Utils$.MODULE$.getPropertiesFromFile((Option<File>)new Some((Object)new File(amArgs.propertiesFile()))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        return MODULE$.kyuubiConf().set(k, v);
                    }
                    throw new MatchError((Object)tuple2);
                });
                this.currentEngineMainClass_$eq(amArgs.engineMainClass());
                this.yarnConf_$eq(KyuubiHadoopUtils$.MODULE$.newYarnConfiguration(this.kyuubiConf()));
                Utils$.MODULE$.addShutdownHook(() -> {
                    if (!MODULE$.unregistered()) {
                        if (MODULE$.currentEngine() != null && MODULE$.currentEngine().selfExited()) {
                            MODULE$.finalMsg_$eq("Kyuubi Application Master is shutting down.");
                            MODULE$.finalStatus_$eq(FinalApplicationStatus.SUCCEEDED);
                        } else {
                            MODULE$.finalMsg_$eq("Kyuubi Application Master is shutting down with error.");
                            MODULE$.finalStatus_$eq(FinalApplicationStatus.FAILED);
                        }
                        MODULE$.cleanupStagingDir();
                        MODULE$.unregister(MODULE$.finalStatus(), MODULE$.finalMsg());
                        return;
                    }
                }, Utils$.MODULE$.addShutdownHook$default$2());
                this.runApplicationMaster();
            }
            catch (Throwable t) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error running ApplicationMaster", t);
                this.finalStatus_$eq(FinalApplicationStatus.FAILED);
                this.finalMsg_$eq(t.getMessage());
                this.cleanupStagingDir();
                this.unregister(this.finalStatus(), this.finalMsg());
                if (this.currentEngine() == null) break block2;
                this.currentEngine().stop();
            }
        }
    }

    public void runApplicationMaster() {
        this.initAmClient();
        this.runEngine();
        this.registerAM();
    }

    public void runEngine() {
        ArrayBuffer buffer = new ArrayBuffer();
        buffer.$plus$plus$eq(CommandLineUtils$.MODULE$.confKeyValues((Iterable<Tuple2<String, String>>)this.kyuubiConf().getAll()));
        Object instance = DynFields.builder().impl(this.currentEngineMainClass(), "MODULE$").build().get(null);
        DynMethods.builder("main").hiddenImpl(this.currentEngineMainClass(), String[].class).buildChecked().invoke(instance, buffer.toArray(ClassTag$.MODULE$.apply(String.class)));
        this.currentEngine_$eq((Serverable)((Option)DynFields.builder().hiddenImpl(this.currentEngineMainClass(), "currentEngine").buildChecked().get(instance)).get());
    }

    public void initAmClient() {
        this.amClient_$eq((AMRMClient<AMRMClient.ContainerRequest>)AMRMClient.createAMRMClient());
        this.amClient().init((Configuration)this.yarnConf());
        this.amClient().start();
    }

    public void registerAM() {
        AbstractFrontendService frontendService = (AbstractFrontendService)this.currentEngine().frontendServices().head();
        String trackingUrl = frontendService.connectionUrl();
        Tuple2<String, Object> tuple2 = this.resolveHostAndPort(trackingUrl);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String host = (String)tuple2._1();
        int port = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
        String host2 = (String)tuple22._1();
        int port2 = tuple22._2$mcI$sp();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(84).append("Registering the HiveSQLEngine ApplicationMaster with tracking url ").append(trackingUrl).append(", host = ").append(host2).append(", port = ").append(port2).toString());
        ApplicationMaster$ applicationMaster$ = this;
        synchronized (applicationMaster$) {
            this.amClient().registerApplicationMaster(host2, port2, trackingUrl);
            this.registered_$eq(true);
        }
    }

    public synchronized void unregister(FinalApplicationStatus status, String diagnostics) {
        if (this.registered() && !this.unregistered()) {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Unregistering ApplicationMaster with ").append(status).append(Option$.MODULE$.apply((Object)diagnostics).map((Function1 & Serializable & scala.Serializable)msg -> new StringBuilder(24).append(" (diagnostics message: ").append((String)msg).append(")").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
            this.unregistered_$eq(true);
            this.amClient().unregisterApplicationMaster(status, diagnostics, "");
            if (this.amClient() != null) {
                this.amClient().stop();
                return;
            }
            return;
        }
    }

    private Tuple2<String, Object> resolveHostAndPort(String connectionUrl) {
        String[] strings = connectionUrl.split(":");
        return new Tuple2((Object)strings[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(strings[1])).toInt()));
    }

    private void cleanupStagingDir() {
        Path stagingDirPath = new Path(System.getenv("KYUUBI_ENGINE_YARN_MODE_STAGING_DIR"));
        try {
            FileSystem fs = stagingDirPath.getFileSystem((Configuration)this.yarnConf());
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Deleting staging directory ").append(stagingDirPath).toString());
            fs.delete(stagingDirPath, true);
        }
        catch (IOException ioe) {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Failed to cleanup staging dir ").append(stagingDirPath).toString(), ioe);
        }
    }

    private ApplicationMaster$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.kyuubiConf = new KyuubiConf(KyuubiConf$.MODULE$.$lessinit$greater$default$1());
        this.registered = false;
        this.unregistered = false;
        this.finalStatus = FinalApplicationStatus.UNDEFINED;
    }
}

