/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.metrics.Measured;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.streams.ReadStream;

@VertxGen
public interface NetServer
extends Measured {
    @Deprecated
    public ReadStream<NetSocket> connectStream();

    public NetServer connectHandler(@Nullable Handler<NetSocket> var1);

    @GenIgnore
    public Handler<NetSocket> connectHandler();

    public Future<NetServer> listen();

    @Fluent
    default public NetServer listen(Handler<AsyncResult<NetServer>> listenHandler) {
        Future<NetServer> fut = this.listen();
        if (listenHandler != null) {
            fut.onComplete(listenHandler);
        }
        return this;
    }

    default public Future<NetServer> listen(int port, String host) {
        return this.listen(new SocketAddressImpl(port, host));
    }

    @Fluent
    default public NetServer listen(int port, String host, Handler<AsyncResult<NetServer>> listenHandler) {
        Future<NetServer> fut = this.listen(port, host);
        if (listenHandler != null) {
            fut.onComplete(listenHandler);
        }
        return this;
    }

    default public Future<NetServer> listen(int port) {
        return this.listen(port, "0.0.0.0");
    }

    @Fluent
    default public NetServer listen(int port, Handler<AsyncResult<NetServer>> listenHandler) {
        return this.listen(port, "0.0.0.0", listenHandler);
    }

    public Future<NetServer> listen(SocketAddress var1);

    @Fluent
    default public NetServer listen(SocketAddress localAddress, Handler<AsyncResult<NetServer>> listenHandler) {
        Future<NetServer> fut = this.listen(localAddress);
        if (listenHandler != null) {
            fut.onComplete(listenHandler);
        }
        return this;
    }

    @GenIgnore
    @Fluent
    public NetServer exceptionHandler(Handler<Throwable> var1);

    public Future<Void> close();

    public void close(Handler<AsyncResult<Void>> var1);

    public int actualPort();

    default public Future<Boolean> updateSSLOptions(SSLOptions options) {
        return this.updateSSLOptions(options, false);
    }

    default public void updateSSLOptions(SSLOptions options, Handler<AsyncResult<Boolean>> handler) {
        Future<Boolean> fut = this.updateSSLOptions(options);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    public Future<Boolean> updateSSLOptions(SSLOptions var1, boolean var2);

    default public void updateSSLOptions(SSLOptions options, boolean force, Handler<AsyncResult<Boolean>> handler) {
        Future<Boolean> fut = this.updateSSLOptions(options, force);
        if (handler != null) {
            fut.onComplete(handler);
        }
    }
}

