/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.http.impl;

import java.util.Map;
import org.apache.kyuubi.shade.io.netty.buffer.ByteBuf;
import org.apache.kyuubi.shade.io.netty.buffer.Unpooled;
import org.apache.kyuubi.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.kyuubi.shade.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.kyuubi.shade.io.netty.channel.ChannelPipeline;
import org.apache.kyuubi.shade.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.kyuubi.shade.io.netty.handler.codec.http.HttpContent;
import org.apache.kyuubi.shade.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.kyuubi.shade.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.kyuubi.shade.io.netty.handler.codec.http.HttpRequest;
import org.apache.kyuubi.shade.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.kyuubi.shade.io.netty.handler.codec.http.HttpVersion;
import org.apache.kyuubi.shade.io.netty.handler.codec.http.LastHttpContent;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.DefaultHttp2Headers;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2CodecUtil;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2ConnectionHandler;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2Headers;
import org.apache.kyuubi.shade.io.netty.handler.codec.http2.Http2Settings;
import org.apache.kyuubi.shade.io.netty.handler.timeout.IdleState;
import org.apache.kyuubi.shade.io.netty.handler.timeout.IdleStateEvent;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpHeaders;
import org.apache.kyuubi.shade.io.vertx.core.http.impl.Http2ServerConnection;
import org.apache.kyuubi.shade.io.vertx.core.http.impl.HttpServerImpl;
import org.apache.kyuubi.shade.io.vertx.core.http.impl.HttpServerWorker;
import org.apache.kyuubi.shade.io.vertx.core.http.impl.HttpUtils;
import org.apache.kyuubi.shade.io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.VertxHandler;

public class Http1xUpgradeToH2CHandler
extends ChannelInboundHandlerAdapter {
    private final HttpServerWorker initializer;
    private VertxHttp2ConnectionHandler<Http2ServerConnection> handler;
    private final boolean isCompressionSupported;
    private final boolean isDecompressionSupported;

    Http1xUpgradeToH2CHandler(HttpServerWorker initializer, boolean isCompressionSupported, boolean isDecompressionSupported) {
        this.initializer = initializer;
        this.isCompressionSupported = isCompressionSupported;
        this.isDecompressionSupported = isDecompressionSupported;
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            if (request.headers().contains(HttpHeaders.UPGRADE, Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, true)) {
                Http2Settings settings;
                String settingsHeader;
                String connection = request.headers().get(HttpHeaders.CONNECTION);
                int found = 0;
                if (connection != null && connection.length() > 0) {
                    StringBuilder buff = new StringBuilder();
                    int pos = 0;
                    int len = connection.length();
                    while (pos < len) {
                        char c;
                        if ((c = connection.charAt(pos++)) != ' ' && c != ',') {
                            buff.append(Character.toLowerCase(c));
                        }
                        if (c != ',' && pos != len) continue;
                        if (buff.indexOf("upgrade") == 0 && buff.length() == 7) {
                            found |= 1;
                        } else if (buff.indexOf("http2-settings") == 0 && buff.length() == 14) {
                            found |= 2;
                        }
                        buff.setLength(0);
                    }
                }
                if (found == 3 && (settingsHeader = request.headers().get(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER)) != null && (settings = HttpUtils.decodeSettings(settingsHeader)) != null) {
                    if (this.initializer.context.isEventLoopContext()) {
                        ChannelPipeline pipeline = ctx.pipeline();
                        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, Unpooled.EMPTY_BUFFER, false);
                        res.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
                        res.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME);
                        ctx.writeAndFlush(res);
                        pipeline.remove("httpEncoder");
                        if (this.isCompressionSupported) {
                            pipeline.remove("deflater");
                            pipeline.remove("chunkedWriter");
                        }
                        if (this.isDecompressionSupported) {
                            pipeline.remove("inflater");
                        }
                        this.handler = this.initializer.buildHttp2ConnectionHandler(this.initializer.context, this.initializer.connectionHandler);
                        pipeline.addLast("handler", this.handler);
                        this.handler.serverUpgrade(ctx, settings, request);
                        DefaultHttp2Headers headers = new DefaultHttp2Headers();
                        headers.method(request.method().name());
                        headers.path(request.uri());
                        headers.authority(request.headers().get("host"));
                        headers.scheme("http");
                        request.headers().remove("http2-settings");
                        request.headers().remove("host");
                        request.headers().forEach(header -> {
                            Http2Headers cfr_ignored_0 = (Http2Headers)headers.set(((String)header.getKey()).toLowerCase(), header.getValue());
                        });
                        ctx.fireChannelRead(new DefaultHttp2HeadersFrame(headers, false));
                    } else {
                        HttpServerImpl.log.warn("Cannot perform HTTP/2 upgrade in a worker verticle");
                    }
                }
                if (this.handler == null) {
                    DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.EMPTY_BUFFER, false);
                    res.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                    ctx.writeAndFlush(res);
                }
            } else {
                this.initializer.configureHttp1(ctx.pipeline());
                ctx.fireChannelRead(msg);
                ctx.pipeline().remove(this);
            }
        } else if (this.handler != null) {
            if (msg instanceof HttpContent) {
                HttpContent content = (HttpContent)msg;
                ByteBuf buf = VertxHandler.safeBuffer(content.content());
                boolean end = msg instanceof LastHttpContent;
                ctx.fireChannelRead(new DefaultHttp2DataFrame(buf, end, 0));
                if (end) {
                    ChannelPipeline pipeline = ctx.pipeline();
                    for (Map.Entry handler : pipeline) {
                        if (handler.getValue() instanceof Http2ConnectionHandler) continue;
                        pipeline.remove((String)handler.getKey());
                    }
                    this.initializer.configureHttp2(pipeline);
                }
            } else {
                super.channelRead(ctx, msg);
            }
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
            ctx.close();
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }
}

