/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.DatabaseConnection;
import org.apache.hive.beeline.KyuubiBeeLine;
import org.apache.kyuubi.jdbc.hive.KyuubiConnection;
import org.apache.kyuubi.jdbc.hive.logs.InPlaceUpdateStream;

public class KyuubiDatabaseConnection
extends DatabaseConnection {
    private static final String HIVE_VAR_PREFIX = "hivevar:";
    private static final String HIVE_CONF_PREFIX = "hiveconf:";
    private KyuubiBeeLine beeLine;
    private String driver;
    private String url;
    private Properties info;

    KyuubiDatabaseConnection(KyuubiBeeLine beeLine, String driver, String url, Properties info) throws SQLException {
        super((BeeLine)beeLine, driver, url, info);
        this.beeLine = beeLine;
        this.driver = driver;
        this.url = url;
        this.info = info;
    }

    boolean connect() throws SQLException {
        Map hiveConfVars;
        try {
            if (this.driver != null && this.driver.length() != 0) {
                Class.forName(this.driver);
            }
        }
        catch (ClassNotFoundException cnfe) {
            return this.beeLine.error(cnfe);
        }
        boolean isDriverRegistered = false;
        try {
            isDriverRegistered = DriverManager.getDriver(this.getUrl()) != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.close();
        }
        catch (Exception e) {
            return this.beeLine.error(e);
        }
        Map hiveVars = this.beeLine.getOpts().getHiveVariables();
        if (hiveVars != null) {
            for (Map.Entry entry : hiveVars.entrySet()) {
                this.info.put(HIVE_VAR_PREFIX + (String)entry.getKey(), entry.getValue());
            }
        }
        if ((hiveConfVars = this.beeLine.getOpts().getHiveConfVariables()) != null) {
            for (Map.Entry entry : hiveConfVars.entrySet()) {
                this.info.put(HIVE_CONF_PREFIX + (String)entry.getKey(), entry.getValue());
            }
        }
        if (isDriverRegistered) {
            boolean bl;
            boolean bl2 = bl = this.beeLine.getDefaultDriver() != null && this.beeLine.getDefaultDriver().acceptsURL(this.url);
            if (this.driver != null && !this.driver.equals("org.apache.kyuubi.jdbc.KyuubiHiveDriver")) {
                this.beeLine.debug("Use default kyuubi driver and specified driver is:" + this.driver);
            }
            if (bl) {
                this.beeLine.debug("Use the default driver:org.apache.kyuubi.jdbc.KyuubiHiveDriver");
                this.setConnection(this.getConnectionFromDefaultDriver(this.getUrl(), this.info));
            } else {
                this.beeLine.debug("Not use the default kyuubi driver and specified driver is:" + this.driver);
                this.setConnection(DriverManager.getConnection(this.getUrl(), this.info));
            }
        } else {
            this.beeLine.debug("Use the driver from local added jar file.");
            this.setConnection(this.getConnectionFromLocalDriver(this.getUrl(), this.info));
        }
        this.setDatabaseMetaData(this.getConnection().getMetaData());
        try {
            this.beeLine.info(this.beeLine.loc("connected", new Object[]{this.getDatabaseMetaData().getDatabaseProductName(), this.getDatabaseMetaData().getDatabaseProductVersion()}));
        }
        catch (Exception exception) {
            this.beeLine.handleException(exception);
        }
        try {
            this.beeLine.info(this.beeLine.loc("driver", new Object[]{this.getDatabaseMetaData().getDriverName(), this.getDatabaseMetaData().getDriverVersion()}));
        }
        catch (Exception exception) {
            this.beeLine.handleException(exception);
        }
        return true;
    }

    public Connection getConnectionFromDefaultDriver(String url, Properties properties) throws SQLException {
        properties.setProperty("BEELINE_MODE", Boolean.toString(true));
        KyuubiConnection kyuubiConnection = (KyuubiConnection)this.beeLine.getDefaultDriver().connect(url, properties);
        InPlaceUpdateStream.EventNotifier eventNotifier = new InPlaceUpdateStream.EventNotifier();
        eventNotifier.progressBarCompleted();
        Thread logThread = new Thread(this.beeLine.commands.createLogRunnable(kyuubiConnection, eventNotifier));
        logThread.setDaemon(true);
        logThread.start();
        kyuubiConnection.setEngineLogThread(logThread);
        kyuubiConnection.waitLaunchEngineToComplete();
        logThread.interrupt();
        kyuubiConnection.executeInitSql();
        return kyuubiConnection;
    }
}

