/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.DataInput;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.zip.CRC32;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.TypedFormat;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.SpaceInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.iapi.util.InterruptDetectedException;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.store.raw.data.AllocPage;
import org.apache.derby.impl.store.raw.data.AllocationCache;
import org.apache.derby.impl.store.raw.data.BaseContainer;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.CachedPage;
import org.apache.derby.impl.store.raw.data.PageCreationArgs;
import org.apache.derby.impl.store.raw.data.SpaceInformation;
import org.apache.derby.impl.store.raw.data.StoredPage;
import org.apache.derby.impl.store.raw.data.TempRAFContainer;
import org.apache.derby.io.StorageRandomAccessFile;

abstract class FileContainer
extends BaseContainer
implements Cacheable,
TypedFormat {
    protected static final int formatIdInteger = 116;
    protected final CacheManager pageCache;
    protected final CacheManager containerCache;
    protected final BaseDataFileFactory dataFactory;
    protected int pageSize;
    protected int spareSpace;
    protected int minimumRecordSize;
    protected short initialPages;
    protected boolean canUpdate;
    private int PreAllocThreshold;
    private int PreAllocSize;
    private boolean bulkIncreaseContainerSize;
    private static final int PRE_ALLOC_THRESHOLD = 8;
    private static final int MIN_PRE_ALLOC_SIZE = 1;
    private static final int DEFAULT_PRE_ALLOC_SIZE = 8;
    private static final int MAX_PRE_ALLOC_SIZE = 1000;
    protected long firstAllocPageNumber;
    protected long firstAllocPageOffset;
    protected long containerVersion;
    protected long estimatedRowCount;
    protected LogInstant lastLogInstant;
    private long reusableRecordIdSequenceNumber;
    private long[] lastInsertedPage;
    private int lastInsertedPage_index;
    private long lastUnfilledPage;
    private long lastAllocatedPage;
    private long estimatedPageCount;
    protected boolean preDirty;
    protected boolean isDirty;
    protected AllocationCache allocCache;
    byte[] containerInfo;
    private CRC32 checksum;
    private byte[] encryptionBuffer;
    private static final int CONTAINER_FORMAT_ID_SIZE = 4;
    protected static final int CHECKSUM_SIZE = 8;
    protected static final int CONTAINER_INFO_SIZE = 80;
    public static final long FIRST_ALLOC_PAGE_NUMBER = 0L;
    public static final long FIRST_ALLOC_PAGE_OFFSET = 0L;
    private static final int FILE_DROPPED = 1;
    private static final int FILE_COMMITTED_DROP = 2;
    private static final int FILE_REUSABLE_RECORDID = 8;
    protected static final String SPACE_TRACE = null;

    @Override
    public int getTypeFormatId() {
        return 116;
    }

    FileContainer(BaseDataFileFactory baseDataFileFactory) {
        this.dataFactory = baseDataFileFactory;
        this.pageCache = baseDataFileFactory.getPageCache();
        this.containerCache = baseDataFileFactory.getContainerCache();
        this.initContainerHeader(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpaceInfo getSpaceInfo(BaseContainerHandle baseContainerHandle) throws StandardException {
        SpaceInformation spaceInformation;
        AllocationCache allocationCache = this.allocCache;
        synchronized (allocationCache) {
            spaceInformation = this.allocCache.getAllPageCounts(baseContainerHandle, this.firstAllocPageNumber);
        }
        spaceInformation.setPageSize(this.pageSize);
        return spaceInformation;
    }

    @Override
    public Cacheable setIdentity(Object object) throws StandardException {
        ContainerKey containerKey = (ContainerKey)object;
        if (containerKey.getSegmentId() == -1L) {
            return new TempRAFContainer(this.dataFactory).setIdent(containerKey);
        }
        return this.setIdent(containerKey);
    }

    protected Cacheable setIdent(ContainerKey containerKey) throws StandardException {
        boolean bl = this.openContainer(containerKey);
        this.initializeLastInsertedPage(1);
        this.lastUnfilledPage = -1L;
        this.lastAllocatedPage = -1L;
        this.estimatedPageCount = -1L;
        if (bl) {
            this.fillInIdentity(containerKey);
            return this;
        }
        return null;
    }

    @Override
    public Cacheable createIdentity(Object object, Object object2) throws StandardException {
        ContainerKey containerKey = (ContainerKey)object;
        if (containerKey.getSegmentId() == -1L) {
            TempRAFContainer tempRAFContainer = new TempRAFContainer(this.dataFactory);
            return tempRAFContainer.createIdent(containerKey, object2);
        }
        return this.createIdent(containerKey, object2);
    }

    protected Cacheable createIdent(ContainerKey containerKey, Object object) throws StandardException {
        if (object != this) {
            this.initContainerHeader(true);
            if (object != null && object instanceof ByteArray) {
                this.createInfoFromLog((ByteArray)object);
            } else {
                this.createInfoFromProp((Properties)object);
            }
        } else {
            this.initContainerHeader(false);
        }
        if (this.initialPages > 1) {
            this.PreAllocThreshold = 0;
            this.PreAllocSize = this.initialPages;
            this.bulkIncreaseContainerSize = true;
        } else {
            this.PreAllocThreshold = 8;
        }
        this.createContainer(containerKey);
        this.setDirty(true);
        this.fillInIdentity(containerKey);
        return this;
    }

    @Override
    public void clearIdentity() {
        this.closeContainer();
        this.initializeLastInsertedPage(1);
        this.lastUnfilledPage = -1L;
        this.lastAllocatedPage = -1L;
        this.canUpdate = false;
        super.clearIdentity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirty() {
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            return this.isDirty;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preDirty(boolean bl) {
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            if (bl) {
                this.preDirty = true;
            } else {
                this.preDirty = false;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDirty(boolean bl) {
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            this.preDirty = false;
            this.isDirty = bl;
            this.notifyAll();
        }
    }

    abstract void createContainer(ContainerKey var1) throws StandardException;

    abstract boolean openContainer(ContainerKey var1) throws StandardException;

    abstract void closeContainer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dropContainer(LogInstant logInstant, boolean bl) {
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            this.setDroppedState(bl);
            this.setDirty(true);
            this.bumpContainerVersion(logInstant);
        }
    }

    protected final void bumpContainerVersion(LogInstant logInstant) {
        this.lastLogInstant = logInstant;
        ++this.containerVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getContainerVersion() {
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            return this.containerVersion;
        }
    }

    @Override
    public void getContainerProperties(Properties properties) throws StandardException {
        if (properties.getProperty("derby.storage.pageSize") != null) {
            properties.put("derby.storage.pageSize", Integer.toString(this.pageSize));
        }
        if (properties.getProperty("derby.storage.minimumRecordSize") != null) {
            properties.put("derby.storage.minimumRecordSize", Integer.toString(this.minimumRecordSize));
        }
        if (properties.getProperty("derby.storage.pageReservedSpace") != null) {
            properties.put("derby.storage.pageReservedSpace", Integer.toString(this.spareSpace));
        }
        if (properties.getProperty("derby.storage.reusableRecordId") != null) {
            Boolean bl = this.isReusableRecordId();
            properties.put("derby.storage.reusableRecordId", bl.toString());
        }
        if (properties.getProperty("derby.storage.initialPages") != null) {
            properties.put("derby.storage.initialPages", Integer.toString(this.initialPages));
        }
    }

    protected void readHeader(byte[] byArray) throws IOException, StandardException {
        AllocPage.ReadContainerInfo(this.containerInfo, byArray);
        this.readHeaderFromArray(this.containerInfo);
    }

    private void initContainerHeader(boolean bl) {
        if (this.containerInfo == null) {
            this.containerInfo = new byte[80];
        }
        if (this.checksum == null) {
            this.checksum = new CRC32();
        } else {
            this.checksum.reset();
        }
        if (this.allocCache == null) {
            this.allocCache = new AllocationCache();
        } else {
            this.allocCache.reset();
        }
        if (bl) {
            this.pageSize = 0;
            this.spareSpace = 0;
            this.minimumRecordSize = 0;
        }
        this.initialPages = 1;
        this.firstAllocPageNumber = -1L;
        this.firstAllocPageOffset = -1L;
        this.containerVersion = 0L;
        this.estimatedRowCount = 0L;
        this.reusableRecordIdSequenceNumber = 0L;
        this.setDroppedState(false);
        this.setCommittedDropState(false);
        this.setReusableRecordIdState(false);
        this.lastLogInstant = null;
        this.initializeLastInsertedPage(1);
        this.lastUnfilledPage = -1L;
        this.lastAllocatedPage = -1L;
        this.estimatedPageCount = -1L;
        this.PreAllocThreshold = 8;
        this.PreAllocSize = 8;
        this.bulkIncreaseContainerSize = false;
    }

    private void readHeaderFromArray(byte[] byArray) throws StandardException, IOException {
        ArrayInputStream arrayInputStream = new ArrayInputStream(byArray);
        arrayInputStream.setLimit(80);
        int n = arrayInputStream.readInt();
        if (n != 116) {
            throw StandardException.newException("XSDB2.D", this.getIdentity(), n);
        }
        int n2 = arrayInputStream.readInt();
        this.pageSize = arrayInputStream.readInt();
        this.spareSpace = arrayInputStream.readInt();
        this.minimumRecordSize = arrayInputStream.readInt();
        this.initialPages = arrayInputStream.readShort();
        this.PreAllocSize = arrayInputStream.readShort();
        this.firstAllocPageNumber = arrayInputStream.readLong();
        this.firstAllocPageOffset = arrayInputStream.readLong();
        this.containerVersion = arrayInputStream.readLong();
        this.estimatedRowCount = arrayInputStream.readLong();
        this.reusableRecordIdSequenceNumber = arrayInputStream.readLong();
        this.lastLogInstant = null;
        if (this.PreAllocSize == 0) {
            this.PreAllocSize = 8;
        }
        long l = arrayInputStream.readLong();
        if (this.initialPages == 0) {
            this.initialPages = 1;
        }
        this.PreAllocThreshold = 8;
        long l2 = arrayInputStream.readLong();
        this.checksum.reset();
        this.checksum.update(byArray, 0, 72);
        if (l2 != this.checksum.getValue()) {
            PageKey pageKey = new PageKey(this.identity, 0L);
            throw this.dataFactory.markCorrupt(StandardException.newException("XSDG2.D", pageKey, this.checksum.getValue(), l2, StringUtil.hexDump(byArray)));
        }
        this.allocCache.reset();
        this.setDroppedState((n2 & 1) != 0);
        this.setCommittedDropState((n2 & 2) != 0);
        this.setReusableRecordIdState((n2 & 8) != 0);
    }

    protected void writeHeader(Object object, byte[] byArray) throws StandardException, IOException {
        this.writeHeaderToArray(this.containerInfo);
        try {
            AllocPage.WriteContainerInfo(this.containerInfo, byArray, false);
        }
        catch (StandardException standardException) {
            throw StandardException.newException("XSDBC.D", standardException, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeHeader(Object object, StorageRandomAccessFile storageRandomAccessFile, boolean bl, byte[] byArray) throws IOException, StandardException {
        this.writeHeaderToArray(this.containerInfo);
        try {
            AllocPage.WriteContainerInfo(this.containerInfo, byArray, bl);
        }
        catch (StandardException standardException) {
            throw StandardException.newException("XSDBC.D", standardException, object);
        }
        this.dataFactory.flush(this.lastLogInstant);
        if (this.lastLogInstant != null) {
            this.lastLogInstant = null;
        }
        this.dataFactory.writeInProgress();
        try {
            this.writeAtOffset(storageRandomAccessFile, byArray, 0L);
        }
        finally {
            this.dataFactory.writeFinished();
        }
    }

    void writeAtOffset(StorageRandomAccessFile storageRandomAccessFile, byte[] byArray, long l) throws IOException, StandardException {
        storageRandomAccessFile.seek(l);
        storageRandomAccessFile.write(byArray);
    }

    protected byte[] getEmbryonicPage(DataInput dataInput) throws IOException, StandardException {
        byte[] byArray = new byte[204];
        dataInput.readFully(byArray);
        return byArray;
    }

    byte[] getEmbryonicPage(StorageRandomAccessFile storageRandomAccessFile, long l) throws IOException, StandardException {
        storageRandomAccessFile.seek(l);
        return this.getEmbryonicPage(storageRandomAccessFile);
    }

    private void writeHeaderToArray(byte[] byArray) throws IOException {
        ArrayOutputStream arrayOutputStream = new ArrayOutputStream(byArray);
        FormatIdOutputStream formatIdOutputStream = new FormatIdOutputStream(arrayOutputStream);
        int n = 0;
        if (this.getDroppedState()) {
            n |= 1;
        }
        if (this.getCommittedDropState()) {
            n |= 2;
        }
        if (this.isReusableRecordId()) {
            n |= 8;
        }
        arrayOutputStream.setPosition(0);
        arrayOutputStream.setLimit(80);
        formatIdOutputStream.writeInt(116);
        formatIdOutputStream.writeInt(n);
        formatIdOutputStream.writeInt(this.pageSize);
        formatIdOutputStream.writeInt(this.spareSpace);
        formatIdOutputStream.writeInt(this.minimumRecordSize);
        formatIdOutputStream.writeShort(this.initialPages);
        formatIdOutputStream.writeShort(this.PreAllocSize);
        formatIdOutputStream.writeLong(this.firstAllocPageNumber);
        formatIdOutputStream.writeLong(this.firstAllocPageOffset);
        formatIdOutputStream.writeLong(this.containerVersion);
        formatIdOutputStream.writeLong(this.estimatedRowCount);
        formatIdOutputStream.writeLong(this.reusableRecordIdSequenceNumber);
        formatIdOutputStream.writeLong(0L);
        this.checksum.reset();
        this.checksum.update(byArray, 0, 72);
        formatIdOutputStream.writeLong(this.checksum.getValue());
        arrayOutputStream.clearLimit();
    }

    @Override
    protected ByteArray logCreateContainerInfo() throws StandardException {
        byte[] byArray = new byte[80];
        try {
            this.writeHeaderToArray(byArray);
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
        return new ByteArray(byArray);
    }

    private void createInfoFromLog(ByteArray byteArray) throws StandardException {
        byte[] byArray = byteArray.getArray();
        ArrayInputStream arrayInputStream = new ArrayInputStream(byArray);
        int n = 0;
        try {
            arrayInputStream.setLimit(80);
            int n2 = arrayInputStream.readInt();
            if (n2 != 116) {
                throw StandardException.newException("XSDB2.D", this.getIdentity(), n2);
            }
            n = arrayInputStream.readInt();
            this.pageSize = arrayInputStream.readInt();
            this.spareSpace = arrayInputStream.readInt();
            this.minimumRecordSize = arrayInputStream.readInt();
            this.initialPages = arrayInputStream.readShort();
        }
        catch (IOException iOException) {
            throw StandardException.newException("XSDA4.S", iOException, new Object[0]);
        }
        this.setReusableRecordIdState((n & 8) != 0);
    }

    private void createInfoFromProp(Properties properties) throws StandardException {
        AccessFactory accessFactory = (AccessFactory)FileContainer.getServiceModule(this.dataFactory, "org.apache.derby.iapi.store.access.AccessFactory");
        TransactionController transactionController = accessFactory == null ? null : accessFactory.getTransaction(FileContainer.getContextService().getCurrentContextManager());
        this.pageSize = PropertyUtil.getServiceInt(transactionController, properties, "derby.storage.pageSize", 4096, 32768, 4096);
        if (this.pageSize != 4096 && this.pageSize != 8192 && this.pageSize != 16384 && this.pageSize != 32768) {
            this.pageSize = 4096;
        }
        this.spareSpace = PropertyUtil.getServiceInt(transactionController, properties, "derby.storage.pageReservedSpace", 0, 100, 20);
        this.PreAllocSize = PropertyUtil.getServiceInt(transactionController, properties, "derby.storage.pagePerAllocate", 1, 1000, 8);
        this.minimumRecordSize = properties == null ? PropertyUtil.getServiceInt(transactionController, "derby.storage.minimumRecordSize", 12, this.pageSize * (1 - this.spareSpace / 100) - 100, 12) : PropertyUtil.getServiceInt(transactionController, properties, "derby.storage.minimumRecordSize", 1, this.pageSize * (1 - this.spareSpace / 100) - 100, 12);
        if (properties != null) {
            Object object;
            String string = properties.getProperty("derby.storage.reusableRecordId");
            if (string != null) {
                object = Boolean.parseBoolean(string);
                this.setReusableRecordIdState((Boolean)object);
            }
            if ((object = properties.getProperty("derby.storage.initialPages")) != null) {
                this.initialPages = Short.parseShort((String)object);
                if (this.initialPages > 1 && this.initialPages > 1000) {
                    this.initialPages = (short)1000;
                }
            }
        }
    }

    @Override
    protected boolean canUpdate() {
        return this.canUpdate;
    }

    @Override
    protected void deallocatePage(BaseContainerHandle baseContainerHandle, BasePage basePage) throws StandardException {
        long l = basePage.getPageNumber();
        this.deallocatePagenum(baseContainerHandle, l);
        basePage.deallocatePage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deallocatePagenum(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        AllocationCache allocationCache = this.allocCache;
        synchronized (allocationCache) {
            long l2 = this.allocCache.getAllocPageNumber(baseContainerHandle, l, this.firstAllocPageNumber);
            AllocPage allocPage = (AllocPage)baseContainerHandle.getAllocPage(l2);
            if (allocPage == null) {
                PageKey pageKey = new PageKey(this.identity, l2);
                throw StandardException.newException("XSDF6.S", pageKey);
            }
            try {
                this.allocCache.invalidate(allocPage, l2);
                allocPage.deallocatePage(baseContainerHandle, l);
            }
            finally {
                allocPage.unlatch();
            }
        }
        if (l <= this.lastAllocatedPage) {
            this.lastAllocatedPage = l - 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void compressContainer(RawTransaction rawTransaction, BaseContainerHandle baseContainerHandle) throws StandardException {
        CachedPage cachedPage = null;
        CachedPage cachedPage2 = null;
        if (this.firstAllocPageNumber == -1L) {
            return;
        }
        this.dataFactory.getRawStoreFactory().checkpoint();
        rawTransaction.blockBackup(true);
        try {
            AllocationCache allocationCache = this.allocCache;
            synchronized (allocationCache) {
                cachedPage = (AllocPage)baseContainerHandle.getAllocPage(this.firstAllocPageNumber);
                while (!((AllocPage)cachedPage).isLast()) {
                    if (cachedPage2 != null) {
                        cachedPage2.unlatch();
                    }
                    cachedPage2 = cachedPage;
                    cachedPage = null;
                    long l = ((AllocPage)cachedPage2).getNextAllocPageNumber();
                    long l2 = ((AllocPage)cachedPage2).getNextAllocPageOffset();
                    cachedPage = (AllocPage)baseContainerHandle.getAllocPage(l);
                }
                this.allocCache.invalidate();
                this.lastUnfilledPage = -1L;
                this.lastAllocatedPage = -1L;
                ((AllocPage)cachedPage).compress(rawTransaction, this);
            }
        }
        finally {
            if (cachedPage != null) {
                cachedPage.unlatch();
                cachedPage = null;
            }
            if (cachedPage2 != null) {
                cachedPage2.unlatch();
                cachedPage2 = null;
            }
            this.flushAll();
            this.pageCache.discard(this.identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long getReusableRecordIdSequenceNumber() {
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            return this.reusableRecordIdSequenceNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void incrementReusableRecordIdSequenceNumber() {
        boolean bl = this.dataFactory.isReadOnly();
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            ++this.reusableRecordIdSequenceNumber;
            if (!bl) {
                this.isDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BasePage newPage(BaseContainerHandle baseContainerHandle, RawTransaction rawTransaction, BaseContainerHandle baseContainerHandle2, boolean bl) throws StandardException {
        boolean bl2;
        boolean bl3 = bl2 = rawTransaction != null;
        if (!bl2) {
            rawTransaction = baseContainerHandle.getTransaction();
        }
        long l = -1L;
        int n = 0;
        int n2 = 120;
        long l2 = this.lastAllocatedPage;
        CachedPage cachedPage = null;
        BasePage basePage = null;
        try {
            boolean bl4;
            do {
                boolean bl5;
                boolean bl6;
                bl4 = false;
                Object object = this.allocCache;
                synchronized (object) {
                    try {
                        cachedPage = this.findAllocPageForAdd(baseContainerHandle2, rawTransaction, l2);
                    }
                    catch (InterruptDetectedException interruptDetectedException) {
                        if (--n2 > 0) {
                            this.firstAllocPageNumber = -1L;
                            bl4 = true;
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                InterruptStatus.setInterrupted();
                            }
                            continue;
                        }
                        throw StandardException.newException("XSDG9.D", interruptDetectedException, new Object[0]);
                    }
                    this.allocCache.invalidate((AllocPage)cachedPage, cachedPage.getPageNumber());
                }
                l = ((AllocPage)cachedPage).nextFreePageNumber(l2);
                long l3 = ((AllocPage)cachedPage).getLastPagenum();
                long l4 = ((AllocPage)cachedPage).getLastPreallocPagenum();
                boolean bl7 = l <= l3;
                PageKey pageKey = new PageKey(this.identity, l);
                if (bl7) {
                    object = BasePage.MakeRecordHandle(pageKey, 2);
                    if (!this.getDeallocLock(baseContainerHandle2, (RecordHandle)object, false, true)) {
                        if (n == 0) {
                            l2 = -1L;
                            this.lastAllocatedPage = l;
                        } else {
                            l2 = l;
                        }
                        ++n;
                        cachedPage.unlatch();
                        cachedPage = null;
                        bl4 = true;
                    } else {
                        this.lastAllocatedPage = l;
                    }
                } else {
                    this.lastAllocatedPage = n > 0 ? -1L : l;
                }
                if (bl4) continue;
                boolean bl8 = bl6 = (baseContainerHandle2.getMode() & 1) == 1;
                if (!bl6 && (this.bulkIncreaseContainerSize || l > l4 && l > (long)this.PreAllocThreshold)) {
                    ((AllocPage)cachedPage).preAllocatePage(this, this.PreAllocThreshold, this.PreAllocSize);
                }
                boolean bl9 = bl5 = l <= (l4 = ((AllocPage)cachedPage).getLastPreallocPagenum());
                PageCreationArgs pageCreationArgs = new PageCreationArgs(117, bl5 ? 0 : (bl6 ? 0 : 1), this.pageSize, this.spareSpace, this.minimumRecordSize, 0);
                long l5 = l * (long)this.pageSize;
                try {
                    basePage = this.initPage(baseContainerHandle2, pageKey, pageCreationArgs, l5, bl7, bl);
                }
                catch (StandardException standardException) {
                    this.allocCache.dumpAllocationCache();
                    throw standardException;
                }
                ((AllocPage)cachedPage).addPage(this, l, rawTransaction, baseContainerHandle);
                if (!bl2) continue;
                basePage.unlatch();
                basePage = null;
                basePage = (BasePage)((Object)this.pageCache.find(pageKey));
                basePage = this.latchPage(baseContainerHandle, basePage, false);
                if (basePage != null && basePage.recordCount() == 0 && basePage.getPageStatus() == 1) continue;
                bl4 = true;
                if (basePage != null) {
                    basePage.unlatch();
                    basePage = null;
                }
                cachedPage.unlatch();
                cachedPage = null;
            } while (bl4);
        }
        catch (StandardException standardException) {
            if (basePage != null) {
                basePage.unlatch();
            }
            basePage = null;
            throw standardException;
        }
        finally {
            if (!bl2 && cachedPage != null) {
                cachedPage.unlatch();
                cachedPage = null;
            }
        }
        if (this.bulkIncreaseContainerSize) {
            this.bulkIncreaseContainerSize = false;
            this.PreAllocSize = 8;
        }
        if (!bl && basePage != null) {
            this.setLastInsertedPage(l);
        }
        if (this.estimatedPageCount >= 0L) {
            ++this.estimatedPageCount;
        }
        if (!this.identity.equals(basePage.getPageId().getContainerId())) {
            throw StandardException.newException("XSDAC.S", this.identity, basePage.getPageId().getContainerId());
        }
        return basePage;
    }

    @Override
    protected void clearPreallocThreshold() {
        this.PreAllocThreshold = 0;
    }

    @Override
    protected void prepareForBulkLoad(BaseContainerHandle baseContainerHandle, int n) {
        this.clearPreallocThreshold();
        RawTransaction rawTransaction = baseContainerHandle.getTransaction();
        AllocPage allocPage = this.findLastAllocPage(baseContainerHandle, rawTransaction);
        if (allocPage != null) {
            allocPage.preAllocatePage(this, 0, n);
            allocPage.unlatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pageValid(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        boolean bl;
        boolean bl2 = false;
        int n = 120;
        do {
            bl = true;
            AllocationCache allocationCache = this.allocCache;
            synchronized (allocationCache) {
                try {
                    if (l <= this.allocCache.getLastPageNumber(baseContainerHandle, this.firstAllocPageNumber) && this.allocCache.getPageStatus(baseContainerHandle, l, this.firstAllocPageNumber) == 0) {
                        bl2 = true;
                    }
                }
                catch (InterruptDetectedException interruptDetectedException) {
                    if (--n > 0) {
                        bl = false;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            InterruptStatus.setInterrupted();
                        }
                        continue;
                    }
                    throw StandardException.newException("XSDG9.D", interruptDetectedException, new Object[0]);
                }
            }
        } while (!bl);
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLastPageNumber(BaseContainerHandle baseContainerHandle) throws StandardException {
        long l;
        AllocationCache allocationCache = this.allocCache;
        synchronized (allocationCache) {
            l = this.firstAllocPageNumber == -1L ? -1L : this.allocCache.getLastPageNumber(baseContainerHandle, this.firstAllocPageNumber);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllocPage findAllocPageForAdd(BaseContainerHandle baseContainerHandle, RawTransaction rawTransaction, long l) throws StandardException {
        CachedPage cachedPage = null;
        CachedPage cachedPage2 = null;
        boolean bl = false;
        try {
            cachedPage = this.firstAllocPageNumber == -1L ? this.makeAllocPage(rawTransaction, baseContainerHandle, 0L, 0L, 80) : (AllocPage)baseContainerHandle.getAllocPage(this.firstAllocPageNumber);
            if (!((AllocPage)cachedPage).canAddFreePage(l)) {
                long l2;
                long l3;
                boolean bl2 = false;
                while (!((AllocPage)cachedPage).isLast()) {
                    l3 = ((AllocPage)cachedPage).getNextAllocPageNumber();
                    l2 = ((AllocPage)cachedPage).getNextAllocPageOffset();
                    cachedPage.unlatch();
                    cachedPage = null;
                    cachedPage = (AllocPage)baseContainerHandle.getAllocPage(l3);
                    if (!((AllocPage)cachedPage).canAddFreePage(l)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    cachedPage2 = cachedPage;
                    cachedPage = null;
                    l2 = l3 = ((AllocPage)cachedPage2).getMaxPagenum() + 1L;
                    cachedPage = this.makeAllocPage(rawTransaction, baseContainerHandle, l3, l2, 0);
                    ((AllocPage)cachedPage2).chainNewAllocPage(baseContainerHandle, l3, l2);
                    cachedPage2.unlatch();
                    cachedPage2 = null;
                }
            }
            bl = true;
        }
        finally {
            if (!bl) {
                if (cachedPage2 != null) {
                    cachedPage2.unlatch();
                }
                if (cachedPage != null) {
                    cachedPage.unlatch();
                }
                cachedPage = null;
            }
        }
        return cachedPage;
    }

    private AllocPage findLastAllocPage(BaseContainerHandle baseContainerHandle, RawTransaction rawTransaction) {
        AllocPage allocPage = null;
        Object var4_4 = null;
        if (this.firstAllocPageNumber == -1L) {
            return null;
        }
        try {
            allocPage = (AllocPage)baseContainerHandle.getAllocPage(this.firstAllocPageNumber);
            while (!allocPage.isLast()) {
                long l = allocPage.getNextAllocPageNumber();
                long l2 = allocPage.getNextAllocPageOffset();
                allocPage.unlatch();
                allocPage = null;
                allocPage = (AllocPage)baseContainerHandle.getAllocPage(l);
            }
        }
        catch (StandardException standardException) {
            if (allocPage != null) {
                allocPage.unlatch();
            }
            allocPage = null;
        }
        return allocPage;
    }

    private AllocPage makeAllocPage(RawTransaction rawTransaction, BaseContainerHandle baseContainerHandle, long l, long l2, int n) throws StandardException {
        boolean bl = (baseContainerHandle.getMode() & 1) == 1;
        PageCreationArgs pageCreationArgs = new PageCreationArgs(118, bl ? 0 : 1, this.pageSize, 0, this.minimumRecordSize, n);
        if (l == 0L) {
            this.firstAllocPageNumber = l;
            this.firstAllocPageOffset = l2;
        }
        PageKey pageKey = new PageKey(this.identity, l);
        return (AllocPage)this.initPage(baseContainerHandle, pageKey, pageCreationArgs, l2, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasePage initPage(BaseContainerHandle baseContainerHandle, PageKey pageKey, PageCreationArgs pageCreationArgs, long l, boolean bl, boolean bl2) throws StandardException {
        BasePage basePage = null;
        boolean bl3 = true;
        try {
            if (bl) {
                basePage = (BasePage)((Object)this.pageCache.find(pageKey));
                if (basePage == null) {
                    throw StandardException.newException("XSDF8.S", pageKey);
                }
            } else {
                basePage = (BasePage)((Object)this.pageCache.create(pageKey, pageCreationArgs));
            }
            bl3 = false;
            if ((basePage = this.latchPage(baseContainerHandle, basePage, true)) == null) {
                throw StandardException.newException("XSDF7.S", pageKey);
            }
            int n = 0;
            if (bl) {
                n |= 1;
            }
            if (bl2) {
                n |= 2;
            }
            if (bl && this.isReusableRecordId()) {
                n |= 4;
            }
            basePage.initPage(n, l);
            basePage.setContainerRowCount(this.estimatedRowCount);
        }
        finally {
            if (bl3 && basePage != null) {
                this.pageCache.release((Cacheable)((Object)basePage));
                basePage = null;
            }
        }
        return basePage;
    }

    private BasePage getUserPage(BaseContainerHandle baseContainerHandle, long l, boolean bl, boolean bl2) throws StandardException {
        if (l < 1L) {
            return null;
        }
        if (this.getCommittedDropState()) {
            return null;
        }
        if (!this.pageValid(baseContainerHandle, l)) {
            return null;
        }
        PageKey pageKey = new PageKey(this.identity, l);
        BasePage basePage = (BasePage)((Object)this.pageCache.find(pageKey));
        if (basePage == null) {
            return basePage;
        }
        if (this.latchPage(baseContainerHandle, basePage, bl2) == null) {
            return null;
        }
        if (basePage.isOverflowPage() && !bl || basePage.getPageStatus() != 1) {
            basePage.unlatch();
            basePage = null;
        }
        return basePage;
    }

    protected void trackUnfilledPage(long l, boolean bl) {
        if (!this.dataFactory.isReadOnly()) {
            this.allocCache.trackUnfilledPage(l, bl);
        }
    }

    @Override
    protected BasePage getPage(BaseContainerHandle baseContainerHandle, long l, boolean bl) throws StandardException {
        return this.getUserPage(baseContainerHandle, l, true, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BasePage getAnyPage(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        if (this.getCommittedDropState()) {
            return null;
        }
        Object object = this.allocCache;
        synchronized (object) {
            this.allocCache.invalidate();
        }
        object = new PageKey(this.identity, l);
        BasePage basePage = (BasePage)((Object)this.pageCache.find(object));
        return basePage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BasePage reCreatePageForRedoRecovery(BaseContainerHandle baseContainerHandle, int n, long l, long l2) throws StandardException {
        BasePage basePage;
        block14: {
            PageCreationArgs pageCreationArgs;
            boolean bl = baseContainerHandle.getTransaction().inRollForwardRecovery();
            if (!bl && !PropertyUtil.getSystemBoolean("derby.storage.patchInitPageRecoverError")) {
                return null;
            }
            PageKey pageKey = new PageKey(this.identity, l);
            if (n == 117) {
                pageCreationArgs = new PageCreationArgs(n, 1, this.pageSize, this.spareSpace, this.minimumRecordSize, 0);
            } else if (n == 118) {
                int n2 = 0;
                if (l == 0L) {
                    n2 = 80;
                    this.firstAllocPageNumber = l;
                    this.firstAllocPageOffset = l2;
                }
                pageCreationArgs = new PageCreationArgs(n, 1, this.pageSize, 0, this.minimumRecordSize, n2);
            } else {
                throw StandardException.newException("XSDB1.D", pageKey);
            }
            basePage = null;
            boolean bl2 = true;
            try {
                try {
                    basePage = (BasePage)((Object)this.pageCache.create(pageKey, pageCreationArgs));
                }
                catch (StandardException standardException) {
                    throw StandardException.newException("XSDFI.S", standardException, pageKey);
                }
                if (basePage != null) {
                    bl2 = false;
                    if ((basePage = this.latchPage(baseContainerHandle, basePage, false)) == null) {
                        throw StandardException.newException("XSDF7.S", pageKey);
                    }
                    break block14;
                }
                throw StandardException.newException("XSDFI.S", pageKey);
            }
            finally {
                if (bl2 && basePage != null) {
                    this.pageCache.release((Cacheable)((Object)basePage));
                    basePage = null;
                }
            }
        }
        return basePage;
    }

    @Override
    protected BasePage getAllocPage(long l) throws StandardException {
        if (this.getCommittedDropState()) {
            return null;
        }
        PageKey pageKey = new PageKey(this.identity, l);
        BasePage basePage = (BasePage)((Object)this.pageCache.find(pageKey));
        return basePage;
    }

    @Override
    protected BasePage getHeadPage(BaseContainerHandle baseContainerHandle, long l, boolean bl) throws StandardException {
        return this.getUserPage(baseContainerHandle, l, false, bl);
    }

    @Override
    protected BasePage getFirstHeadPage(BaseContainerHandle baseContainerHandle, boolean bl) throws StandardException {
        return this.getNextHeadPage(baseContainerHandle, 0L, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BasePage getNextHeadPage(BaseContainerHandle baseContainerHandle, long l, boolean bl) throws StandardException {
        while (true) {
            long l2;
            Object object = this.allocCache;
            synchronized (object) {
                l2 = this.allocCache.getNextValidPage(baseContainerHandle, l, this.firstAllocPageNumber);
            }
            if (l2 == -1L) {
                return null;
            }
            object = this.getUserPage(baseContainerHandle, l2, false, bl);
            if (object != null) {
                return object;
            }
            l = l2;
        }
    }

    private BasePage getInsertablePage(BaseContainerHandle baseContainerHandle, long l, boolean bl, boolean bl2) throws StandardException {
        if (l == -1L) {
            return null;
        }
        BasePage basePage = this.getUserPage(baseContainerHandle, l, bl2, bl);
        if (basePage != null && !basePage.allowInsert()) {
            basePage.unlatch();
            basePage = null;
            this.allocCache.trackUnfilledPage(l, false);
        }
        return basePage;
    }

    @Override
    protected BasePage getPageForCompress(BaseContainerHandle baseContainerHandle, int n, long l) throws StandardException {
        boolean bl;
        BasePage basePage = null;
        boolean bl2 = bl = (n & 1) == 0;
        if (bl) {
            long l2 = this.getLastInsertedPage();
            if (l2 < l && l2 != -1L && (basePage = this.getInsertablePage(baseContainerHandle, l2, true, false)) == null) {
                if (l2 == this.getLastUnfilledPage()) {
                    this.setLastUnfilledPage(-1L);
                }
                if (l2 == this.getLastInsertedPage()) {
                    this.setLastInsertedPage(-1L);
                }
            }
        } else {
            long l3 = this.getLastUnfilledPage();
            if (l3 == -1L || l3 >= l || l3 == this.getLastInsertedPage()) {
                l3 = this.getUnfilledPageNumber(baseContainerHandle, 0L);
            }
            if (l3 != -1L && l3 < l) {
                basePage = this.getInsertablePage(baseContainerHandle, l3, true, false);
            }
            if (basePage != null) {
                this.setLastUnfilledPage(l3);
                this.setLastInsertedPage(l3);
            }
        }
        return basePage;
    }

    @Override
    protected BasePage getPageForInsert(BaseContainerHandle baseContainerHandle, int n) throws StandardException {
        boolean bl;
        BasePage basePage = null;
        boolean bl2 = bl = (n & 1) == 0;
        if (bl) {
            long l = this.getLastInsertedPage();
            if (l != -1L && (basePage = this.getInsertablePage(baseContainerHandle, l, false, false)) == null) {
                l = this.getLastInsertedPage();
                basePage = this.getInsertablePage(baseContainerHandle, l, true, false);
            }
            if (basePage == null) {
                if (l == this.getLastUnfilledPage()) {
                    this.setLastUnfilledPage(-1L);
                }
                if (l == this.getLastInsertedPage()) {
                    this.setLastInsertedPage(-1L);
                }
            }
        } else {
            long l = this.getLastUnfilledPage();
            if (l == -1L || l == this.getLastInsertedPage()) {
                l = this.getUnfilledPageNumber(baseContainerHandle, l);
            }
            if (l != -1L && (basePage = this.getInsertablePage(baseContainerHandle, l, true, false)) == null && (l = this.getUnfilledPageNumber(baseContainerHandle, l)) != -1L) {
                basePage = this.getInsertablePage(baseContainerHandle, l, true, false);
            }
            if (basePage != null) {
                this.setLastUnfilledPage(l);
                this.setLastInsertedPage(l);
            }
        }
        return basePage;
    }

    protected BasePage getLatchedPage(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        PageKey pageKey = new PageKey(this.identity, l);
        BasePage basePage = (BasePage)((Object)this.pageCache.find(pageKey));
        basePage = this.latchPage(baseContainerHandle, basePage, true);
        return basePage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUnfilledPageNumber(BaseContainerHandle baseContainerHandle, long l) throws StandardException {
        AllocationCache allocationCache = this.allocCache;
        synchronized (allocationCache) {
            return this.allocCache.getUnfilledPageNumber(baseContainerHandle, this.firstAllocPageNumber, l);
        }
    }

    @Override
    public long getEstimatedRowCount(int n) {
        return this.estimatedRowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEstimatedRowCount(long l, int n) {
        boolean bl = this.dataFactory.isReadOnly();
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            this.estimatedRowCount = l;
            if (!bl) {
                this.isDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateEstimatedRowCount(int n) {
        boolean bl = this.dataFactory.isReadOnly();
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            this.estimatedRowCount += (long)n;
            if (this.estimatedRowCount < 0L) {
                this.estimatedRowCount = 0L;
            }
            if (!bl) {
                this.isDirty = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEstimatedPageCount(BaseContainerHandle baseContainerHandle, int n) throws StandardException {
        if (this.estimatedPageCount < 0L) {
            AllocationCache allocationCache = this.allocCache;
            synchronized (allocationCache) {
                this.estimatedPageCount = this.allocCache.getEstimatedPageCount(baseContainerHandle, this.firstAllocPageNumber);
            }
        }
        return this.estimatedPageCount;
    }

    protected abstract void readPage(long var1, byte[] var3) throws IOException, StandardException;

    protected abstract void writePage(long var1, byte[] var3, boolean var4) throws IOException, StandardException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decryptPage(byte[] byArray, int n) throws StandardException {
        FileContainer fileContainer = this;
        synchronized (fileContainer) {
            if (this.encryptionBuffer == null || this.encryptionBuffer.length < n) {
                this.encryptionBuffer = new byte[n];
            }
            int n2 = this.dataFactory.decrypt(byArray, 0, n, this.encryptionBuffer, 0);
            System.arraycopy(this.encryptionBuffer, 8, byArray, 0, n - 8);
            System.arraycopy(this.encryptionBuffer, 0, byArray, n - 8, 8);
        }
    }

    protected byte[] encryptPage(byte[] byArray, int n, byte[] byArray2, boolean bl) throws StandardException {
        System.arraycopy(byArray, n - 8, byArray2, 0, 8);
        System.arraycopy(byArray, 0, byArray2, 8, n - 8);
        int n2 = this.dataFactory.encrypt(byArray2, 0, n, byArray2, 0, bl);
        return byArray2;
    }

    protected byte[] getEncryptionBuffer() {
        if (this.encryptionBuffer == null || this.encryptionBuffer.length < this.pageSize) {
            this.encryptionBuffer = new byte[this.pageSize];
        }
        return this.encryptionBuffer;
    }

    protected abstract int preAllocate(long var1, int var3);

    protected int doPreAllocatePages(long l, int n) {
        int n2;
        PageCreationArgs pageCreationArgs = new PageCreationArgs(117, 2, this.pageSize, this.spareSpace, this.minimumRecordSize, 0);
        StoredPage storedPage = new StoredPage();
        storedPage.setFactory(this.dataFactory);
        boolean bl = false;
        for (n2 = 0; n2 < n; ++n2) {
            PageKey pageKey = new PageKey(this.identity, l + (long)n2 + 1L);
            try {
                storedPage.createIdentity(pageKey, pageCreationArgs);
                storedPage.clearIdentity();
            }
            catch (StandardException standardException) {
                bl = true;
            }
            if (bl) break;
        }
        return n2;
    }

    protected int getPageSize() {
        return this.pageSize;
    }

    protected int getSpareSpace() {
        return this.spareSpace;
    }

    protected int getMinimumRecordSize() {
        return this.minimumRecordSize;
    }

    private synchronized void switchToMultiInsertPageMode(BaseContainerHandle baseContainerHandle) throws StandardException {
        if (this.lastInsertedPage.length == 1) {
            long l = this.lastInsertedPage[0];
            this.lastInsertedPage = new long[4];
            this.lastInsertedPage[0] = l;
            for (int i = 3; i > 0; --i) {
                Page page = this.addPage(baseContainerHandle, false);
                this.lastInsertedPage[i] = page.getPageNumber();
                page.unlatch();
            }
        }
    }

    private synchronized long getLastInsertedPage() {
        if (this.lastInsertedPage.length == 1) {
            return this.lastInsertedPage[0];
        }
        long l = this.lastInsertedPage[this.lastInsertedPage_index++];
        if (this.lastInsertedPage_index > this.lastInsertedPage.length - 1) {
            this.lastInsertedPage_index = 0;
        }
        return l;
    }

    private synchronized long getLastUnfilledPage() {
        return this.lastUnfilledPage;
    }

    private synchronized void initializeLastInsertedPage(int n) {
        this.lastInsertedPage = new long[n];
        for (int i = this.lastInsertedPage.length - 1; i >= 0; --i) {
            this.lastInsertedPage[i] = -1L;
        }
        this.lastInsertedPage_index = 0;
    }

    private synchronized void setLastInsertedPage(long l) {
        this.lastInsertedPage[this.lastInsertedPage_index] = l;
    }

    private synchronized void setLastUnfilledPage(long l) {
        this.lastUnfilledPage = l;
    }

    @Override
    protected void letGo(BaseContainerHandle baseContainerHandle) {
        super.letGo(baseContainerHandle);
        this.containerCache.release(this);
    }

    @Override
    protected BasePage latchPage(BaseContainerHandle baseContainerHandle, BasePage basePage, boolean bl) throws StandardException {
        if (basePage == null) {
            return null;
        }
        BasePage basePage2 = super.latchPage(baseContainerHandle, basePage, bl);
        if (basePage2 == null) {
            this.pageCache.release((Cacheable)((Object)basePage));
        }
        return basePage2;
    }

    @Override
    protected abstract void backupContainer(BaseContainerHandle var1, String var2) throws StandardException;

    static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static Object getServiceModule(final Object object, final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.getServiceModule(object, string);
            }
        });
    }
}

