/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.service.rpc.thrift.TGetInfoType;
import org.apache.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.client.api.v1.dto.ExecPoolStatistic;
import org.apache.kyuubi.client.api.v1.dto.GetColumnsRequest;
import org.apache.kyuubi.client.api.v1.dto.GetCrossReferenceRequest;
import org.apache.kyuubi.client.api.v1.dto.GetFunctionsRequest;
import org.apache.kyuubi.client.api.v1.dto.GetPrimaryKeysRequest;
import org.apache.kyuubi.client.api.v1.dto.GetSchemasRequest;
import org.apache.kyuubi.client.api.v1.dto.GetTablesRequest;
import org.apache.kyuubi.client.api.v1.dto.InfoDetail;
import org.apache.kyuubi.client.api.v1.dto.SessionData;
import org.apache.kyuubi.client.api.v1.dto.SessionHandle;
import org.apache.kyuubi.client.api.v1.dto.SessionOpenCount;
import org.apache.kyuubi.client.api.v1.dto.SessionOpenRequest;
import org.apache.kyuubi.client.api.v1.dto.StatementRequest;
import org.apache.kyuubi.events.KyuubiEvent;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.server.KyuubiRestFrontendService;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.apache.kyuubi.server.api.v1.SessionsResource$;
import org.apache.kyuubi.session.KyuubiSession;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.session.SessionManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.MapLike;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@Tag(name="Session")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\r=g!\u0002\u000e\u001c\u0001m9\u0003\"\u0002\u001c\u0001\t\u0003A\u0004\"B\u001e\u0001\t\u0007a\u0004\"\u0002)\u0001\t\u0013\t\u0006\"B+\u0001\t\u00031\u0006bBA%\u0001\u0011\u0005\u00111\n\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\tI\f\u0001C\u0001\u0003wCq!!7\u0001\t\u0003\tY\u000eC\u0004\u0002z\u0002!\t!a?\t\u000f\tu\u0001\u0001\"\u0001\u0003 !9!1\t\u0001\u0005\u0002\t\u0015\u0003b\u0002B;\u0001\u0011\u0005!q\u000f\u0005\b\u0005\u001b\u0003A\u0011\u0001BH\u0011\u001d\u0011)\u000b\u0001C\u0001\u0005OCqA!2\u0001\t\u0003\u00119\rC\u0004\u0003f\u0002!\tAa:\t\u000f\tu\b\u0001\"\u0001\u0003\u0000\"91Q\u0004\u0001\u0005\u0002\r}\u0001bBB\u001f\u0001\u0011\u00051q\b\u0005\b\u0007;\u0002A\u0011AB0\u000f\u001d\u0019)k\u0007E\u0001\u0007O3aAG\u000e\t\u0002\r%\u0006B\u0002\u001c\u0017\t\u0003\u0019Y\u000bC\u0005\u0004.Z\u0011\r\u0011\"\u0002\u00040\"A1Q\u001a\f!\u0002\u001b\u0019\tL\u0001\tTKN\u001c\u0018n\u001c8t%\u0016\u001cx.\u001e:dK*\u0011A$H\u0001\u0003mFR!AH\u0010\u0002\u0007\u0005\u0004\u0018N\u0003\u0002!C\u000511/\u001a:wKJT!AI\u0012\u0002\r-LX/\u001e2j\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0014\t\u0001AcF\r\t\u0003S1j\u0011A\u000b\u0006\u0002W\u0005)1oY1mC&\u0011QF\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0002T\"A\u000f\n\u0005Ej\"!E!qSJ+\u0017/^3ti\u000e{g\u000e^3yiB\u00111\u0007N\u0007\u0002C%\u0011Q'\t\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u001d\u0011\u0005i\u0002Q\"A\u000e\u0002\u001fQ|7+Z:tS>t\u0007*\u00198eY\u0016$\"!P\"\u0011\u0005y\nU\"A \u000b\u0005\u0001\u000b\u0013aB:fgNLwN\\\u0005\u0003\u0005~\u0012QbU3tg&|g\u000eS1oI2,\u0007\"\u0002#\u0003\u0001\u0004)\u0015aA:ueB\u0011a)\u0014\b\u0003\u000f.\u0003\"\u0001\u0013\u0016\u000e\u0003%S!AS\u001c\u0002\rq\u0012xn\u001c;?\u0013\ta%&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u0013aa\u0015;sS:<'B\u0001'+\u00039\u0019Xm]:j_:l\u0015M\\1hKJ,\u0012A\u0015\t\u0003}MK!\u0001V \u0003\u001dM+7o]5p]6\u000bg.Y4fe\u0006A1/Z:tS>t7\u000fF\u0001X!\rAV\f\u0019\b\u00033ns!\u0001\u0013.\n\u0003-J!\u0001\u0018\u0016\u0002\u000fA\f7m[1hK&\u0011al\u0018\u0002\u0004'\u0016\f(B\u0001/+!\t\t\u0007.D\u0001c\u0015\t\u0019G-A\u0002ei>T!\u0001H3\u000b\u0005y1'BA4\"\u0003\u0019\u0019G.[3oi&\u0011\u0011N\u0019\u0002\f'\u0016\u001c8/[8o\t\u0006$\u0018\r\u000b\u0002\u0005WB\u0011An]\u0007\u0002[*\u0011an\\\u0001\u0003eNT!\u0001]9\u0002\u0005]\u001c(\"\u0001:\u0002\u000b)\fg/\u0019=\n\u0005Ql'aA$F)\"rAA^A\u0007\u0003\u001f\t\u0019\"!\u0006\u0002D\u0005\u0015\u0003cA<\u0002\n5\t\u0001P\u0003\u0002zu\u0006I!/Z:q_:\u001cXm\u001d\u0006\u0003wr\f1\"\u00198o_R\fG/[8og*\u0011QP`\u0001\u0004_\u0006\u001c(bA@\u0002\u0002\u0005\u0011ao\r\u0006\u0005\u0003\u0007\t)!A\u0004to\u0006<w-\u001a:\u000b\u0005\u0005\u001d\u0011AA5p\u0013\r\tY\u0001\u001f\u0002\f\u0003BL'+Z:q_:\u001cX-\u0001\u0007sKN\u0004xN\\:f\u0007>$W-\t\u0002\u0002\u0012\u0005\u0019!\u0007\r\u0019\u0002\u000f\r|g\u000e^3oi2\u0012\u0011qC\u0016\u000b\u00033\t)#a\n\u0002,\u00055\u0002\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}!0A\u0003nK\u0012L\u0017-\u0003\u0003\u0002$\u0005u!aB\"p]R,g\u000e^\u0001\n[\u0016$\u0017.\u0019+za\u0016\f#!!\u000b\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0017!B1se\u0006L8FBA\u0018\u0003k\t9\u0004\u0005\u0003\u0002\u001c\u0005E\u0012\u0002BA\u001a\u0003;\u00111\"\u0011:sCf\u001c6\r[3nC\u000611o\u00195f[\u0006\\c!!\u000f\u0002@\u0005\u0005\u0003\u0003BA\u000e\u0003wIA!!\u0010\u0002\u001e\t11k\u00195f[\u0006\fa\"[7qY\u0016lWM\u001c;bi&|gnI\u0001a\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0005\u0005\u001d\u0013!I4fi\u0002\"\b.\u001a\u0011mSN$\be\u001c4!C2d\u0007\u0005\\5wK\u0002\u001aXm]:j_:\u001c\u0018aC:fgNLwN\\%oM>$B!!\u0014\u0002ZA!\u0011qJA+\u001b\t\t\tFC\u0002\u0002T\u0005\na!\u001a<f]R\u001c\u0018\u0002BA,\u0003#\u00121bS=vk\nLWI^3oi\"1\u00111L\u0003A\u0002\u0015\u000b\u0001c]3tg&|g\u000eS1oI2,7\u000b\u001e:)\u0011\u0005e\u0013qLA3\u0003O\u00022\u0001\\A1\u0013\r\t\u0019'\u001c\u0002\n!\u0006$\b\u000eU1sC6\fQA^1mk\u0016\f#!!\u001b\u0002\u001bM,7o]5p]\"\u000bg\u000e\u001a7fQ\u001d)\u0011QNA3\u0003g\u00022\u0001\\A8\u0013\r\t\t(\u001c\u0002\u0005!\u0006$\b.\t\u0002\u0002v\u0005y1p]3tg&|g\u000eS1oI2,W\u0010\u000b\u0002\u0006W\"rQA^A\u0007\u0003\u001f\t\u0019\"a\u001f\u0002D\u0005\rEFAA?W)\tI\"!\n\u0002(\u0005U\u0012qP\u0016\u0007\u0003s\ty$!!$\u0005\u00055\u0013EAAC\u0003E:W\r\u001e\u0011bAM,7o]5p]\u0002*g/\u001a8uAYL\u0017\rI:fgNLwN\u001c\u0011iC:$G.\u001a\u0011jI\u0016tG/\u001b4jKJ\fqaZ3u\u0013:4w\u000e\u0006\u0004\u0002\f\u0006E\u0015Q\u0013\t\u0004C\u00065\u0015bAAHE\nQ\u0011J\u001c4p\t\u0016$\u0018-\u001b7\t\r\u0005mc\u00011\u0001FQ!\t\t*a\u0018\u0002f\u0005\u001d\u0004bBAL\r\u0001\u0007\u0011\u0011T\u0001\tS:4w\u000eV=qKB\u0019\u0011&a'\n\u0007\u0005u%FA\u0002J]RD\u0003\"!&\u0002`\u0005\u0015\u0014\u0011U\u0011\u0003\u0003/CsABA7\u0003K\n)+\t\u0002\u0002(\u0006y2p]3tg&|g\u000eS1oI2,WpL5oM>|30\u001b8g_RK\b/Z?)\u0005\u0019Y\u0007F\u0004\u0004w\u0003\u001b\ty!a\u0005\u0002.\u0006\r\u0013Q\u0017\u0017\u0003\u0003_[#\"!\u0007\u0002&\u0005\u001d\u0012QGAYW\u0019\tI$a\u0010\u00024\u000e\u0012\u00111R\u0011\u0003\u0003o\u000bakZ3uA\u0005\u0004\u0013N\u001c4pe6\fG/[8oA\u0011,G/Y5mAYL\u0017\rI:fgNLwN\u001c\u0011iC:$G.\u001a\u0011jI\u0016tG/\u001b4jKJ\u0004\u0013M\u001c3!C\u0002\u001a\b/Z2jM&\u001c\u0007%\u001b8g_Jl\u0017\r^5p]\u0002\"\u0018\u0010]3\u0002\u0019M,7o]5p]\u000e{WO\u001c;\u0015\u0005\u0005u\u0006cA1\u0002@&\u0019\u0011\u0011\u00192\u0003!M+7o]5p]>\u0003XM\\\"pk:$\bfB\u0004\u0002n\u0005\u0015\u0014QY\u0011\u0003\u0003\u000f\fQaY8v]RD#aB6)\u001d\u001d1\u0018QBA\b\u0003'\ti-a\u0011\u0002V2\u0012\u0011qZ\u0016\u000b\u00033\t)#a\n\u00026\u0005E7FBA\u001d\u0003\u007f\t\u0019n\t\u0002\u0002>\u0006\u0012\u0011q[\u0001#\u000f\u0016$\b\u0005\u001e5fA\r,(O]3oi\u0002z\u0007/\u001a8!g\u0016\u001c8/[8oA\r|WO\u001c;\u0002#\u0015DXm\u0019)p_2\u001cF/\u0019;jgRL7\r\u0006\u0002\u0002^B\u0019\u0011-a8\n\u0007\u0005\u0005(MA\tFq\u0016\u001c\u0007k\\8m'R\fG/[:uS\u000eDs\u0001CA7\u0003K\n)/\t\u0002\u0002h\u0006\u0011R\r_3d!>|GnL:uCRL7\u000f^5dQ\tA1\u000e\u000b\b\tm\u00065\u0011qBA\n\u0003[\f\u0019%!>-\u0005\u0005=8FCA\r\u0003K\t9#!\u000e\u0002r.2\u0011\u0011HA \u0003g\u001c#!!8\"\u0005\u0005]\u0018AK$fi\u0002\u001aH/\u0019;jgRL7\rI5oM>\u0004sN\u001a\u0011cC\u000e\\wM]8v]\u0012\u0004S\r_3dkR|'o]\u0001\f_B,gnU3tg&|g\u000e\u0006\u0003\u0002~\n\u0005\u0001cA1\u0002\u0000&\u0011!I\u0019\u0005\b\u0005\u0007I\u0001\u0019\u0001B\u0003\u0003\u001d\u0011X-];fgR\u00042!\u0019B\u0004\u0013\r\u0011IA\u0019\u0002\u0013'\u0016\u001c8/[8o\u001fB,gNU3rk\u0016\u001cH\u000fK\u0002\n\u0005\u001b\u00012\u0001\u001cB\b\u0013\r\u0011\t\"\u001c\u0002\u0005!>\u001bF\u000b\u000b\b\nm\u00065\u0011qBA\n\u0005+\t\u0019E!\u0007-\u0005\t]1FBA\r\u0003K\t9#\t\u0002\u0003\u001c\u00051r\n]3oQ\r\u0014X-\u0019;fS\u0001\n\u0007e]3tg&|g.\u0001\u0007dY>\u001cXmU3tg&|g\u000e\u0006\u0003\u0003\"\t5\u0002\u0003\u0002B\u0012\u0005Si!A!\n\u000b\u0007\t\u001dR.\u0001\u0003d_J,\u0017\u0002\u0002B\u0016\u0005K\u0011\u0001BU3ta>t7/\u001a\u0005\u0007\u00037R\u0001\u0019A#)\u0011\t5\u0012qLA3\u0003OBsACA7\u0003K\n\u0019\bK\u0002\u000b\u0005k\u00012\u0001\u001cB\u001c\u0013\r\u0011I$\u001c\u0002\u0007\t\u0016cU\tV#)\u001d)1\u0018QBA\b\u0003'\u0011i$a\u0011\u0003@1\u0012!qC\u0011\u0003\u0005\u0003\nqb\u00117pg\u0016\u0004\u0013\rI:fgNLwN\\\u0001\u0011Kb,7-\u001e;f'R\fG/Z7f]R$bAa\u0012\u0003T\t]\u0003\u0003\u0002B%\u0005\u001fj!Aa\u0013\u000b\u0007\t5\u0013%A\u0005pa\u0016\u0014\u0018\r^5p]&!!\u0011\u000bB&\u0005=y\u0005/\u001a:bi&|g\u000eS1oI2,\u0007BBA.\u0017\u0001\u0007Q\t\u000b\u0005\u0003T\u0005}\u0013QMA4\u0011\u001d\u0011\u0019a\u0003a\u0001\u00053\u00022!\u0019B.\u0013\r\u0011iF\u0019\u0002\u0011'R\fG/Z7f]R\u0014V-];fgRDsaCA7\u0003K\u0012\t'\t\u0002\u0003d\u0005!3p]3tg&|g\u000eS1oI2,WpL8qKJ\fG/[8og>\u001aH/\u0019;f[\u0016tG\u000fK\u0002\f\u0005\u001bAcb\u0003<\u0002\u000e\u0005=\u00111\u0003B5\u0003\u0007\u0012\t\b\f\u0002\u0003l-R\u0011\u0011DA\u0013\u0003O\t)D!\u001c,\r\u0005e\u0012q\bB8G\t\u00119%\t\u0002\u0003t\u0005y3I]3bi\u0016\u0004\u0013M\u001c\u0011pa\u0016\u0014\u0018\r^5p]\u0002:\u0018\u000e\u001e5!\u000bb+5)\u0016+F?N#\u0016\tV#N\u000b:#\u0006\u0005^=qK\u0006Yq-\u001a;UsB,\u0017J\u001c4p)\u0011\u00119E!\u001f\t\r\u0005mC\u00021\u0001FQ!\u0011I(a\u0018\u0002f\u0005\u001d\u0004f\u0002\u0007\u0002n\u0005\u0015$qP\u0011\u0003\u0005\u0003\u000b1e_:fgNLwN\u001c%b]\u0012dW-`\u0018pa\u0016\u0014\u0018\r^5p]N|C/\u001f9f\u0013:4w\u000eK\u0002\r\u0005\u001bAc\u0002\u0004<\u0002\u000e\u0005=\u00111\u0003BD\u0003\u0007\u0012I\t\f\u0002\u0003l\u0005\u0012!1R\u0001,\u0007J,\u0017\r^3!C:\u0004s\u000e]3sCRLwN\u001c\u0011xSRD\u0007eR#U?RK\u0006+R0J\u001d\u001a{\u0005\u0005^=qK\u0006Yq-\u001a;DCR\fGn\\4t)\u0011\u00119E!%\t\r\u0005mS\u00021\u0001FQ!\u0011\t*a\u0018\u0002f\u0005\u001d\u0004fB\u0007\u0002n\u0005\u0015$qS\u0011\u0003\u00053\u000b1e_:fgNLwN\u001c%b]\u0012dW-`\u0018pa\u0016\u0014\u0018\r^5p]N|3-\u0019;bY><7\u000fK\u0002\u000e\u0005\u001bAc\"\u0004<\u0002\u000e\u0005=\u00111\u0003BP\u0003\u0007\u0012\t\u000b\f\u0002\u0003l\u0005\u0012!1U\u0001+\u0007J,\u0017\r^3!C:\u0004s\u000e]3sCRLwN\u001c\u0011xSRD\u0007eR#U?\u000e\u000bE+\u0011'P\u000fN\u0003C/\u001f9f\u0003)9W\r^*dQ\u0016l\u0017m\u001d\u000b\u0007\u0005\u000f\u0012IK!,\t\r\u0005mc\u00021\u0001FQ!\u0011I+a\u0018\u0002f\u0005\u001d\u0004b\u0002B\u0002\u001d\u0001\u0007!q\u0016\t\u0004C\nE\u0016b\u0001BZE\n\tr)\u001a;TG\",W.Y:SKF,Xm\u001d;)\u000f9\ti'!\u001a\u00038\u0006\u0012!\u0011X\u0001#wN,7o]5p]\"\u000bg\u000e\u001a7f{>z\u0007/\u001a:bi&|gn]\u0018tG\",W.Y:)\u00079\u0011i\u0001\u000b\b\u000fm\u00065\u0011qBA\n\u0005\u007f\u000b\u0019E!1-\u0005\t-\u0014E\u0001Bb\u0003%\u001a%/Z1uK\u0002\ng\u000eI8qKJ\fG/[8oA]LG\u000f\u001b\u0011H\u000bR{6k\u0011%F\u001b\u0006\u001b\u0006\u0005^=qK\u0006Iq-\u001a;UC\ndWm\u001d\u000b\u0007\u0005\u000f\u0012IM!4\t\r\u0005ms\u00021\u0001FQ!\u0011I-a\u0018\u0002f\u0005\u001d\u0004b\u0002B\u0002\u001f\u0001\u0007!q\u001a\t\u0004C\nE\u0017b\u0001BjE\n\u0001r)\u001a;UC\ndWm\u001d*fcV,7\u000f\u001e\u0015\b\u001f\u00055\u0014Q\rBlC\t\u0011I.A\u0011|g\u0016\u001c8/[8o\u0011\u0006tG\r\\3~_=\u0004XM]1uS>t7o\f;bE2,7\u000fK\u0002\u0010\u0005\u001bAcb\u0004<\u0002\u000e\u0005=\u00111\u0003Bp\u0003\u0007\u0012\t\u000f\f\u0002\u0003l\u0005\u0012!1]\u0001)\u0007J,\u0017\r^3!C:\u0004s\u000e]3sCRLwN\u001c\u0011xSRD\u0007eR#U?R\u000b%\tT#TAQL\b/Z\u0001\u000eO\u0016$H+\u00192mKRK\b/Z:\u0015\t\t\u001d#\u0011\u001e\u0005\u0007\u00037\u0002\u0002\u0019A#)\u0011\t%\u0018qLA3\u0003OBs\u0001EA7\u0003K\u0012y/\t\u0002\u0003r\u0006)3p]3tg&|g\u000eS1oI2,WpL8qKJ\fG/[8og>\"\u0018M\u00197f)f\u0004Xm\u001d\u0015\u0004!\t5\u0001F\u0004\tw\u0003\u001b\ty!a\u0005\u0003x\u0006\r#\u0011 \u0017\u0003\u0005W\n#Aa?\u0002[\r\u0013X-\u0019;fA\u0005t\u0007e\u001c9fe\u0006$\u0018n\u001c8!o&$\b\u000eI$F)~#\u0016I\u0011'F?RK\u0006+R*!if\u0004X-\u0001\u0006hKR\u001cu\u000e\\;n]N$bAa\u0012\u0004\u0002\r\u0015\u0001BBA.#\u0001\u0007Q\t\u000b\u0005\u0004\u0002\u0005}\u0013QMA4\u0011\u001d\u0011\u0019!\u0005a\u0001\u0007\u000f\u00012!YB\u0005\u0013\r\u0019YA\u0019\u0002\u0012\u000f\u0016$8i\u001c7v[:\u001c(+Z9vKN$\bfB\t\u0002n\u0005\u00154qB\u0011\u0003\u0007#\t!e_:fgNLwN\u001c%b]\u0012dW-`\u0018pa\u0016\u0014\u0018\r^5p]N|3m\u001c7v[:\u001c\bfA\t\u0003\u000e!r\u0011C^A\u0007\u0003\u001f\t\u0019ba\u0006\u0002D\reAF\u0001B6C\t\u0019Y\"A\u0015De\u0016\fG/\u001a\u0011b]\u0002z\u0007/\u001a:bi&|g\u000eI<ji\"\u0004s)\u0012+`\u0007>cU+\u0014(TAQL\b/Z\u0001\rO\u0016$h)\u001e8di&|gn\u001d\u000b\u0007\u0005\u000f\u001a\tc!\n\t\r\u0005m#\u00031\u0001FQ!\u0019\t#a\u0018\u0002f\u0005\u001d\u0004b\u0002B\u0002%\u0001\u00071q\u0005\t\u0004C\u000e%\u0012bAB\u0016E\n\u0019r)\u001a;Gk:\u001cG/[8ogJ+\u0017/^3ti\":!#!\u001c\u0002f\r=\u0012EAB\u0019\u0003\u0011Z8/Z:tS>t\u0007*\u00198eY\u0016lxf\u001c9fe\u0006$\u0018n\u001c8t_\u0019,hn\u0019;j_:\u001c\bf\u0001\n\u0003\u000e!r!C^A\u0007\u0003\u001f\t\u0019ba\u000e\u0002D\reBF\u0001B6C\t\u0019Y$A\u0016De\u0016\fG/\u001a\u0011b]\u0002z\u0007/\u001a:bi&|g\u000eI<ji\"\u0004s)\u0012+`\rVs5\tV%P\u001dN\u0003C/\u001f9f\u000399W\r\u001e)sS6\f'/_&fsN$bAa\u0012\u0004B\r\u0015\u0003BBA.'\u0001\u0007Q\t\u000b\u0005\u0004B\u0005}\u0013QMA4\u0011\u001d\u0011\u0019a\u0005a\u0001\u0007\u000f\u00022!YB%\u0013\r\u0019YE\u0019\u0002\u0016\u000f\u0016$\bK]5nCJL8*Z=t%\u0016\fX/Z:uQ\u001d\u0019\u0012QNA3\u0007\u001f\n#a!\u0015\u0002Mm\u001cXm]:j_:D\u0015M\u001c3mKv|s\u000e]3sCRLwN\\:0aJLW.\u0019:z\u0017\u0016L8\u000fK\u0002\u0014\u0005\u001bAcb\u0005<\u0002\u000e\u0005=\u00111CB,\u0003\u0007\u001aI\u0006\f\u0002\u0003l\u0005\u001211L\u0001.\u0007J,\u0017\r^3!C:\u0004s\u000e]3sCRLwN\u001c\u0011xSRD\u0007eR#U?B\u0013\u0016*T!S3~[U)\u0017\u0011usB,\u0017!E4fi\u000e\u0013xn]:SK\u001a,'/\u001a8dKR1!qIB1\u0007KBa!a\u0017\u0015\u0001\u0004)\u0005\u0006CB1\u0003?\n)'a\u001a\t\u000f\t\rA\u00031\u0001\u0004hA\u0019\u0011m!\u001b\n\u0007\r-$M\u0001\rHKR\u001c%o\\:t%\u00164WM]3oG\u0016\u0014V-];fgRDs\u0001FA7\u0003K\u001ay'\t\u0002\u0004r\u0005I3p]3tg&|g\u000eS1oI2,WpL8qKJ\fG/[8og>\u001a'o\\:t%\u00164WM]3oG\u0016D3\u0001\u0006B\u0007Q9!b/!\u0004\u0002\u0010\u0005M1qOA\"\u0007sb#Aa\u001b\"\u0005\rm\u0014!M\"sK\u0006$X\rI1oA=\u0004XM]1uS>t\u0007e^5uQ\u0002:U\tV0D%>\u001b6k\u0018*F\r\u0016\u0013VIT\"FAQL\b/\u001a\u0015\b\u0001\r}\u0014QMBC!\ra7\u0011Q\u0005\u0004\u0007\u0007k'\u0001C\"p]N,X.Z:-\u0005\u0005\u001d\u0002f\u0002\u0001\u0004\n\u0006\u00154q\u0012\t\u0004Y\u000e-\u0015bABG[\nA\u0001K]8ek\u000e,7\u000f\f\u0002\u0002(!:\u0001aa%\u0004 \u000e\u0005\u0006\u0003BBK\u00077k!aa&\u000b\u0007\re%0\u0001\u0003uC\u001e\u001c\u0018\u0002BBO\u0007/\u00131\u0001V1h\u0003\u0011q\u0017-\\3\"\u0005\r\r\u0016aB*fgNLwN\\\u0001\u0011'\u0016\u001c8/[8ogJ+7o\\;sG\u0016\u0004\"A\u000f\f\u0014\u0005YACCABT\u0003a\u0019ViU*J\u001f:{\u0006KU(U\u001f\u000e{Ej\u0018,F%NKuJT\u000b\u0003\u0007c{!aa-%\u0005\rU\u0016\u0002BB\\\u0007s\u000bA\u0004S%W\u000b~\u001bE*S0T\u000bJ3\u0016jQ#`!J{EkT\"P\u0019~3\u0016G\u0003\u0003\u0004<\u000eu\u0016\u0001\u0005+Qe>$xnY8m-\u0016\u00148/[8o\u0015\u0011\u0019yl!1\u0002\rQD'/\u001b4u\u0015\u0011\u0019\u0019m!2\u0002\u0007I\u00048M\u0003\u0003\u0004H\u000e%\u0017aB:feZL7-\u001a\u0006\u0004\u0007\u0017\u001c\u0013\u0001\u00025jm\u0016\f\u0011dU#T'&{ej\u0018)S\u001fR{5i\u0014'`-\u0016\u00136+S(OA\u0001")
public class SessionsResource
implements ApiRequestContext,
Logging {
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public static TProtocolVersion SESSION_PROTOCOL_VERSION() {
        return SessionsResource$.MODULE$.SESSION_PROTOCOL_VERSION();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiRestFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    public org.apache.kyuubi.session.SessionHandle toSessionHandle(String str) {
        return SessionHandle$.MODULE$.fromUUID(str);
    }

    private SessionManager sessionManager() {
        return this.fe().be().sessionManager();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=SessionData.class)))}, description="get the list of all live sessions")
    @GET
    public Seq<SessionData> sessions() {
        return ((TraversableOnce)this.sessionManager().allSessions().map((Function1 & Serializable & scala.Serializable)session -> new SessionData(session.handle().identifier().toString(), session.user(), session.ipAddress(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)session.conf()).asJava(), Predef$.MODULE$.long2Long(session.createTime()), Predef$.MODULE$.long2Long(session.lastAccessTime() - session.createTime()), Predef$.MODULE$.long2Long(session.getNoOperationTime())), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=KyuubiEvent.class))}, description="get a session event via session handle identifier")
    @GET
    @Path(value="{sessionHandle}")
    public KyuubiEvent sessionInfo(@PathParam(value="sessionHandle") String sessionHandleStr) {
        KyuubiEvent kyuubiEvent;
        try {
            kyuubiEvent = (KyuubiEvent)((KyuubiSession)this.sessionManager().getSession(this.toSessionHandle(sessionHandleStr))).getSessionEvent().get();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Invalid ").append(sessionHandleStr).toString(), e);
                throw new NotFoundException(new StringBuilder(8).append("Invalid ").append(sessionHandleStr).toString());
            }
            throw throwable;
        }
        return kyuubiEvent;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=InfoDetail.class))}, description="get a information detail via session handle identifier and a specific information type")
    @GET
    @Path(value="{sessionHandle}/info/{infoType}")
    public InfoDetail getInfo(@PathParam(value="sessionHandle") String sessionHandleStr, @PathParam(value="infoType") int infoType) {
        InfoDetail infoDetail;
        try {
            TGetInfoType info = TGetInfoType.findByValue((int)infoType);
            TGetInfoValue infoValue = this.fe().be().getInfo(this.toSessionHandle(sessionHandleStr), info);
            infoDetail = new InfoDetail(info.toString(), infoValue.getStringValue());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString(), e);
                throw new NotFoundException(new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString());
            }
            throw throwable;
        }
        return infoDetail;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=SessionOpenCount.class))}, description="Get the current open session count")
    @GET
    @Path(value="count")
    public SessionOpenCount sessionCount() {
        return new SessionOpenCount(this.sessionManager().getOpenSessionCount());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ExecPoolStatistic.class))}, description="Get statistic info of background executors")
    @GET
    @Path(value="execPool/statistic")
    public ExecPoolStatistic execPoolStatistic() {
        return new ExecPoolStatistic(this.sessionManager().getExecPoolSize(), this.sessionManager().getActiveCount());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Open(create) a session")
    @POST
    public SessionHandle openSession(SessionOpenRequest request) {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConfigs()).asScala()).toMap(Predef$.MODULE$.$conforms()));
        String ipAddress = this.fe().getIpAddress();
        org.apache.kyuubi.session.SessionHandle handle = this.fe().be().openSession(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1, userName, "", ipAddress, ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConfigs()).asScala()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.client.ipAddress"), (Object)ipAddress), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.server.ipAddress"), (Object)this.fe().host()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.connection.url"), (Object)this.fe().connectionUrl()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.real.user"), (Object)this.fe().getRealUser())}))).toMap(Predef$.MODULE$.$conforms()));
        return new SessionHandle(handle.identifier(), this.fe().connectionUrl());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Close a session")
    @DELETE
    @Path(value="{sessionHandle}")
    public Response closeSession(@PathParam(value="sessionHandle") String sessionHandleStr) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Received request of closing ").append(sessionHandleStr).toString());
        this.fe().be().closeSession(this.toSessionHandle(sessionHandleStr));
        return Response.ok().build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with EXECUTE_STATEMENT type")
    @POST
    @Path(value="{sessionHandle}/operations/statement")
    public OperationHandle executeStatement(@PathParam(value="sessionHandle") String sessionHandleStr, StatementRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().executeStatement(this.toSessionHandle(sessionHandleStr), request.getStatement(), ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConfOverlay()).asScala()).toMap(Predef$.MODULE$.$conforms()), request.isRunAsync(), Predef$.MODULE$.Long2long(request.getQueryTimeout()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error executing statement";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_TYPE_INFO type")
    @POST
    @Path(value="{sessionHandle}/operations/typeInfo")
    public OperationHandle getTypeInfo(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTypeInfo(this.toSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting type information";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_CATALOGS type")
    @POST
    @Path(value="{sessionHandle}/operations/catalogs")
    public OperationHandle getCatalogs(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getCatalogs(this.toSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting catalogs";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_SCHEMAS type")
    @POST
    @Path(value="{sessionHandle}/operations/schemas")
    public OperationHandle getSchemas(@PathParam(value="sessionHandle") String sessionHandleStr, GetSchemasRequest request) {
        OperationHandle operationHandle;
        try {
            OperationHandle operationHandle2;
            operationHandle = operationHandle2 = this.fe().be().getSchemas(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting schemas";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_TABLES type")
    @POST
    @Path(value="{sessionHandle}/operations/tables")
    public OperationHandle getTables(@PathParam(value="sessionHandle") String sessionHandleStr, GetTablesRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTables(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getTableName(), request.getTableTypes());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting tables";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_TABLE_TYPES type")
    @POST
    @Path(value="{sessionHandle}/operations/tableTypes")
    public OperationHandle getTableTypes(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getTableTypes(this.toSessionHandle(sessionHandleStr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting table types";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_COLUMNS type")
    @POST
    @Path(value="{sessionHandle}/operations/columns")
    public OperationHandle getColumns(@PathParam(value="sessionHandle") String sessionHandleStr, GetColumnsRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getColumns(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getTableName(), request.getColumnName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting columns";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_FUNCTIONS type")
    @POST
    @Path(value="{sessionHandle}/operations/functions")
    public OperationHandle getFunctions(@PathParam(value="sessionHandle") String sessionHandleStr, GetFunctionsRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getFunctions(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getFunctionName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting functions";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_PRIMARY_KEY type")
    @POST
    @Path(value="{sessionHandle}/operations/primaryKeys")
    public OperationHandle getPrimaryKeys(@PathParam(value="sessionHandle") String sessionHandleStr, GetPrimaryKeysRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getPrimaryKeys(this.toSessionHandle(sessionHandleStr), request.getCatalogName(), request.getSchemaName(), request.getTableName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting primary keys";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationHandle.class))}, description="Create an operation with GET_CROSS_REFERENCE type")
    @POST
    @Path(value="{sessionHandle}/operations/crossReference")
    public OperationHandle getCrossReference(@PathParam(value="sessionHandle") String sessionHandleStr, GetCrossReferenceRequest request) {
        OperationHandle operationHandle;
        try {
            operationHandle = this.fe().be().getCrossReference(this.toSessionHandle(sessionHandleStr), request.getPrimaryCatalog(), request.getPrimarySchema(), request.getPrimaryTable(), request.getForeignCatalog(), request.getForeignSchema(), request.getForeignTable());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting cross reference";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationHandle;
    }

    public SessionsResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
    }
}

